/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include <stdio.h>
#include <string.h>
#include <unistd.h>

char* trim(char* source)
{
	size_t len;
	len = strlen(source);
	if(len <= 0)
		return source;
	
	if(source[len - 1] == '\n')
		source[len - 1] = '\0';
	return source;
}

int main(int argc, char* argv[])
{
	char buf[1024];
	FILE *in_fp;

	if(argc < 2){
		printf("You must always specify the source file name.\n");
		return(1);
	}

	in_fp = fopen(argv[1], "r");
	if(!in_fp){
		printf("Failed to open the file.\n");
		return(1);
	}

	printf("/*\n");
	printf(" * This file is generated by the help_gen auto source file generator.\n");
	printf(" */\n\n");

	printf("#include <stdio.h>\n\n");
	printf("void print_help()\n{\n");

	while(fgets(buf,sizeof(buf)-1, in_fp)){
		if(0 == strlen(buf))
			printf(" \n");
		else
			printf("\tprintf(\"%s\\n\");\n", trim(buf));
	}

	printf("\n}\n");

	fclose(in_fp);
}
