/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include <stdlib.h>
#include <assert.h>

#define MODEL_2CH_PRIVATE_DATA

#include "utils/nt_std_t.h"
#include "utils/text.h"
#include "html/html_string.h"
#include "_2ch/model_2ch.h"

const wchar_t* nt_category_get_name(nt_category_handle h_category)
{
	nt_category_tp categoryp;
	assert(h_category);
	assert(h_category->chk_sum == NT_2CH_CATEGORY_CHK_SUM);
	categoryp = (nt_category_tp)h_category;
	assert(categoryp->name);
	return categoryp->name;
}

int nt_category_get_board_count(nt_category_handle h_category)
{
	nt_category_tp categoryp;
	assert(h_category);
	assert(h_category->chk_sum == NT_2CH_CATEGORY_CHK_SUM);
	categoryp = (nt_category_tp)h_category;
	if(!categoryp->boardlistp)
		return 0;
	return nt_link_num(categoryp->boardlistp);
}

const wchar_t* nt_board_get_name(nt_board_handle h_board)
{
	nt_board_tp boardp;
	assert(h_board);
	assert(h_board->chk_sum == NT_2CH_BOARD_CHK_SUM);
	boardp = (nt_board_tp)h_board;
	assert(boardp->name);
	return boardp->name;
}

const wchar_t* nt_board_get_address(nt_board_handle h_board)
{
	nt_board_tp boardp;
	assert(h_board);
	assert(h_board->chk_sum == NT_2CH_BOARD_CHK_SUM);
	boardp = (nt_board_tp)h_board;
	assert(boardp->address);
	return boardp->address;
}

int nt_board_get_thread_count(nt_board_handle h_board)
{
	nt_board_tp boardp;
	assert(h_board);
	assert(h_board->chk_sum == NT_2CH_BOARD_CHK_SUM);
	boardp = (nt_board_tp)h_board;
	if(!boardp->threadlistp)
		return 0;
	return nt_link_num(boardp->threadlistp);
}

int nt_thread_get_seq_number(nt_thread_handle h_thread)
{
	nt_thread_tp threadp;
	assert(h_thread);
	assert(h_thread->chk_sum == NT_2CH_THREAD_CHK_SUM);
	threadp = (nt_thread_tp)h_thread;
	return threadp->seq_no;
}

const wchar_t* nt_thread_get_title(nt_thread_handle h_thread)
{
	nt_thread_tp threadp;
	assert(h_thread);
	assert(h_thread->chk_sum == NT_2CH_THREAD_CHK_SUM);
	threadp = (nt_thread_tp)h_thread;
	assert(threadp->name);
	return threadp->name;
}

const wchar_t* nt_thread_get_dat_name(nt_thread_handle h_thread)
{
	nt_thread_tp threadp;
	assert(h_thread);
	assert(h_thread->chk_sum == NT_2CH_THREAD_CHK_SUM);
	threadp = (nt_thread_tp)h_thread;
	assert(threadp->file_name);
	return threadp->file_name;
}

int nt_thread_get_res_count(nt_thread_handle h_thread)
{
	nt_thread_tp threadp;
	assert(h_thread);
	assert(h_thread->chk_sum == NT_2CH_THREAD_CHK_SUM);
	threadp = (nt_thread_tp)h_thread;
	return threadp->num_res;
}

int nt_res_get_seq_number(nt_res_handle h_res)
{
	nt_res_tp resp;
	assert(h_res);
	assert(h_res->chk_sum == NT_2CH_RES_CHK_SUM);
	resp = (nt_res_tp)h_res;
	return resp->seq_no;
}

const wchar_t* nt_res_get_name(nt_res_handle h_res)
{
	nt_res_tp resp;
	assert(h_res);
	assert(h_res->chk_sum == NT_2CH_RES_CHK_SUM);
	resp = (nt_res_tp)h_res;
	assert(resp->name);
	return resp->name;
}

const wchar_t* nt_res_get_mail(nt_res_handle h_res)
{
	nt_res_tp resp;
	assert(h_res);
	assert(h_res->chk_sum == NT_2CH_RES_CHK_SUM);
	resp = (nt_res_tp)h_res;
	assert(resp->mail);
	return resp->mail;
}

const wchar_t* nt_res_get_misc(nt_res_handle h_res)
{
	nt_res_tp resp;
	assert(h_res);
	assert(h_res->chk_sum == NT_2CH_RES_CHK_SUM);
	resp = (nt_res_tp)h_res;
	assert(resp->misc);
	return resp->misc;
}

const wchar_t* nt_res_get_msg(nt_res_handle h_res)
{
	nt_res_tp resp;
	assert(h_res);
	assert(h_res->chk_sum == NT_2CH_RES_CHK_SUM);
	resp = (nt_res_tp)h_res;
	assert(resp->msg);
	return resp->msg;
}

const wchar_t* nt_2ch_selected_item_get_board_name(
			nt_2ch_selected_item_handle h_select)
{
	nt_2ch_selected_item_tp selectp;
	assert(h_select);
	assert(h_select->chk_sum == NT_2CH_SELECTED_ITEM_CHK_SUM);
	selectp = (nt_2ch_selected_item_tp)h_select;
	if(!selectp->selected_boardp)
		return NULL;
	return nt_board_get_name(&selectp->selected_boardp->handle);
}

const wchar_t* nt_2ch_selected_item_get_thread_title(
			nt_2ch_selected_item_handle h_select)
{
	nt_2ch_selected_item_tp selectp;
	assert(h_select);
	assert(h_select->chk_sum == NT_2CH_SELECTED_ITEM_CHK_SUM);
	selectp = (nt_2ch_selected_item_tp)h_select;
	if(!selectp->selected_threadp)
		return NULL;
	return nt_thread_get_title(&selectp->selected_threadp->handle);
}

const wchar_t* nt_2ch_selected_item_get_thread_dat_name(
			nt_2ch_selected_item_handle h_select)
{
	nt_2ch_selected_item_tp selectp;
	assert(h_select);
	assert(h_select->chk_sum == NT_2CH_SELECTED_ITEM_CHK_SUM);
	selectp = (nt_2ch_selected_item_tp)h_select;
	if(!selectp->selected_threadp)
		return NULL;
	return nt_thread_get_dat_name(&selectp->selected_threadp->handle);
}

const wchar_t* nt_write_data_get_status_msg(
			nt_write_data_handle h_write_data)
{
	nt_write_data_tp writep;
	assert(h_write_data);
	assert(h_write_data->chk_sum == NT_2CH_WRITE_DATA_CHK_SUM);
	writep = (nt_write_data_tp)h_write_data;
	if(!writep->status_msg)
		return NULL;
	return writep->status_msg;
}

const wchar_t* nt_write_data_get_html_result(
			nt_write_data_handle h_write_data)
{
	nt_write_data_tp writep;
	assert(h_write_data);
	assert(h_write_data->chk_sum == NT_2CH_WRITE_DATA_CHK_SUM);
	writep = (nt_write_data_tp)h_write_data;
	if(!writep->result_html)
		return NULL;
	return writep->result_html;
}

const char* nt_write_data_get_name(nt_write_data_handle h_write_data)
{
	nt_write_data_tp writep;
	assert(h_write_data);
	assert(h_write_data->chk_sum == NT_2CH_WRITE_DATA_CHK_SUM);
	writep = (nt_write_data_tp)h_write_data;
	return writep->name;
}

const char* nt_write_data_get_mail(nt_write_data_handle h_write_data)
{
	nt_write_data_tp writep;
	assert(h_write_data);
	assert(h_write_data->chk_sum == NT_2CH_WRITE_DATA_CHK_SUM);
	writep = (nt_write_data_tp)h_write_data;
	return writep->mail;
}

const char* nt_write_data_get_msg(nt_write_data_handle h_write_data)
{
	nt_write_data_tp writep;
	assert(h_write_data);
	assert(h_write_data->chk_sum == NT_2CH_WRITE_DATA_CHK_SUM);
	writep = (nt_write_data_tp)h_write_data;
	return writep->msg;
}

void nt_write_data_set_status_msg(
			nt_write_data_handle h_write_data, const wchar_t *status_msg)
{
	nt_write_data_tp writep;
	assert(h_write_data);
	assert(h_write_data->chk_sum == NT_2CH_WRITE_DATA_CHK_SUM);
	writep = (nt_write_data_tp)h_write_data;
	if(writep->status_msg)
		free(writep->status_msg);
	writep->status_msg = nt_w_str_clone(status_msg);
}

void nt_write_data_set_html_result(
			nt_write_data_handle h_write_data, const wchar_t *html_result)
{
	nt_write_data_tp writep;
	assert(h_write_data);
	assert(h_write_data->chk_sum == NT_2CH_WRITE_DATA_CHK_SUM);
	writep = (nt_write_data_tp)h_write_data;
	if(writep->result_html)
		free(writep->result_html);
	writep->result_html = nt_w_str_clone(html_result);
}

void nt_write_data_set_name(
			nt_write_data_handle h_write_data, const char *name)
{
	nt_write_data_tp writep;
	assert(h_write_data);
	assert(h_write_data->chk_sum == NT_2CH_WRITE_DATA_CHK_SUM);
	writep = (nt_write_data_tp)h_write_data;
	if(writep->name)
		free(writep->name);
	writep->name = nt_str_clone(name);
}

void nt_write_data_set_mail(
			nt_write_data_handle h_write_data, const char *mail)
{
	nt_write_data_tp writep;
	assert(h_write_data);
	assert(h_write_data->chk_sum == NT_2CH_WRITE_DATA_CHK_SUM);
	writep = (nt_write_data_tp)h_write_data;
	if(writep->mail)
		free(writep->mail);
	writep->mail = nt_str_clone(mail);
}

void nt_write_data_set_msg(
			nt_write_data_handle h_write_data, const char *msg)
{
	nt_write_data_tp writep;
	assert(h_write_data);
	assert(h_write_data->chk_sum == NT_2CH_WRITE_DATA_CHK_SUM);
	writep = (nt_write_data_tp)h_write_data;
	if(writep->msg)
		free(writep->msg);
	writep->msg = nt_str_clone(msg);
}


void nt_set_selected_board(nt_2ch_selected_item_handle h_select,
         nt_category_handle h_category, nt_board_handle h_board)
{
	nt_2ch_selected_item_tp selectp;
	assert(h_select);
	assert(h_category);
	assert(h_board);
	assert(h_select->chk_sum == NT_2CH_SELECTED_ITEM_CHK_SUM);
	assert(h_category->chk_sum == NT_2CH_CATEGORY_CHK_SUM);
	assert(h_board->chk_sum == NT_2CH_BOARD_CHK_SUM);
	
	selectp = (nt_2ch_selected_item_tp)h_select;
	
	if(selectp->selected_categoryp != NULL)
		nt_category_release_ref(&selectp->selected_categoryp->handle);
	if(selectp->selected_boardp != NULL)
		nt_board_release_ref(&selectp->selected_boardp->handle);
	if(selectp->selected_threadp != NULL)
		nt_thread_release_ref(&selectp->selected_threadp->handle);
	
	nt_category_add_ref(h_category);
	nt_board_add_ref(h_board);
	
	selectp->selected_categoryp = (nt_category_tp)h_category;
	selectp->selected_boardp = (nt_board_tp)h_board;
	selectp->selected_threadp = NULL;
	
}

void nt_set_selected_thread(nt_2ch_selected_item_handle h_select,
        nt_thread_handle h_thread)
{
	nt_2ch_selected_item_tp selectp;
	assert(h_select);
	assert(h_thread);
	assert(h_select->chk_sum == NT_2CH_SELECTED_ITEM_CHK_SUM);
	assert(h_thread->chk_sum == NT_2CH_THREAD_CHK_SUM);
	
	selectp = (nt_2ch_selected_item_tp)h_select;
	assert(selectp->selected_categoryp);
	assert(selectp->selected_boardp);
	
	if(selectp->selected_threadp != NULL)
		nt_thread_release_ref(&selectp->selected_threadp->handle);
	selectp->selected_threadp = (nt_thread_tp)h_thread;
	nt_thread_add_ref(h_thread);
}


nt_category_handle nt_get_selected_category(nt_2ch_selected_item_handle h_select)
{
	nt_2ch_selected_item_tp selectp;
	assert(h_select);
	assert(h_select->chk_sum == NT_2CH_SELECTED_ITEM_CHK_SUM);
	selectp = (nt_2ch_selected_item_tp)h_select;
	if(!selectp->selected_categoryp)
		return NULL;
	nt_category_add_ref(&selectp->selected_categoryp->handle);
	return &selectp->selected_categoryp->handle;
}

nt_board_handle nt_get_selected_board(nt_2ch_selected_item_handle h_select)
{
	nt_2ch_selected_item_tp selectp;
	assert(h_select);
	assert(h_select->chk_sum == NT_2CH_SELECTED_ITEM_CHK_SUM);
	selectp = (nt_2ch_selected_item_tp)h_select;
	if(!selectp->selected_boardp)
		return NULL;
	nt_board_add_ref(&selectp->selected_boardp->handle);
	return &selectp->selected_boardp->handle;
}

nt_thread_handle nt_get_selected_thread(nt_2ch_selected_item_handle h_select)
{
	nt_2ch_selected_item_tp selectp;
	assert(h_select);
	assert(h_select->chk_sum == NT_2CH_SELECTED_ITEM_CHK_SUM);
	selectp = (nt_2ch_selected_item_tp)h_select;
	if(!selectp->selected_threadp)
		return NULL;
	nt_thread_add_ref(&selectp->selected_threadp->handle);
	return &selectp->selected_threadp->handle;
}




