/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _DISP_H_
#define _DISP_H_

#ifdef HAVE_NCURSESW_NCURSES_H
#include <ncursesw/ncurses.h>
#else
#include <ncurses.h>
#endif

#include "ui/disp_win.h"
#include "_2ch/model_2ch.h"
#include "_2ch/search_2ch.h"
#include "usr/favorite_t.h"
#include "usr/usr_db_t.h"
#include "usr/ng_word_t.h"

#define DISP_STATE_MASK 0xff
#define DISP_CMD_MASK 0xff00

#define DISP_STATE(a) ((a)&DISP_STATE_MASK)
#define DISP_CMD(a) ((a)&DISP_CMD_MASK)
#define DISP_CLR_CMD(a) ((a)&=DISP_STATE_MASK)


#define	DISP_STATE_ERROR			(-1)
#define	DISP_STATE_BOARDMENU		1
#define	DISP_STATE_THREADTITLE		2
#define	DISP_STATE_RESLIST			3
#define	DISP_STATE_EDITOR			4 
#define	DISP_STATE_HTML_RESULT		5
#define	DISP_STATE_SEARCH_THREAD	6
#define	DISP_STATE_FAVORITE			7
#define	DISP_STATE_HISTORY			8

#define DISP_CMD_ADD_FAVORITE (1*256)
#define DISP_CMD_DEL_FAVORITE_BOARD (2*256)
#define DISP_CMD_DEL_FAVORITE_GRP (3*256)
#define DISP_CMD_DEL_FAVORITE_THREAD (4*256)
#define DISP_CMD_SEL_BOARD (5*256)
#define DISP_CMD_SEL_THREAD (6*256)
#define DISP_CMD_UPDATE_FAVORITE (7*256)
#define DISP_CMD_AUTO_SCROLL (8*256)
#define DISP_CMD_UPLOAD_ALL (9*256)
#define DISP_CMD_UPLOAD_BOARDS (10*256)
#define DISP_CMD_UPLOAD_THREADS (11*256)
#define DISP_CMD_REFRESH (12*256)
#define DISP_CMD_REENTER (13*256)
#define DISP_CMD_EDIT_NGWORD (14*256)
#define DISP_CMD_EDIT_NGNAME (15*256)
#define DISP_CMD_EDIT_NGID (16*256)
#define DISP_CMD_UPLOAD_NG_FILES (17*256)
#define DISP_CMD_EDIT_FAVORITE_BOARD (18*256)
#define DISP_CMD_EDIT_FAVORITE_THREAD (19*256)


extern int disp_board_menu(nt_window_tp wp, 
		nt_2ch_model_handle h_model, nt_2ch_selected_item_handle h_select);
extern int disp_threadlist(nt_window_tp wp, int state,
		nt_2ch_selected_item_handle h_select, nt_usr_db_handle usr_db_handle);
extern int disp_reslist(nt_window_tp wp, int state,
		nt_2ch_selected_item_handle h_select, nt_usr_db_handle usr_db_handle,
		nt_ng_word_handle h_ng_word, nt_cloud_handle h_cloud);
extern int disp_thread_search(nt_window_tp wp, 
		int prev_state, nt_link_tp thread_list, 
		nt_searched_thread_handle *h_sel_threadp);
extern int disp_favorite(nt_window_tp wp, int prev_state, 
		nt_2ch_model_handle h_model, nt_favorite_handle h_favorite, 
		nt_usr_db_handle h_usr_db,
		void **result_hadle, nt_searched_thread_handle *h_sel_threadp);
extern int disp_history(nt_window_tp wp, int prev_state, 
		nt_2ch_model_handle h_model, 
		nt_usr_db_handle h_usr_db,
		nt_searched_thread_handle *h_sel_threadp,
		nt_link_tp *update_board_list);
extern void free_board_menu_ctx(void *ptr);
extern void init_threadlist_ctx(void *ptr);
extern void free_threadlist_ctx(void *ptr);
extern void free_reslist_ctx(void *ptr);
extern void free_search_thread_ctx(void *ptr);
extern void free_favorite_ctx(void *ptr);
extern void free_history_ctx(void *ptr);
extern BOOL disp_editor(nt_write_data_handle h_write_data);
extern BOOL disp_editor2(const char *file_name);
extern nt_link_tp disp_editor3(nt_link_tp text_list);
extern int disp_html_result(nt_write_data_handle h_write_data);

#endif /* _DISP_H_ */

