<?php
/*
 nce (ntch cloud environment.)
 name: http_util.php
 author: Akira Ohta (akohta001.gmail.com)
 date: 2013-apr-13th
 License: GPLv3
 */
$needle_64encode = array("=","+","/","=","+","/");
$needle_urlencode = array("%3D","%2B","%2F","%3d","%2b","%2f");
$base64_param_pattern = "/^([a-zA-Z0-9]|\%2B|\%2F|\+|\/)+(\%3D|=){0,2}$/i";
$file_name_pattern = "/^(\w)+((\.)?[a-zA-Z0-9]*)*$/";

function replace_64symbol2urlencode($source){
	global $needle_64encode;
	global $needle_urlencode;
	$result = str_replace($needle_64encode, 
		$needle_urlencode, $source);
	return $result;
}

function replace_urlencodeTo64symbol($source){
	global $needle_64encode;
	global $needle_urlencode;
	$result = str_replace($needle_urlencode, 
		$needle_64encode, $source);
	return $result;
}

function inspect_base64_param($param){
	global $base64_param_pattern;
	if(preg_match($base64_param_pattern, $param)){
		return TRUE;
	}else{
		return FALSE;
	}
}
function inspect_file_name($param){
	global $file_name_pattern;
	if(preg_match($file_name_pattern, $param)){
		return TRUE;
	}else{
		return FALSE;
	}
}
?>