CREATE TABLE `nucleus_actionlog` (
  `timestamp` datetime NOT NULL default '0000-00-00 00:00:00',
  `message` varchar(255) NOT NULL default ''
) TYPE=MyISAM;

CREATE TABLE `nucleus_activation` (
  `vkey` varchar(40) NOT NULL default '',
  `vtime` datetime NOT NULL default '0000-00-00 00:00:00',
  `vmember` int(11) NOT NULL default '0',
  `vtype` varchar(15) NOT NULL default '',
  `vextra` varchar(128) NOT NULL default '',
  PRIMARY KEY  (`vkey`)
) TYPE=MyISAM;

CREATE TABLE `nucleus_ban` (
  `iprange` varchar(15) NOT NULL default '',
  `reason` varchar(255) NOT NULL default '',
  `blogid` int(11) NOT NULL default '0'
) TYPE=MyISAM;

CREATE TABLE `nucleus_blog` (
  `bnumber` int(11) NOT NULL auto_increment,
  `bname` varchar(60) NOT NULL default '',
  `bshortname` varchar(15) NOT NULL default '',
  `bdesc` varchar(200) default NULL,
  `bcomments` tinyint(2) NOT NULL default '1',
  `bmaxcomments` int(11) NOT NULL default '0',
  `btimeoffset` decimal(3,1) NOT NULL default '0.0',
  `bnotify` varchar(60) default NULL,
  `burl` varchar(100) default NULL,
  `bupdate` varchar(60) default NULL,
  `bdefskin` int(11) NOT NULL default '1',
  `bpublic` tinyint(2) NOT NULL default '1',
  `bsendping` tinyint(2) NOT NULL default '0',
  `bconvertbreaks` tinyint(2) NOT NULL default '1',
  `bdefcat` int(11) default NULL,
  `bnotifytype` int(11) NOT NULL default '15',
  `ballowpast` tinyint(2) NOT NULL default '0',
  `bincludesearch` tinyint(2) NOT NULL default '0',
  `breqemail` TINYINT( 2 ) DEFAULT '0' NOT NULL,
  `bfuturepost` TINYINT(2) DEFAULT '0' NOT NULL,
  PRIMARY KEY  (`bnumber`),
  UNIQUE KEY `bnumber` (`bnumber`),
  UNIQUE KEY `bshortname` (`bshortname`)
) TYPE=MyISAM;

INSERT INTO `nucleus_blog` VALUES (1, 'My Nucleus CMS', 'mynucleuscms', '', 1, 0, 0.0, '', 'http://localhost:8080/nucleus/', '', 5, 1, 0, 1, 1, 1, 1, 0, 0, 0);

CREATE TABLE `nucleus_category` (
  `catid` int(11) NOT NULL auto_increment,
  `cblog` int(11) NOT NULL default '0',
  `cname` varchar(200) default NULL,
  `cdesc` varchar(200) default NULL,
  PRIMARY KEY  (`catid`)
) TYPE=MyISAM;

INSERT INTO `nucleus_category` VALUES (1, 1, 'General', 'Items that do not fit in other categories');

CREATE TABLE `nucleus_comment` (
  `cnumber` int(11) NOT NULL auto_increment,
  `cbody` text NOT NULL,
  `cuser` varchar(40) default NULL,
  `cmail` varchar(100) default NULL,
  `cemail` VARCHAR( 100 ),
  `cmember` int(11) default NULL,
  `citem` int(11) NOT NULL default '0',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `chost` varchar(60) default NULL,
  `cip` varchar(15) NOT NULL default '',
  `cblog` int(11) NOT NULL default '0',
  PRIMARY KEY  (`cnumber`),
  UNIQUE KEY `cnumber` (`cnumber`),
  KEY `citem` (`citem`),
  FULLTEXT KEY `cbody` (`cbody`)
) TYPE=MyISAM;

CREATE TABLE `nucleus_config` (
  `name` varchar(20) NOT NULL default '',
  `value` varchar(128) default NULL,
  PRIMARY KEY  (`name`)
) TYPE=MyISAM;

INSERT INTO `nucleus_config` VALUES ('DefaultBlog', '1');
INSERT INTO `nucleus_config` VALUES ('AdminEmail', 'example@example.org');
INSERT INTO `nucleus_config` VALUES ('IndexURL', 'http://localhost:8080/nucleus/');
INSERT INTO `nucleus_config` VALUES ('Language', 'japanese-euc');
INSERT INTO `nucleus_config` VALUES ('SessionCookie', '');
INSERT INTO `nucleus_config` VALUES ('AllowMemberCreate', '');
INSERT INTO `nucleus_config` VALUES ('AllowMemberMail', '1');
INSERT INTO `nucleus_config` VALUES ('SiteName', 'My Nucleus CMS');
INSERT INTO `nucleus_config` VALUES ('AdminURL', 'http://localhost:8080/nucleus/nucleus/');
INSERT INTO `nucleus_config` VALUES ('NewMemberCanLogon', '1');
INSERT INTO `nucleus_config` VALUES ('DisableSite', '');
INSERT INTO `nucleus_config` VALUES ('DisableSiteURL', 'http://www.this-page-intentionally-left-blank.org/');
INSERT INTO `nucleus_config` VALUES ('LastVisit', '');
INSERT INTO `nucleus_config` VALUES ('MediaURL', 'http://localhost:8080/nucleus/media/');
INSERT INTO `nucleus_config` VALUES ('AllowedTypes', 'jpg,jpeg,gif,mpg,mpeg,avi,mov,mp3,swf,png');
INSERT INTO `nucleus_config` VALUES ('AllowLoginEdit', '');
INSERT INTO `nucleus_config` VALUES ('AllowUpload', '1');
INSERT INTO `nucleus_config` VALUES ('DisableJsTools', '2');
INSERT INTO `nucleus_config` VALUES ('CookiePath', '/');
INSERT INTO `nucleus_config` VALUES ('CookieDomain', '');
INSERT INTO `nucleus_config` VALUES ('CookieSecure', '');
INSERT INTO `nucleus_config` VALUES ('CookiePrefix', '');
INSERT INTO `nucleus_config` VALUES ('MediaPrefix', '1');
INSERT INTO `nucleus_config` VALUES ('MaxUploadSize', '1048576');
INSERT INTO `nucleus_config` VALUES ('NonmemberMail', '');
INSERT INTO `nucleus_config` VALUES ('PluginURL', 'http://localhost:8080/nucleus/nucleus/plugins/');
INSERT INTO `nucleus_config` VALUES ('ProtectMemNames', '1');
INSERT INTO `nucleus_config` VALUES ('BaseSkin', '5');
INSERT INTO `nucleus_config` VALUES ('SkinsURL', 'http://localhost:8080/nucleus/skins/');
INSERT INTO `nucleus_config` VALUES ('ActionURL', 'http://localhost:8080/nucleus/action.php');
INSERT INTO `nucleus_config` VALUES ('URLMode', 'normal');
INSERT INTO `nucleus_config` VALUES ('DatabaseVersion', '330');

CREATE TABLE `nucleus_item` (
  `inumber` int(11) NOT NULL auto_increment,
  `ititle` varchar(160) default NULL,
  `ibody` text NOT NULL,
  `imore` text,
  `iblog` int(11) NOT NULL default '0',
  `iauthor` int(11) NOT NULL default '0',
  `itime` datetime NOT NULL default '0000-00-00 00:00:00',
  `iclosed` tinyint(2) NOT NULL default '0',
  `idraft` tinyint(2) NOT NULL default '0',
  `ikarmapos` int(11) NOT NULL default '0',
  `icat` int(11) default NULL,
  `ikarmaneg` int(11) NOT NULL default '0',
  `iposted` tinyint(2) NOT NULL default '1',
  PRIMARY KEY  (`inumber`),
  UNIQUE KEY `inumber` (`inumber`),
  KEY `itime` (`itime`),
  FULLTEXT KEY `ibody` (`ibody`,`ititle`,`imore`)
) TYPE=MyISAM PACK_KEYS=0;

INSERT INTO `nucleus_item` VALUES (1, 'Nucleus CMS С3.31ؤ褦',
'֥ڡκѤڤˤޤϿblogˤʤ뤫⤷ޤ󤷡ѤΤ¤ޤ²Υڡˤʤ뤫⤷ޤ󤷡¤¿̣ΥȤˤʤ뤫⤷ޤ󡣤뤤ϸߤΤʤˤĤʤΤˤʤ뤳ȤäƤǤ礦<br />
<br />
ӤפĤޤǤʤ餳Ǥʤʤ餢ʤƱͻ䤿ˤ狼ʤΤǤ顣',
'ϥȤˤǽΥȥ꡼ǤȤڤ䤹褦ˡ󥯤ȾƤޤ<br />
<br />
ε뤳ȤǤޤɤˤ赭ɲäƤȤˤäƤ䤬ƥᥤڡϸʤʤޤNucleus򰷤򥳥ȤȤɲä襢Ǥ褦ˤΥڡ֥åޡƤΤǤ<br />
<br />
<b></b><br />
<br />
Nucleus CMS<a href="http://nucleuscms.org">ܲ</a><a href="http://japan.nucleuscms.org">ܸ</a>ڡ<br />
<br />
Nucleus CMSSourceForge<a href="http://sourceforge.net/projects/nucleuscms/">ץ</a><a href="http://sourceforge.jp/projects/nucleus-jp/"></a>˥ڡ<br />
<br />
Nucleus CMSΥץ饰<a href="http://wakka.xiffy.nl/Plugin/">Ҹ</a><a href="http://japan.nucleuscms.org/wiki/plugins">ܸΥꥹ</a>ڡ<br />
<br />
<b>ɥ - <a href="http://docs.nucleuscms.org/">docs.nucleuscms.org</a></b><br />
<br />
Nucleus<a href="http://japan.nucleuscms.org/faq.php">FAQʤ褯佸</a><a href="http://nucleuscms.org/faq.php">ʸ</a>˥ڡ<br />
<br />
󥹥ȡˡ<a href="nucleus/documentation/">桼</a><a href="nucleus/documentation/devdocs/">ȯԸ</a>ʸ񤬥ե˴ޤޤƤޤ<br />
<br />
ݥåץå<a href="./nucleus/documentation/help.html">إ</a>ꥢΤȤˤꡢȤΥޥǥƤ뤳ȤǤ礦<br />
<br />
ѰդƤɥȤܤ̤顢<a href="http://wiki.nucleuscms.org/">Wiki</a><a href="http://japan.nucleuscms.org/wiki/"></a>ˤˬƤ桼ν񤤤ϥġ侮ǺܤƤޤ<br />
<br />
<b>ݡ</b><br />
<br />
<a href="http://forum.nucleuscms.org/">forum.nucleuscms.org</a>ܲȡ<br />
<a href="http://japan.nucleuscms.org/bb/">japan.nucleuscms.org/bb/</a>ǡ<br />
<br />
<a href="http://forum.nucleuscms.org/groupcp.php?g=3">moderators</a>ȥݡȥեǳưƤΥܥƥ˴դޤ<br />
<br />
- <a href="http://edmondhui.homeip.net/blog/">admun</a> - Ottawa, ON, Canada 	  	<br />
- <a href="http://www.tamizhan.com/">anand</a> - Bangalore, India<br />
- <a href="http://hcgtv.com">hcgtv</a> - Miami, Florida, USA<br />
- <a href="http://www.adrenalinsports.nl/">ikeizer</a> - Maastricht<br />
- <a href="http://www.tipos.com.br/">moraes</a> - Brazil<br />
- <a href="http://roelg.nl/">roel </a>- The Netherlands<br />
- <a href="http://budts.be/weblog/">TeRanEX </a>- Ekeren, Antwerp, Belgium<br />
- <a href="http://www.trentadams.com/">Trent </a>- Alberta, Canada<br />
- <a href="http://xiffy.nl/weblog/">xiffy </a>- Deventer<br />
<br />
⤷ɬפʤ顢1400ĶϿ桼Τ䤿Υե˻äƤ23,000ĶƤ줿򸡺Ǥ褦ˤʤäƤޤΤǡ˿ΥåǤɤ失뤫⤷ޤ<br />
<br />
<b>Personalization - <a href="http://skins.nucleuscms.org/">skins.nucleuscms.org</a></b><br />
<br />
ޥ֥ȥ/ƥץ졼ȤȤ߹碌϶Ϥ̤߽ФޤĿŪʥȺ̤ͧͤ뤤ϥ饤ȤФ륵ȥǥ󤤤ФƤǤ<br />
<br />
636Ͽ줿<a href="http://nucleuscms.org/sites.php">NucleusǱѤƤ륵</a><a href="http://japan.nucleuscms.org/sites.php"></a>ˤ椫ÿ륵Ȥ򥵥ץȤƤҲ𤷤ޤ<br />
<br />
The Zen of Nucleus<br />
- <a href="http://beefcake.nl/">beefcake.nl</a> - Beefcake | Nuke the whales!<br />
- <a href="http://www.leng-lui.com//">leng-lui.com</a> - Leng-Lui.com - v7.0: "Memento"<br />
<br />
Personal blogs<br />
- <a href="http://bloggard.com/">bloggard.com</a> - The Adventures of Bloggard<br />
- <a href="http://battleangel.org/">battleangel.org</a> - Giving meaning to the meaningless<br />
- <a href="http://www.yetanotherblog.de/">yetanotherblog.de</a> - Yet Another Blog<br />
<br />
Multi user blogs<br />
- <a href="http://tipos.com.br/">tipos.com.br</a> - Blogging community<br />
<br />
Hobby, Travel and News sites<br />
- <a href="http://adrenalinsports.nl/">adrenalinsports.nl</a> - Extreme sports<br />
- <a href="http://hsbluebird.com/">hsbluebird.com</a> - Hot Springs, Montana''s Online Resource <br />
- <a href="http://groningen-info.de/">groningen-info.de</a> - Neues aus Groningen. Fr Leute aus Duitsland.<br />
- <a href="http://www.americandaily.com/">americandaily.com</a> - American Daily - Home<br />
<br />
<b>Nucleus Developer Network - <a href="http://dev.nucleuscms.org/">dev.nucleuscms.org</a></b><br />
<br />
The NUDN is a hub for developer sites and programming resources.<br />
<br />
NUDN satellite sites, handles, location and UTC offset:<br />
- <a href="http://karma.nucleuscms.org/">karma</a> - Izegem +02<br />
- <a href="http://hcgtv.net/">hcgtv</a> - Miami -05<br />
- <a href="http://edmondhui.homeip.net/blog/nudn.php">admun</a> - Ottawa -04<br />
- <a href="http://dev.budts.be/nucleus/">TeRanEX</a> - Ekeren +02<br />
<br />
Sourceforge.net graciously hosts our <a href="http://sourceforge.net/projects/nucleuscms/">CVS repository</a>.<br />
<br />
Want to play around or test changes, visit our demo site at <a href="http://demo.nucleuscms.org/">demo.nucleuscms.org</a>.<br />
<br />
Not sure what plugins to use, visit the <a href="http://showcase.trentadams.com/">showcase site</a> where you can see plugins at play in their native habitat.<br />
<br />
Then visit the plugin repository at <a href="http://plugins.nucleuscms.org/">plugins.nucleuscms.org</a> for download and installation instructions.<br />
<br />
<b>ռ԰</b><br />
<br />
ʲ<a href="http://nucleuscms.org/donators.php">餷͡</a>ˤ<a href="http://nucleuscms.org/donate.php"></a>դޤ<em>꤬Ȥ</em><br />
<br />
- <a href="http://reddustrec.net/">dkex</a><br />
- <a href="http://www.uncoverthenet.com/">Uncover the Net</a><br />
- <a href="http://www.webatlas.org/">Web Atlas</a><br />
- <a href="http://www.ipnlighting.com/">IPN Lighting</a><br />
- <a href="http://blog.datoka.jp/">Yu (blog.datoka.jp)</a><br />
- <a href="http://www.thegadgetreview.com/">Sony Gadgets and Reviews</a><br />
- <a href="http://sites.proliphus.com/blueZhift/blog/">Thomas McKibben</a><br />
- <a href="http://cheapweb.us/">CheapWeb.us</a><br />
- Robert Seyfriedsberger<br />
- <a href="http://www.toxicologie.nl/">Toxicologie.nl</a><br />
- Gordon Shum<br />
- <a href="http://www.subsim.com/">Neal Stevens</a><br />
- <a href="http://www.GamblingHelper.com/">GamblingHelper</a><br />
- Oliver Kirstein<br />
- <a href="http://www.dominiek.be/">Dominiek</a><br />
- <a href="http://www.aardschok.net/">Aardschok</a><br />
- <a href="http://www.nieuwevoordeur.be/">nieuwevoordeur.be</a><br />
- <a href="http://www.scene24.net/">Scene24</a><br />
- <a href="http://www.eug.be/">Eug''s Weblog</a><br />
- <a href="http://www.bloggard.com/">The Adventures of Bloggard</a><br />
- <a href="http://www.voltos.com/">Arthur Cronos from Voltos</a><br />
- <a href="http://www.webmaster-toolkit.com/">Free Webmaster Tools and Resources</a><br />
- <a href="http://www.domilog.be/">Domi''s Weblog</a><br />
- Infodoma		<br />
- <a href="http://carvingcode.com/">carvingCode.com</a><br />
- <a href="http://www.traweb.com/">Traweb</a><br />
- <a href="http://gene.mm2u.com/">Gene''s MoBlog</a><br />
- <a href="http://interfacethis.com/">InterfaceThis</a><br />
- <a href="http://www.thefinsters.com/flog/">The Finster Log</a><br />
- <a href="http://www.mrhop.com/">Hop Nguyen</a><br />
- <a href="http://www.zwavel.com/~zwavelaars" title="Zwavelaars">Zwavelaars</a><br />
- <a href="http://beefcake.nl/">Joaquin Scholten</a>	<br />
- <a href="http://www.roelgroeneveld.com/">Roel Groeneveld</a><br />
- <a href="http://lvb.net/">LVBlog</a><br />
- <a href="http://xandermol.com/">Xander Mol</a><br />
- Danilo Massa<br />
- <a href="http://01FTP.com/">01FTP.com</a><br />
- <a href="http://www.adrenalinsports.nl/">Irmo Keizer</a><br />
- <a href="http://www.jasonkrogh.com/">Jason Krogh</a><br />
- <a href="http://www.higuchi.com/">Osamu Higuchi</a><br />
- <a href="http://www.trentadams.com/">Trent Adams</a><br />
- <a href="http://www.ppcw.net/">Arne Hess</a><br />
- <a href="http://hsbluebird.com/">The Bluebird</a><br />
- Rainer Bickel<br />
- Fritz Elfers<br />
- <a href="http://www.european-wall-tapestries.com/">European Wall Tapestries</a><br />
- <a href="http://www.jamier.net/">Jamie R. Rytlewski</a><br />
- Madolyn Piper<br />
- <a href="http://www.batteryvalues.com/">Battery Values</a><br />
- <a href="http://www.mixburnrip.de/">Janko Roettgers</a><br />
- Lukas Loesche<br />
- <a href="http://www.seobook.com/">SEO Book</a><br />
- <a href="http://www.brandweerdematen.nl/">Brandweer de Maten</a><br />
- Andy Fuchs<br />
- <a href="http://www.sumoforce.com/">Sumoforce</a><br />
- <a href="http://love.silverindigo.com/">Al''ky''mie</a><br />
- <a href="http://www.pejo.us/">Peter Johnson</a><br />
- <a href="http://www.triv.nl/">TriV Internet Solutions</a><br />
- <a href="http://www.torontomusicians.org/nucleus/">Margaret Stowe</a><br />
- <a href="http://www.zenkey.org/">zenkey dot org</a><br />
- <a href="http://www.golb.org/">Blots of Info</a><br />
- <a href="http://www.zonderpartij.be/">Rudi De Kerpel</a><br />
- <a href="http://staylorx.com/">Steve Taylor</a><br />
- <a href="http://lmhcave.com/">Malcolm Farnsworth</a><br />
- Birgit Kellner<br />
- <a href="http://www.tobiasly.com/">Toby Johnson</a><br />
- <a href="http://www.kapingamarangi.be/">Kapingamarangi</a><br />
- <a href="http://www.pallalink.net/">Pallalink</a><br />
- <a href="http://publiustx.net/">PubliusTX Weblog</a><br />
- <a href="http://www.reductioadabsurdum.net/">Reductio Ad Absurdum</a><br />
- <a href="http://www.gagaweb.org/">GagaWeb</a><br />
- <a href="http://www.videokid.be/">Videokid</a><br />
- Jon Marr<br />
- <a href="http://www.docblog.org/">Luigi Cristiano</a><br />
- J Keith Lehman<br />
- Bohemian Cachet<br />
- Jesus Mourazos<br />
- <a href="http://ltp-design.com/">Stephen Jones</a><br />
- <a href="http://oha.nu/">One-Handed Apps</a><br />
- Alwin Hawkins<br />
- <a href="http://jstigall.bloomington.in.us">Justin Stigall</a><br />
- <a href="http://www.itismylife.com/">It is my life</a><br />
- Greg Morrill<br />
- <a href="http://www.dutchsubmarines.com/">Dutch Submarines</a><br />
- <a href="http://www.7thwatch.com/">Seventh Watch Design Studios</a>		<br />
- <a href="http://www.macnet2.com/">MacNetv2</a>	<br />
- Richard Noordhof<br />
- <a href="http://www.jamier.net/">Jamie Rytlewski</a><br />
<br />
Nucleusޤ<a href="http://www.hotscripts.com/Detailed/13368.html?RID=nucleus@demuynck.org">HotScripts</a><a href="http://www.opensourcecms.com/index.php?option=content&task=view&id=145">opensourceCMS</a>Ǥɼ򤪴ꤤޤ<br />
<br />
<b>饤</b><br />
<br />
䤿ե꡼եȥˤĤƸˤϼͳΤȤ˸ڤƤΤǤäơʤΤȤǤϤޤ󡣻䤿<a href="http://www.gnu.org/licenses/gpl.html"≯ͭѵ</a><a href="http://www.gnu.org/licenses/gpl.ja.html">ܸ</a><a href="http://www.atmarkit.co.jp/aig/03linux/gpl.html"></a>ˤϡե꡼եȥʣʪͳۤǤ뤳(ơ˾ʤ餳ΥӥФвǤ뤳)ɤºݤ˼뤫˾ꤹ뤳ȤǽǤ뤳ȡꤷեȥѹ꿷ե꡼ץΰȤƻѤǤ뤳ȡʾγƤԤʤȤǤȤȤ桼ȤΤäƤ뤳Ȥ¸Ǥ褦˥ǥ󤵤Ƥޤ', 
1, 1, '2005-02-16 22:57:54', 0, 0, 0, 1, 0, 1);

CREATE TABLE `nucleus_karma` (
  `itemid` int(11) NOT NULL default '0',
  `ip` char(15) NOT NULL default ''
) TYPE=MyISAM;

CREATE TABLE `nucleus_member` (
  `mnumber` int(11) NOT NULL auto_increment,
  `mname` varchar(16) NOT NULL default '',
  `mrealname` varchar(60) default NULL,
  `mpassword` varchar(40) NOT NULL default '',
  `memail` varchar(60) default NULL,
  `murl` varchar(100) default NULL,
  `mnotes` varchar(100) default NULL,
  `madmin` tinyint(2) NOT NULL default '0',
  `mcanlogin` tinyint(2) NOT NULL default '1',
  `mcookiekey` varchar(40) default NULL,
  `deflang` varchar(20) NOT NULL default '',
  PRIMARY KEY  (`mnumber`),
  UNIQUE KEY `mname` (`mname`),
  UNIQUE KEY `mnumber` (`mnumber`)
) TYPE=MyISAM;

INSERT INTO `nucleus_member` VALUES (1, 'example', 'example', '1a79a4d60de6718e8e5b326e338ae533', 'example@example.org', 'http://localhost:8080/nucleus/', '', 1, 1, 'd767aefc60415859570d64c649257f19', '');

CREATE TABLE `nucleus_plugin` (
  `pid` int(11) NOT NULL auto_increment,
  `pfile` varchar(40) NOT NULL default '',
  `porder` int(11) NOT NULL default '0',
  PRIMARY KEY  (`pid`),
  KEY `pid` (`pid`),
  KEY `porder` (`porder`)
) TYPE=MyISAM;

CREATE TABLE `nucleus_plugin_event` (
  `pid` int(11) NOT NULL default '0',
  `event` varchar(40) default NULL,
  KEY `pid` (`pid`)
) TYPE=MyISAM;

CREATE TABLE `nucleus_plugin_option` (
  `ovalue` text NOT NULL,
  `oid` int(11) NOT NULL auto_increment,
  `ocontextid` int(11) NOT NULL default '0',
  PRIMARY KEY  (`oid`,`ocontextid`)
) TYPE=MyISAM;

CREATE TABLE `nucleus_plugin_option_desc` (
  `oid` int(11) NOT NULL auto_increment,
  `opid` int(11) NOT NULL default '0',
  `oname` varchar(20) NOT NULL default '',
  `ocontext` varchar(20) NOT NULL default '',
  `odesc` varchar(255) default NULL,
  `otype` varchar(20) default NULL,
  `odef` text,
  `oextra` text,
  PRIMARY KEY  (`opid`,`oname`,`ocontext`),
  UNIQUE KEY `oid` (`oid`)
) TYPE=MyISAM;

CREATE TABLE `nucleus_skin` (
  `sdesc` int(11) NOT NULL default '0',
  `stype` varchar(20) NOT NULL default '',
  `scontent` text NOT NULL,
  PRIMARY KEY  (`sdesc`,`stype`)
) TYPE=MyISAM;

INSERT INTO `nucleus_skin` VALUES (2, 'index', '<?xml version="1.0" encoding="UTF-8"?>\n\n<feed xml:lang="ja" xmlns="http://www.w3.org/2005/Atom\">\n    <title><%blogsetting(name)%></title>\n    <subtitle><%blogsetting(desc)%></subtitle>\n    <id><%blogsetting(url)%>:<%blogsetting(id)%></id>\n\n    <link rel="alternate" type="text/html" href="<%blogsetting(url)%>" />\n    <link rel="self" type="application/atom+xml" href="<%blogsetting(url)%><%self%>" />\n    <generator uri="http://nucleuscms.org/"><%version%></generator>\n    <updated><%blog(feeds/atom/modified,1)%></updated>\n\n    <%blog(feeds/atom/entries,10)%>\n</feed>');
INSERT INTO `nucleus_skin` VALUES (4, 'index', '<?xml version="1.0"?>\r\n<rsd version="1.0">\r\n <service>\r\n  <engineName><%version%></engineName>\r\n  <engineLink>http://nucleuscms.org/</engineLink>\r\n  <homepageLink><%sitevar(url)%></homepageLink>\r\n  <apis>\r\n   <api name="MetaWeblog" preferred="true" apiLink="<%adminurl%>xmlrpc/server.php" blogID="<%blogsetting(id)%>">\r\n    <docs>http://nucleuscms.org/documentation/devdocs/xmlrpc.html</docs>\r\n   </api>\r\n   <api name="Blogger" preferred="false" apiLink="<%adminurl%>xmlrpc/server.php" blogID="<%blogsetting(id)%>">\r\n    <docs>http://nucleuscms.org/documentation/devdocs/xmlrpc.html</docs>\r\n   </api>\r\n  </apis>\r\n </service>\r\n</rsd>');
INSERT INTO `nucleus_skin` VALUES (3, 'index', '<?xml version="1.0" encoding="UTF-8"?>\r\n<rss version="2.0">\r\n  <channel>\r\n    <title><%blogsetting(name)%></title>\r\n    <link><%blogsetting(url)%></link>\r\n    <description><%blogsetting(desc)%></description>\r\n    <language>ja</language>\r\n    <generator><%version%></generator>\r\n    <copyright>&#169;</copyright>\r\n    <category>Weblog</category>\r\n    <docs>http://backend.userland.com/rss</docs>\r\n    <image>\r\n      <url><%adminurl%>nucleus2.gif</url>\r\n      <title><%blogsetting(name)%></title>\r\n      <link><%blogsetting(url)%></link>\r\n    </image>\r\n    <%blog(feeds/rss20,10)%>\r\n  </channel>\r\n</rss>');

CREATE TABLE `nucleus_skin_desc` (
  `sdnumber` int(11) NOT NULL auto_increment,
  `sdname` varchar(20) NOT NULL default '',
  `sddesc` varchar(200) default NULL,
  `sdtype` varchar(40) NOT NULL default 'text/html',
  `sdincmode` varchar(10) NOT NULL default 'normal',
  `sdincpref` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`sdnumber`),
  UNIQUE KEY `sdname` (`sdname`),
  UNIQUE KEY `sdnumber` (`sdnumber`)
) TYPE=MyISAM;

INSERT INTO `nucleus_skin_desc` VALUES (2, 'feeds/atom', 'Atom 1.0 weblog syndication', 'application/atom+xml', 'normal', '');
INSERT INTO `nucleus_skin_desc` VALUES (3, 'feeds/rss20', 'RSS 2.0 syndication of weblogs', 'text/xml', 'normal', '');
INSERT INTO `nucleus_skin_desc` VALUES (4, 'xml/rsd', 'RSD (Really Simple Discovery) information for weblog clients', 'text/xml', 'normal', '');
INSERT INTO `nucleus_skin_desc` VALUES (5, 'default', 'Nucleus CMS default skin', 'text/html', 'skindir', 'default/');

CREATE TABLE `nucleus_team` (
  `tmember` int(11) NOT NULL default '0',
  `tblog` int(11) NOT NULL default '0',
  `tadmin` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`tmember`,`tblog`)
) TYPE=MyISAM;

INSERT INTO `nucleus_team` VALUES (1, 1, 1);

CREATE TABLE `nucleus_template` (
  `tdesc` int(11) NOT NULL default '0',
  `tpartname` varchar(20) NOT NULL default '',
  `tcontent` text NOT NULL,
  PRIMARY KEY  (`tdesc`,`tpartname`)
) TYPE=MyISAM;

INSERT INTO `nucleus_template` VALUES (3, 'ITEM', '<item>\r\n <title><%title(xml)%></title>\r\n <link><%blogurl%>?itemid=<%itemid%></link>\r\n<description><![CDATA[<%body%><%more%>]]></description>\r\n <category><%category%></category>\r\n<comments><%blogurl%>?itemid=<%itemid%></comments>\r\n <pubDate><%date(rfc822)%></pubDate>\r\n</item>');
INSERT INTO `nucleus_template` VALUES (3, 'EDITLINK', '<a href="<%editlink%>" onclick="<%editpopupcode%>">edit</a>');
INSERT INTO `nucleus_template` VALUES (3, 'FORMAT_DATE', '%Y-%m-%d');
INSERT INTO `nucleus_template` VALUES (3, 'FORMAT_TIME', '%H:%M:%S');
INSERT INTO `nucleus_template` VALUES (4, 'ITEM', '<%date(utc)%>');
INSERT INTO `nucleus_template` VALUES (5, 'ITEM', '<entry>\r\n <title type="html"><![CDATA[<%title%>]]></title>\r\n <link rel="alternate" type="text/html" href="<%blogurl%>?itemid=<%itemid%>" />\r\n <author>\r\n  <name><%author%></name>\r\n </author>\r\n <updated><%date(utc)%></updated>\r\n <published><%date(iso8601)%></published>\r\n <content type="html"><![CDATA[<%body%><%more%>]]></content>\r\n <id><%blogurl%>:<%blogid%>:<%itemid%></id>\r\n</entry>');

INSERT INTO `nucleus_template` VALUES (5, 'POPUP_CODE', '<%media%>');
INSERT INTO `nucleus_template` VALUES (5, 'IMAGE_CODE', '<%image%>');
INSERT INTO `nucleus_template` VALUES (5, 'MEDIA_CODE', '<%media%>');
INSERT INTO `nucleus_template` VALUES (3, 'POPUP_CODE', '<%image%>');
INSERT INTO `nucleus_template` VALUES (3, 'MEDIA_CODE', '<%media%>');
INSERT INTO `nucleus_template` VALUES (3, 'IMAGE_CODE', '<%media%>');

CREATE TABLE `nucleus_template_desc` (
  `tdnumber` int(11) NOT NULL auto_increment,
  `tdname` varchar(20) NOT NULL default '',
  `tddesc` varchar(200) default NULL,
  PRIMARY KEY  (`tdnumber`),
  UNIQUE KEY `tdnumber` (`tdnumber`),
  UNIQUE KEY `tdname` (`tdname`)
) TYPE=MyISAM;

INSERT INTO `nucleus_template_desc` VALUES (4, 'feeds/atom/modified', 'Atom feeds: Inserts last modification date');
INSERT INTO `nucleus_template_desc` VALUES (5, 'feeds/atom/entries', 'Atom feeds: Feed items');
INSERT INTO `nucleus_template_desc` VALUES (3, 'feeds/rss20', 'Used for RSS 2.0 syndication of your blog');
INSERT INTO `nucleus_template_desc` VALUES (8, 'default/index', 'Nucleus CMS default index template');
INSERT INTO `nucleus_template_desc` VALUES (9, 'default/item', 'Nucleus CMS default item template');

CREATE TABLE `nucleus_tickets` (
  `ticket` varchar(40) NOT NULL default '',
  `ctime` datetime NOT NULL default '0000-00-00 00:00:00',
  `member` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ticket`,`member`)
) TYPE=MyISAM;
