<?php
/*
 * Nucleus: PHP/MySQL Weblog CMS (http://nucleuscms.org/)
 * Copyright (C) 2002-2011 The Nucleus Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * (see nucleus/documentation/index.html#license for more info)
 * This script will install the Nucleus tables in your SQL-database, and initialize the data in
 * those tables.
 *
 * Below is a friendly way of letting users on non-php systems know that Nucleus won't run there.
 * ?><div style="font-size: xx-large;">If you see this text in your browser when you open <i>/install/</i>, your web server is not able to run PHP-scripts, and therefor Nucleus will not be able to run there. </div><div style="display: none"><?php
 */

/**
 * @license http://nucleuscms.org/license.txt GNU General Public License
 * @copyright Copyright (C) 2002-2011 The Nucleus Group
 * @version $Id: index.php 1119 2011-01-28 04:49:33Z sakamocchi $
 * $NucleusJP: index.php,v 1.7 2007/02/04 06:28:44 kimitake Exp $
 */

/*
	This part of the index.php code allows for customization of the install process.
	When distributing plugins or skins together with a Nucleus installation, the
	configuration below will instruct to install them

	-- Start Of Configurable Part --
*/

include('./install_lang_japanese.php');

// array with names of plugins to install. Plugin files must be present in the nucleus/plugin/
// directory.
//
// example:
//	 array('NP_TrackBack', 'NP_MemberGoodies')
$aConfPlugsToInstall = array(
	'NP_SkinFiles',
);


// array with skins to install. skins must be present under the skins/ directory with
// a subdirectory having the same name that contains a skinbackup.xml file
//
// example:
//	 array('base','rsd')
$aConfSkinsToImport = array(
	'atom',
	'rss2.0',
	'rsd',
	'default',
);

/*
	-- End Of Configurable Part --
*/

// don't give warnings for uninitialized vars
error_reporting(E_ERROR | E_WARNING | E_PARSE);

// make sure there's no unnecessary escaping:
set_magic_quotes_runtime(0);

// if there are some plugins or skins to import, do not include vars
// in globalfunctions.php again... so set a flag
if ((count($aConfPlugsToInstall) > 0) || (count($aConfSkinsToImport) > 0) ) {
	global $CONF;
	$CONF['installscript'] = 1;
}

if (phpversion() >= '4.1.0') {
	include_once('../nucleus/libs/vars4.1.0.php');
} else {
	include_once('../nucleus/libs/vars4.0.6.php');
}

// include core classes that are needed for login & plugin handling
include_once('../nucleus/libs/mysql.php');
// added for 3.5 sql_* wrapper
global $MYSQL_HANDLER;
//set the handler if different from mysql (or mysqli)
//$MYSQL_HANDLER = array('pdo','mysql');
if (!isset($MYSQL_HANDLER)) {
	$MYSQL_HANDLER = array('mysql','');
}
include_once('../nucleus/libs/sql/'.$MYSQL_HANDLER[0].'.php');
// end new for 3.5 sql_* wrapper

// check if mysql support is installed
// this check may not make sense, as is, in a version past 3.5x
if (!function_exists('mysql_query') ) {
	_doError(_ERROR1);
}

if (postVar('action') == 'go') {
	doInstall();
} else {
	showInstallForm();
}

exit;

function showInstallForm() {
	// 0. pre check if all necessary files exist
	doCheckFiles();

	?>
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="content-type" content="application/xhtml+xml; charset=UTF-8" />
		<title><?php echo _TITLE; ?></title>
		<style type="text/css"><!--
			@import url('../nucleus/documentation/styles/manual.css');
		--></style>
		<script type="text/javascript"><!--
			var submitcount = 0;

			// function to make sure the submit button only gets pressed once
			function checkSubmit() {
				if (submitcount == 0) {
					submitcount++;
					return true;
				} else {
					return false;
				}
			}
		--></script>
	</head>
	<body>
		<div style="text-align:center"><img src="../nucleus/styles/logo.gif" /></div> <!-- Nucleus logo -->
		<form method="post" action="index.php">
		
		<h1><?php echo _HEADER1; ?></h1>
		
		<?php echo _TEXT1; ?>
		
		<h1><?php echo _HEADER1_2 ?></h1>
		
		<?php echo _TEXT1_2; ?>
		
		<fieldset>
			<legend><?php echo _TEXT1_2_TAB_HEAD; ?></legend>
			<table>
				<tr>
					<td><?php echo _TEXT1_2_TAB_FIELD1; ?></td>
					<td>
						<select name="charset" tabindex="10000">
							<option value="utf8" selected="selected">UTF-8</option>
							<option value="ujis" >EUC-JP</option>
						</select>
					</td>
				</tr>
			</table>
		</fieldset>
		
		<h1><?php echo _HEADER2; ?></h1>
		
		<?php echo _TEXT2; ?>
		
		<ul>
			<li>PHP:

<?php
	echo phpversion();
	$minVersion = '4.0.6';

	if (phpversion() < $minVersion) {
		echo ' <span class="warning" style="display:block">' . sprintf(_TEXT2_WARN, $minVersion) . '</span>';
	} elseif (phpversion() < '5') {
		echo ' <span class="warning" style="display:block">' . _TEXT2_WARN3 . '</span>';
	}
?>

			</li>
			<li>MySQL:

<?php
	// note: this piece of code is taken from phpMyAdmin
	$conn   = sql_connect_args('localhost','','');
	$result = @at_sql_query('SELECT VERSION() AS version', $conn);
	if ($result != FALSE && sql_num_rows($result) > 0) {
		$row   = sql_fetch_array($result);
		$match = explode('.', $row['version']);
	} else {
		$result = @at_sql_query('SHOW VARIABLES LIKE \'version\'', $conn);
		if ($result != FALSE && @sql_num_rows($result) > 0) {
			$row   = sql_fetch_row($result);
			$match = explode('.', $row[1]);
		} else {
			$output = (function_exists('shell_exec')) ? @shell_exec('mysql -V') : '0.0.0';
			preg_match('@[0-9]+\.[0-9]+\.[0-9]+@', $output, $version);
			$match = explode('.', $version[0]);

			if ($match[0] == '') {
				$match[0] = '0';
				$match[1] = '0';
				$match[2] = '0';
			}
		}
	}

	sql_disconnect($conn);
	$mysqlVersion = implode($match, '.');
	$minVersion   = '3.23';

	if ($mysqlVersion == '0.0.0') {
		echo _NOTIFICATION1;
	}
	else {
		echo $mysqlVersion;
	}

	if ($mysqlVersion < $minVersion) {
		echo ' <span class="warning" style="display:block">' . sprintf(_TEXT2_WARN2, $minVersion) . '</span>';
	}
?>

			</li>
		</ul>

<?php
	// tell people how they can have their config file filled out automatically
	if (@file_exists('../config.php') && @!is_writable('../config.php')) {
?>

		<h1><?php echo _HEADER3; ?></h1>

		<?php echo _TEXT3;

} ?>

		<h1><?php echo _HEADER4; ?></h1>

		<?php echo _TEXT4; ?>

		<fieldset>
			<legend><?php echo _TEXT4_TAB_HEAD; ?></legend>
			<table>
				<tr>
					<td><?php echo _TEXT4_TAB_FIELD1; ?></td>
					<td><input name="mySQL_host" value="<?php echo htmlspecialchars(@ini_get('mysql.default_host') )?>" tabindex="10010" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT4_TAB_FIELD2; ?></td>
					<td><input name="mySQL_user" tabindex="10020" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT4_TAB_FIELD3; ?></td>
					<td><input name="mySQL_password" type="password" tabindex="10030" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT4_TAB_FIELD4; ?></td>
					<td><input name="mySQL_database" tabindex="10040" /> (<input name="mySQL_create" value="1" type="checkbox" id="mySQL_create" tabindex="10050" /><label for="mySQL_create"><?php echo _TEXT4_TAB_FIELD4_ADD; ?></label>)</td>
				</tr>
			</table>
		</fieldset>

		<fieldset>
			<legend><?php echo _TEXT4_TAB2_HEAD; ?></legend>
			<table>
				<tr>
					<td><input name="mySQL_usePrefix" value="1" type="checkbox" id="mySQL_usePrefix" tabindex="10060" checked="checked" /><label for="mySQL_usePrefix"><?php echo _TEXT4_TAB2_FIELD; ?></label></td>
					<td><input name="mySQL_tablePrefix" value="SVN1123_" tabindex="10070" /></td>
				</tr>
			</table>

			<?php echo _TEXT4_TAB2_ADD; ?>

		</fieldset>

	<h1><?php echo _HEADER5; ?></h1>

	<?php echo _TEXT5; ?>

<?php

	// no need to this all! dirname(__FILE__) is all we need -- moraes
	/*
	// discover full path
	$fullPath = serverVar('PATH_TRANSLATED');

	if ($fullPath == '') {
		$fullPath = serverVar('SCRIPT_FILENAME');
	}

	$basePath = str_replace('install.php', '', $fullPath);
	$basePath = replaceDoubleBackslash($basePath);
	$basePath = replaceDoubleBackslash($basePath);

	// add slash at end if necessary
	if (!endsWithSlash($basePath) ) {
		$basePath .= '/';
	}
	*/

	$basePath = str_replace('install', '', dirname(__FILE__));
?>

		<fieldset>
			<legend><?php echo _TEXT5_TAB_HEAD; ?></legend>
			<table>
				<tr>
					<td><?php echo _TEXT5_TAB_FIELD1; ?></td>
					<td><input name="IndexURL" size="60" value="<?php
						$url = 'http://' . serverVar('HTTP_HOST') . serverVar('PHP_SELF');
						$url = str_replace('install/index.php', '', $url);
						$url = replaceDoubleBackslash($url);

						// add slash at end if necessary
						if (!endsWithSlash($url) ) {
							$url .= '/';
						}

						echo $url; ?>" tabindex="10080" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT5_TAB_FIELD2; ?></td>
					<td><input name="AdminURL" size="60" value="<?php
						if ($url) {
							echo $url . 'nucleus/';
						} ?>" tabindex="10090" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT5_TAB_FIELD3; ?></td>
					<td><input name="AdminPath" size="60" value="<?php
						if($basePath) {
							echo $basePath . 'nucleus/';
						} ?>" tabindex="10100" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT5_TAB_FIELD4; ?></td>
					<td><input name="MediaURL" size="60" value="<?php
						if ($url) {
							echo $url . 'media/';
						} ?>" tabindex="10110" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT5_TAB_FIELD5; ?></td>
					<td><input name="MediaPath" size="60" value="<?php
						if ($basePath) {
							echo $basePath . 'media/';
						} ?>" tabindex="10120" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT5_TAB_FIELD6; ?></td>
					<td><input name="SkinsURL" size="60" value="<?php
						if ($url) {
							echo $url . 'skins/';
						} ?>" tabindex="10130" />
						<br />(<?php echo _TEXT5_TAB_FIELD7_2; ?>)
					</td>
				</tr>
				<tr>
					<td><?php echo _TEXT5_TAB_FIELD7; ?></td>
					<td><input name="SkinsPath" size="60" value="<?php
						if ($basePath) {
							echo $basePath . 'skins/';
						} ?>" tabindex="10140" />
						<br />(<?php echo _TEXT5_TAB_FIELD7_2; ?>)
					</td>
				</tr>
				<tr>
					<td><?php echo _TEXT5_TAB_FIELD8; ?></td>
					<td><input name="PluginURL" size="60" value="<?php
						if ($url) {
							echo $url . 'nucleus/plugins/';
						} ?>" tabindex="10150" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT5_TAB_FIELD9; ?></td>
					<td><input name="ActionURL" size="60" value="<?php
						if ($url) {
							echo $url . 'action.php';
						} ?>" tabindex="10160" />
						<br />(<?php echo _TEXT5_TAB_FIELD9_2;?>)
					</td>
				</tr>
			</table>
		</fieldset>

		<?php echo _TEXT5_2; ?>

		<h1><?php echo _HEADER6; ?></h1>

		<?php echo _TEXT6; ?>

		<fieldset>
			<legend><?php echo _TEXT6_TAB_HEAD; ?></legend>
			<table>
				<tr>
					<td><?php echo _TEXT6_TAB_FIELD1; ?></td>
					<td><input name="User_name" value="" tabindex="10170" /> (<?php echo _TEXT6_TAB_FIELD1_2; ?>)</td>
				</tr>
				<tr>
					<td><?php echo _TEXT6_TAB_FIELD2; ?></td>
					<td><input name="User_realname" value="" tabindex="10180" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT6_TAB_FIELD3; ?></td>
					<td><input name="User_password" type="password" value="" tabindex="10190" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT6_TAB_FIELD4; ?></td>
					<td><input name="User_password2" type="password" value="" tabindex="10200" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT6_TAB_FIELD5; ?></td>
					<td><input name="User_email" value="" tabindex="10210" /> (<?php echo _TEXT6_TAB_FIELD5_2; ?>)</td>
				</tr>
			</table>
		</fieldset>

		<h1><?php echo _HEADER7; ?></h1>

		<?php echo _TEXT7; ?>

		<fieldset>
			<legend><?php echo _TEXT7_TAB_HEAD; ?></legend>
			<table>
				<tr>
					<td><?php echo _TEXT7_TAB_FIELD1; ?></td>
					<td><input name="Blog_name" size="60" value="My Nucleus CMS" tabindex="10220" /></td>
				</tr>
				<tr>
					<td><?php echo _TEXT7_TAB_FIELD2; ?></td>
					<td><input name="Blog_shortname" value="mynucleuscms" tabindex="10230" /> (<?php echo _TEXT7_TAB_FIELD2_2; ?>)</td>
				</tr>
			</table>
		</fieldset>

		<h1><?php echo _HEADER8; ?></h1>

		<fieldset>
			<legend><?php echo _TEXT8_TAB_HEADER; ?></legend>
			<table>
				<tr>
					<td><input name="Weblog_ping" value="1" type="checkbox" id="Weblog_ping" tabindex="10240" /><?php echo _TEXT8_TAB_FIELD1; ?></td>
				</tr>
			</table>
		</fieldset>
		
		<h1><?php echo _HEADER9; ?></h1>
		
		<?php echo _TEXT9; ?>
		
		<p>
		<input name="action" value="go" type="hidden" />
		<input type="submit" value="<?php echo _BUTTON1; ?>" onclick="return checkSubmit();" tabindex="10250" />
		</p>
		
		</form>
	</body>
</html>

<?php }

function tableName($unPrefixed) {
	global $mysql_usePrefix, $mysql_prefix;

	if ($mysql_usePrefix == 1) {
		return $mysql_prefix . $unPrefixed;
	} else {
		return $unPrefixed;
	}
}

function doInstall() {
	global $mysql_usePrefix, $mysql_prefix, $weblog_ping;

	// 0. put all POST-vars into vars
	$mysql_host		= postVar('mySQL_host');
	$mysql_user		= postVar('mySQL_user');
	$mysql_password	= postVar('mySQL_password');
	$mysql_database	= postVar('mySQL_database');
	$mysql_create	  = postVar('mySQL_create');
	$mysql_usePrefix   = postVar('mySQL_usePrefix');
	$mysql_prefix	  = postVar('mySQL_tablePrefix');
	$config_indexurl   = postVar('IndexURL');
	$config_adminurl   = postVar('AdminURL');
	$config_adminpath  = postVar('AdminPath');
	$config_mediaurl   = postVar('MediaURL');
	$config_skinsurl   = postVar('SkinsURL');
	$config_pluginurl  = postVar('PluginURL');
	$config_actionurl  = postVar('ActionURL');
	$config_mediapath  = postVar('MediaPath');
	$config_skinspath  = postVar('SkinsPath');
	$user_name		 = postVar('User_name');
	$user_realname	 = postVar('User_realname');
	$user_password	 = postVar('User_password');
	$user_password2	= postVar('User_password2');
	$user_email		= postVar('User_email');
	$blog_name		 = postVar('Blog_name');
	$blog_shortname	= postVar('Blog_shortname');
	$charset		   = postVar('charset');
	$config_adminemail = $user_email;
	$config_sitename   = $blog_name;
	$weblog_ping	   = postVar('Weblog_ping');
	
	$_POST = array();
	
	$config_indexurl   = replaceDoubleBackslash($config_indexurl);
	$config_adminurl   = replaceDoubleBackslash($config_adminurl);
	$config_mediaurl   = replaceDoubleBackslash($config_mediaurl);
	$config_skinsurl   = replaceDoubleBackslash($config_skinsurl);
	$config_pluginurl  = replaceDoubleBackslash($config_pluginurl);
	$config_actionurl  = replaceDoubleBackslash($config_actionurl);
	$config_adminpath  = replaceDoubleBackslash($config_adminpath);
	$config_skinspath  = replaceDoubleBackslash($config_skinspath);
	$config_mediapath  = replaceDoubleBackslash($config_mediapath);

/**
 * Include and initialize multibyte functions as a replacement for mbstring extension
 *  if mbstring extension is not loaded.
 * Jan.28, 2011. Japanese Package Release Team
 */ 
	if (!function_exists('mb_convert_encoding')){
		global $mbemu_internals;
		include_once($config_adminpath.'libs/mb_emulator/mb-emulator.php');
	}
	if (function_exists('date_default_timezone_set')){
		 @date_default_timezone_set((function_exists('date_default_timezone_get')) ? @date_default_timezone_get() : 'UTC');
	}
	
	if ($charset == 'ujis') {
		define('_CHARSET', 'EUC-JP');
		$config_sitename = mb_convert_encoding($config_sitename, _CHARSET, 'UTF-8');
		$user_realname  = mb_convert_encoding($user_realname, _CHARSET, 'UTF-8');
		$blog_name	  = mb_convert_encoding($blog_name, _CHARSET, 'UTF-8');
	} else {
		define('_CHARSET', 'UTF-8');
	}
	
	
	// 1. check all the data
	$errors = array();

	if (!$mysql_database) {
		array_push($errors, _ERROR2);
	}

	if (($mysql_usePrefix == 1) && (strlen($mysql_prefix) == 0) ) {
		array_push($errors, _ERROR3);
	}

	if (($mysql_usePrefix == 1) && (!eregi('^[a-zA-Z0-9_]+$', $mysql_prefix) ) ) {
		array_push($errors, _ERROR4);
	}

	// TODO: add action.php check
	if (!endsWithSlash($config_indexurl) || !endsWithSlash($config_adminurl) || !endsWithSlash($config_mediaurl) || !endsWithSlash($config_pluginurl) || !endsWithSlash($config_skinsurl) ) {
		array_push($errors, _ERROR5);
	}

	if (!endsWithSlash($config_adminpath) ) {
		array_push($errors, _ERROR6);
	}

	if (!endsWithSlash($config_mediapath) ) {
		array_push($errors, _ERROR7);
	}

	if (!endsWithSlash($config_skinspath) ) {
		array_push($errors, _ERROR8);
	}

	if (!is_dir($config_adminpath) ) {
		array_push($errors, _ERROR9);
	}

	if (!_isValidMailAddress($user_email) ) {
		array_push($errors, _ERROR10);
	}

	if (!_isValidDisplayName($user_name) ) {
		array_push($errors, _ERROR11);
	}

	if (!$user_password || !$user_password2) {
		array_push($errors, _ERROR12);
	}

	if ($user_password != $user_password2) {
		array_push($errors, _ERROR13);
	}

	if (!_isValidShortName($blog_shortname) ) {
		array_push($errors, _ERROR14);
	}

	if (sizeof($errors) > 0) {
		showErrorMessages($errors);
	}

	// 2-1. try to log in to mySQL

	global $MYSQL_CONN;
	// this will need to be changed if we ever allow
	$MYSQL_CONN = @sql_connect_args($mysql_host, $mysql_user, $mysql_password);

	if ($MYSQL_CONN == false) {
		_doError(_ERROR15 . ': ' . sql_error() );
	}

// <add for garble measure>
	// 2-2. set DEFAULT CHARSET and COLLATE
	$mySqlVer = implode('.', array_map('intval', explode('.', sql_get_server_info($MYSQL_CONN))));
//	if ($mySqlVer >= '5.0.7' && phpversion() >= '5.2.3') {//}
	if ($mySqlVer >= '5.0.7' && function_exists('mysql_set_charset')) {
		mysql_set_charset($charset);
	} elseif ($mySqlVer >= '4.1.0') {
		sql_query("SET CHARACTER SET " . $charset);
	}
	$collation = ($charset == 'utf8') ? 'utf8_general_ci' : 'ujis_japanese_ci';
// </add for garble measure>*/

	// 3. try to create database (if needed)
	if ($mysql_create == 1) {
		$sql = 'CREATE DATABASE '
			 .	 $mysql_database;
// <add for garble measure>
	if ($mySqlVer >= '4.1.0') {
		$sql .= ' DEFAULT CHARACTER SET '
			  .	 $charset
			  . ' COLLATE '
			  .	 $collation;
	}
// </add for garble measure>*/
		sql_query($sql,$MYSQL_CONN) or _doError(_ERROR16 . ': ' . sql_error($MYSQL_CONN));
	}

	// 4. try to select database
	sql_select_db($mysql_database,$MYSQL_CONN) or _doError(_ERROR17);

	// 5. execute queries
	$filename = 'install.sql';
	$fd = fopen($filename, 'r');
	$queries = fread($fd, filesize($filename) );
	fclose($fd);

	$queries = split("(;\n|;\r)", $queries);

	$aTableNames = array(
		'nucleus_actionlog',
		'nucleus_ban',
		'nucleus_blog',
		'nucleus_category',
		'nucleus_comment',
		'nucleus_config',
		'nucleus_item',
		'nucleus_karma',
		'nucleus_member',
		'nucleus_plugin',
		'nucleus_skin',
		'nucleus_template',
		'nucleus_team',
		'nucleus_activation',
		'nucleus_tickets'
	);
// these are unneeded (one of the replacements above takes care of them)
//			'nucleus_plugin_event',
//			'nucleus_plugin_option',
//			'nucleus_plugin_option_desc',
//			'nucleus_skin_desc',
//			'nucleus_template_desc',

	$aTableNamesPrefixed = array(
		$mysql_prefix . 'nucleus_actionlog',
		$mysql_prefix . 'nucleus_ban',
		$mysql_prefix . 'nucleus_blog',
		$mysql_prefix . 'nucleus_category',
		$mysql_prefix . 'nucleus_comment',
		$mysql_prefix . 'nucleus_config',
		$mysql_prefix . 'nucleus_item',
		$mysql_prefix . 'nucleus_karma',
		$mysql_prefix . 'nucleus_member',
		$mysql_prefix . 'nucleus_plugin',
		$mysql_prefix . 'nucleus_skin',
		$mysql_prefix . 'nucleus_template',
		$mysql_prefix . 'nucleus_team',
		$mysql_prefix . 'nucleus_activation',
		$mysql_prefix . 'nucleus_tickets'
	);
// these are unneeded (one of the replacements above takes care of them)
//			$mysql_prefix . 'nucleus_plugin_event',
//			$mysql_prefix . 'nucleus_plugin_option',
//			$mysql_prefix . 'nucleus_plugin_option_desc',
//			$mysql_prefix . 'nucleus_skin_desc',
//			$mysql_prefix . 'nucleus_template_desc',

	$count = count($queries);

	for ($idx = 0; $idx < $count; $idx++) {
		$query = trim($queries[$idx]);
		// echo "QUERY = " . htmlspecialchars($query) . "<p>";

		if ($query) {

			if ($mysql_usePrefix == 1) {
					$query = str_replace($aTableNames, $aTableNamesPrefixed, $query);
			}
// <add for garble measure>
			if ($mysql_create != 1 && strpos($query, 'CREATE TABLE') === 0 && $mySqlVer >= '4.1.0') {
				$query .= ' DEFAULT CHARACTER SET ' . $charset . ' COLLATE ' . $collation;
			}
// </add for garble measure>*/

			sql_query($query,$MYSQL_CONN) or _doError(_ERROR30 . ' (' . htmlspecialchars($query) . '): ' . sql_error($MYSQL_CONN) );
		}
	}

	// 5a make first post
	if (strtoupper(_CHARSET) != 'UTF-8') {
		$itm_title = mb_convert_encoding(_1ST_POST_TITLE, _CHARSET, 'UTF-8');
		$itm_body  = mb_convert_encoding(_1ST_POST, _CHARSET, 'UTF-8');
		$itm_more  = mb_convert_encoding(_1ST_POST2, _CHARSET, 'UTF-8');
	} else {
		$itm_title = _1ST_POST_TITLE;
		$itm_body  = _1ST_POST;
		$itm_more  = _1ST_POST2;
	}
	$newpost = "INSERT INTO "
			 . tableName('nucleus_item')
			 . " VALUES ("
			 . "1, "
			 . "'" . $itm_title . "',"
			 . " '" . $itm_body . "',"
			 . " '" . $itm_more . "',"
			 . " 1, 1, '2005-08-15 11:04:26', 0, 0, 0, 1, 0, 1);";
	sql_query($newpost,$MYSQL_CONN) or _doError(_ERROR18 . ' (' . htmlspecialchars($newpost) . '): ' . sql_error($MYSQL_CONN) );

	// 6. update global settings
	updateConfig('IndexURL',   $config_indexurl);
	updateConfig('AdminURL',   $config_adminurl);
	updateConfig('MediaURL',   $config_mediaurl);
	updateConfig('SkinsURL',   $config_skinsurl);
	updateConfig('PluginURL',  $config_pluginurl);
	updateConfig('ActionURL',  $config_actionurl);
	updateConfig('AdminEmail', $config_adminemail);
	updateConfig('SiteName',   $config_sitename);
	if ($charset == 'ujis') {
		updateConfig('Language',   'japanese-euc');
	}

	// 7. update GOD member
	$query = 'UPDATE ' . tableName('nucleus_member')
		   . " SET mname	 = '" . addslashes($user_name) . "',"
		   . " mrealname	 = '" . addslashes($user_realname) . "',"
		   . " mpassword	 = '" . md5(addslashes($user_password) ) . "',"
		   . " murl		  = '" . addslashes($config_indexurl) . "',"
		   . " memail		= '" . addslashes($user_email) . "',"
		   . " madmin		= 1,"
		   . " mcanlogin	 = 1"
		   . " WHERE"
		   . " mnumber	   = 1";

	sql_query($query,$MYSQL_CONN) or _doError(_ERROR19 . ': ' . sql_error($MYSQL_CONN) );

	// 8. update weblog settings
	$query = 'UPDATE ' . tableName('nucleus_blog')
		   . " SET bname  = '" . addslashes($blog_name) . "',"
		   . " bshortname = '" . addslashes($blog_shortname) . "',"
		   . " burl	   = '" . addslashes($config_indexurl) . "'"
		   . " WHERE"
		   . " bnumber	= 1";

	sql_query($query,$MYSQL_CONN) or _doError(_ERROR20 . ': ' . sql_error($MYSQL_CONN) );

	// 8-2. update category settings
	if (strtoupper(_CHARSET) != 'UTF-8') {
		$cat_name = mb_convert_encoding(_GENERALCAT_NAME, _CHARSET, 'UTF-8');
		$cat_desc = mb_convert_encoding(_GENERALCAT_DESC, _CHARSET, 'UTF-8');
	} else {
		$cat_name = _GENERALCAT_NAME;
		$cat_desc = _GENERALCAT_DESC;
	}
	$query = 'UPDATE ' . tableName('nucleus_category')
		   . " SET cname  = '" . $cat_name . "',"
		   . " cdesc	  = '" . $cat_desc . "'"
		   . " WHERE"
		   . " catid	  = 1";

	sql_query($query,$MYSQL_CONN) or _doError(_ERROR20 . ': ' . sql_error($MYSQL_CONN) );

	// 9. update item date
	$query = 'UPDATE ' . tableName('nucleus_item')
		   . " SET   itime   = '" . date('Y-m-d H:i:s', time() ) ."'"
		   . " WHERE inumber = 1";

	sql_query($query,$MYSQL_CONN) or _doError(_ERROR21 . ': ' . sql_error($MYSQL_CONN) );

	global $aConfPlugsToInstall, $aConfSkinsToImport;
	$aSkinErrors = array();
	$aPlugErrors = array();

	if ((count($aConfPlugsToInstall) > 0) || (count($aConfSkinsToImport) > 0) ) {
		// 10. set global variables
		global $MYSQL_HOST, $MYSQL_USER, $MYSQL_PASSWORD, $MYSQL_DATABASE, $MYSQL_PREFIX;

		$MYSQL_HOST	 = $mysql_host;
		$MYSQL_USER	 = $mysql_user;
		$MYSQL_PASSWORD = $mysql_password;
		$MYSQL_DATABASE = $mysql_database;
		$MYSQL_PREFIX   = ($mysql_usePrefix == 1) ? $mysql_prefix : '';

		global $DIR_NUCLEUS, $DIR_MEDIA, $DIR_SKINS, $DIR_PLUGINS, $DIR_LANG, $DIR_LIBS;

		$DIR_NUCLEUS = $config_adminpath;
		$DIR_MEDIA   = $config_mediapath;
		$DIR_SKINS   = $config_skinspath;
		$DIR_PLUGINS = $DIR_NUCLEUS . 'plugins/';
		$DIR_LANG	= $DIR_NUCLEUS . 'language/';
		$DIR_LIBS	= $DIR_NUCLEUS . 'libs/';

		// close database connection (needs to be closed if we want to include globalfunctions.php)
		sql_close($MYSQL_CONN);

		$manager = '';
		include_once($DIR_LIBS . 'globalfunctions.php');

		// 11. install custom skins
		$aSkinErrors = installCustomSkins($manager);
		$defskinQue  = 'SELECT `sdnumber` as result FROM ' . sql_table('skin_desc') . ' WHERE `sdname` = "default"';
		$defSkinID   = quickQuery($defskinQue);
		$updateQuery = 'UPDATE ' . sql_table('blog') . ' SET `bdefskin` = ' . intval($defSkinID) . ' WHERE `bnumber` = 1';
		sql_query($updateQuery);
		$updateQuery = 'UPDATE ' . sql_table('config') . ' SET `value` = ' . intval($defSkinID). ' WHERE `name` = "BaseSkin"';
		sql_query($updateQuery);

		// 12. install NP_Ping, if decided
		if ($weblog_ping == 1) {
			global $aConfPlugsToInstall;
			array_push($aConfPlugsToInstall, "NP_Ping");
		}

		// 13. install custom plugins
		$aPlugErrors = installCustomPlugs($manager);
	}

	// 14. Write config file ourselves (if possible)
	$bConfigWritten = 0;

	if (@file_exists('../config.php') && is_writable('../config.php') && $fp = @fopen('../config.php', 'w') ) {
		$config_data = '<' . '?php' . "\n\n";
		//$config_data .= "\n"; (extraneous, just added extra \n to previous line
		$config_data .= "   // mySQL connection information\n";
		$config_data .= "   \$MYSQL_HOST	 = '" . $mysql_host . "';\n";
		$config_data .= "   \$MYSQL_USER	 = '" . $mysql_user . "';\n";
		$config_data .= "   \$MYSQL_PASSWORD = '" . $mysql_password . "';\n";
		$config_data .= "   \$MYSQL_DATABASE = '" . $mysql_database . "';\n";
		$config_data .= "   \$MYSQL_PREFIX   = '" . (($mysql_usePrefix == 1) ? $mysql_prefix : '') . "';\n";
		$config_data .= "   // new in 3.50. first element is db handler, the second is the db driver used by the handler\n";
		$config_data .= "   // default is \$MYSQL_HANDLER = array('mysql','');\n";
		$config_data .= "   //\$MYSQL_HANDLER = array('mysql','mysql');\n";
		$config_data .= "   //\$MYSQL_HANDLER = array('pdo','mysql');\n";
		$config_data .= "   \$MYSQL_HANDLER = array('".$MYSQL_HANDLER[0]."','".$MYSQL_HANDLER[1]."');\n";
		$config_data .= "\n";
		$config_data .= "   // main nucleus directory\n";
		$config_data .= "   \$DIR_NUCLEUS = '" . $config_adminpath . "';\n";
		$config_data .= "\n";
		$config_data .= "   // path to media dir\n";
		$config_data .= "   \$DIR_MEDIA   = '" . $config_mediapath . "';\n";
		$config_data .= "\n";
		$config_data .= "   // extra skin files for imported skins\n";
		$config_data .= "   \$DIR_SKINS   = '" . $config_skinspath . "';\n";
		$config_data .= "\n";
		$config_data .= "   // these dirs are normally sub dirs of the nucleus dir, but \n";
		$config_data .= "   // you can redefine them if you wish\n";
		$config_data .= "   \$DIR_PLUGINS = \$DIR_NUCLEUS . 'plugins/';\n";
		$config_data .= "   \$DIR_LANG	= \$DIR_NUCLEUS . 'language/';\n";
		$config_data .= "   \$DIR_LIBS	= \$DIR_NUCLEUS . 'libs/';\n";
		$config_data .= "\n";
		$config_data .= "   // include libs\n";
		$config_data .= "   include(\$DIR_LIBS . 'globalfunctions.php');\n";
		$config_data .= "?" . ">";

		$result = @fputs($fp, $config_data, strlen($config_data) );
		fclose($fp);

		if ($result) {
			$bConfigWritten = 1;
		}
	}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title><?php echo _TITLE; ?></title>
	<style>@import url('../nucleus/styles/manual.css');</style>
</head>
<body>
	<div style='text-align:center'><img src='../nucleus/styles/logo.gif' /></div> <!-- Nucleus logo -->

<?php
	$aAllErrors = array_merge($aSkinErrors, $aPlugErrors);

	if (count($aAllErrors) > 0) {
		echo '<h1>' . _TITLE2 . '</h1>';
		echo '<ul><li>' . implode('</li><li>', $aAllErrors) . '</li></ul>';
	}

	if (!$bConfigWritten) { ?>
		<h1><?php echo _TITLE3; ?></h1>

		<?php echo _TEXT10; ?>

		<pre><code>&lt;?php
	// mySQL connection information
	$MYSQL_HOST	 = '<b><?php echo $mysql_host?></b>';
	$MYSQL_USER	 = '<b><?php echo $mysql_user?></b>';
	$MYSQL_PASSWORD = '<i><b>xxxxxxxxxxx</b></i>';
	$MYSQL_DATABASE = '<b><?php echo $mysql_database?></b>';
	$MYSQL_PREFIX   = '<b><?php echo ($mysql_usePrefix == 1)?$mysql_prefix:''?></b>';

	// new in 3.50. first element is db handler, the second is the db driver used by the handler
	// default is $MYSQL_HANDLER = array('mysql','');
	$MYSQL_HANDLER = array('<?php echo $MYSQL_HANDLER[0];?>','<?php echo $MYSQL_HANDLER[1];?>');

	// main nucleus directory
	$DIR_NUCLEUS = '<b><?php echo $config_adminpath?></b>';

	// path to media dir
	$DIR_MEDIA   = '<b><?php echo $config_mediapath?></b>';

	// extra skin files for imported skins
	$DIR_SKINS   = '<b><?php echo $config_skinspath?></b>';

	// these dirs are normally sub dirs of the nucleus dir, but
	// you can redefine them if you wish
	$DIR_PLUGINS = $DIR_NUCLEUS . 'plugins/';
	$DIR_LANG	= $DIR_NUCLEUS . 'language/';
	$DIR_LIBS	= $DIR_NUCLEUS . 'libs/';

	// include libs
	include($DIR_LIBS . 'globalfunctions.php');
?&gt;</code></pre>

	<?php echo _TEXT11; ?>

	<div class="note">
	<?php echo _TEXT12; ?>
	</div>

<?php } else { ?>

	<h1><?php echo _TITLE4; ?></h1>

	<?php echo _TEXT13; ?>

<?php } ?>

	<h1><?php echo _TITLE5; ?></h1>
	
	<?php echo _TEXT14; ?>

	<ul>
		<li><?php echo _TEXT14_L1; ?></li>
		<li><?php echo _TEXT14_L2; ?></li>
	</ul>

	<h1><?php echo _HEADER10; ?></h1>

	<?php echo _TEXT15; ?>

		<ul>
		<li><?php echo _TEXT15_L1; ?></li>
		<li><?php echo _TEXT15_L2; ?></li>
		<li><?php echo _TEXT15_L3; ?></li>
		</ul>

	<?php echo _TEXT16; ?>

	<h1><?php echo _HEADER11; ?></h1>

	<p><?php echo _TEXT16_H; ?>
		<ul>
			<li><a href="<?php echo $config_adminurl?>"><?php echo _TEXT16_L1; ?></a></li>
			<li><a href="<?php echo $config_indexurl?>"><?php echo _TEXT16_L2; ?></a></li>
		</ul>
	</p>

</body>
</html>

<?php
}

function installCustomPlugs(&$manager) {
	global $aConfPlugsToInstall, $DIR_LIBS;

	$aErrors = array();

	if (count($aConfPlugsToInstall) == 0) {
		return $aErrors;
	}

	$res = sql_query('SELECT * FROM ' . sql_table('plugin') );
	$numCurrent = sql_num_rows($res);

	foreach ($aConfPlugsToInstall as $plugName) {
		// do this before calling getPlugin (in case the plugin id is used there)
		$query = 'INSERT INTO ' . sql_table('plugin') . ' (porder, pfile) VALUES (' . (++$numCurrent) . ', "' . addslashes($plugName) . '")';
		sql_query($query);

		// get and install the plugin
		$manager->clearCachedInfo('installedPlugins');
		$plugin =& $manager->getPlugin($plugName);
		$plugin->plugid = $numCurrent;

		if (!$plugin) {
			sql_query('DELETE FROM ' . sql_table('plugin') . ' WHERE pfile=\'' . addslashes($plugName) . '\'');
			$numCurrent--;
			array_push($aErrors, _ERROR22 . $plugName);
			continue;
		}

		$plugin->install();
	}

	// SYNC PLUGIN EVENT LIST
	sql_query('DELETE FROM ' . sql_table('plugin_event') );

	// loop over all installed plugins
	$res = sql_query('SELECT pid, pfile FROM ' . sql_table('plugin') );

	while($o = sql_fetch_object($res) ) {
		$pid  =  $o->pid;
		$plug =& $manager->getPlugin($o->pfile);

		if ($plug) {
			$eventList = $plug->getEventList();

			foreach ($eventList as $eventName) {
				sql_query('INSERT INTO ' . sql_table('plugin_event') . ' (pid, event) VALUES (' . $pid . ', \'' . $eventName . '\')');
			}
		}
	}

	return $aErrors;
}

function installCustomSkins(&$manager) {
	global $aConfSkinsToImport, $DIR_LIBS, $DIR_SKINS;

	$aErrors = array();
	global $manager;
	if (empty($manager)) {
		$manager = new MANAGER;
	}

	if (count($aConfSkinsToImport) == 0) {
		return $aErrors;
	}

	// load skinie class
	include_once($DIR_LIBS . 'skinie.php');

	$importer = new SKINIMPORT();

	foreach ($aConfSkinsToImport as $skinName) {
		$importer->reset();
		$skinFile = $DIR_SKINS . $skinName . '/skinbackup.xml';

		if (!@file_exists($skinFile) ) {
			array_push($aErrors, _ERROR23_1 . $skinFile . ' : ' . _ERROR23_2);
			continue;
		}

		$error = $importer->readFile($skinFile);

		if ($error) {
			array_push($aErrors, _ERROR24 . $skinName . ' : ' . $error);
			continue;
		}

		$error = $importer->writeToDatabase(1);

		if ($error) {
			array_push($aErrors, _ERROR24 . $skinName . ' : ' . $error);
			continue;
		}
	}

	return $aErrors;
}

// give an error if one or more nucleus are not accessible
function doCheckFiles() {
	$missingfiles = array();
	$files = array(
		'install.sql',
		'../index.php',
		'../action.php',
		'../nucleus/index.php',
		'../nucleus/libs/globalfunctions.php',
		'../nucleus/libs/ADMIN.php',
		'../nucleus/libs/BLOG.php',
		'../nucleus/libs/COMMENT.php',
		'../nucleus/libs/COMMENTS.php',
		'../nucleus/libs/ITEM.php',
		'../nucleus/libs/MEMBER.php',
		'../nucleus/libs/SKIN.php',
		'../nucleus/libs/TEMPLATE.php',
		'../nucleus/libs/MEDIA.php',
		'../nucleus/libs/ACTIONLOG.php',
		'../nucleus/media.php'
	);

	$count = count($files);

	for ($i = 0; $i < $count; $i++) {
		if (!is_readable($files[$i]) ) {
			array_push($missingfiles, _ERROR25_1 . $files[$i] . _ERROR25_2);
		}
	}

// The above code replaces several if statements of the form:

//	if (!is_readable('install.sql') ) {
//		array_push($missingfiles, 'File <b>install.sql</b> is missing or not readable');
//	}

	if (count($missingfiles) > 0) {
		showErrorMessages($missingfiles);
	}
}

function updateConfig($name, $val) {
	global $MYSQL_CONN;
	$name = addslashes($name);
	$val  = trim(addslashes($val) );

	$query = 'UPDATE ' . tableName('nucleus_config')
		   . " SET   value = '$val'"
		   . " WHERE name  = '$name'";

	sql_query($query,$MYSQL_CONN) or _doError(_ERROR26 . ': ' . sql_error($MYSQL_CONN) );
	return sql_insert_id($MYSQL_CONN);
}

function replaceDoubleBackslash($input) {
	return str_replace('\\', '/', $input);
}

function endsWithSlash($s) {
	return (strrpos($s, '/') == strlen($s) - 1);
}

/**
 * Checks if email address is valid
 */
function _isValidMailAddress($address) {
	if (preg_match("/^[a-zA-Z0-9\._-]+@+[A-Za-z0-9\._-]+\.+[A-Za-z]{2,4}$/", $address) ) {
		return 1;
	} else {
		return 0;
	}
}

// returns true if the given string is a valid shortname
// (to check short blog names and nicknames)
// logic: starts and ends with a non space, can contain spaces in between
//		min 2 chars
function _isValidShortName($name) {
	if (eregi("^[a-z0-9]+$", $name) ) {
		return 1;
	} else {
		return 0;
	}
}



// returns true if the given string is a valid display name
// (to check nicknames)
function _isValidDisplayName($name) {
	if (eregi("^[a-z0-9]+[a-z0-9 ]*[a-z0-9]+$", $name) ) {
		return 1;
	} else {
		return 0;
	}
}

function _doError($msg) {
	?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title><?php echo _TITLE; ?></title>
	<style>@import url('../nucleus/styles/manual.css');</style>
</head>
<body>
	<div style='text-align:center'><img src='../nucleus/styles/logo.gif' /></div> <!-- Nucleus logo -->
	<h1><?php echo _ERROR27; ?></h1>

	<p><?php echo _ERROR28; ?> "<?php echo $msg; ?>";</p>

	<p><a href="index.php" onclick="history.back();"><?php echo _TEXT17; ?></a></p>
</body>
</html>

<?php
	exit;
}

function showErrorMessages($errors) {
	?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title><?php echo _TITLE; ?></title>
	<style>@import url('../nucleus/styles/manual.css');</style>
</head>
<body>
	<div style='text-align:center'><img src='../nucleus/styles/logo.gif' /></div> <!-- Nucleus logo -->
	<h1><?php echo _ERROR27; ?></h1>

	<p><?php echo _ERROR29; ?>:</p>

	<ul>

<?php
	while($msg = array_shift($errors) ) {
		echo '<li>' . $msg . '</li>';
	}
?>

	</ul>

	<p><a href="index.php" onclick="history.back();return false;"><?php echo _TEXT17; ?></a></p>
</body>
</html>

<?php
	exit;
}

/* for the non-php systems that decide to show the contents:
?></div><?php	*/

?>
