/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.MaterialPreparedStatement;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;

public class CallableStatement
extends PreparedStatement
implements java.sql.PreparedStatement,
java.sql.CallableStatement,
PreparedStatementCallbackInterface {
    public MaterialPreparedStatement materialCallableStatement_ = null;
    private int wasNull_ = 0;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    private static final int WAS_NULL_UNSET = 0;

    private void initCallableStatement() {
        this.materialCallableStatement_ = null;
        this.wasNull_ = 0;
    }

    public void reset(boolean bl) throws SqlException {
        if (bl) {
            this.connection_.resetPrepareCall(this);
        } else {
            super.reset(bl);
        }
        this.wasNull_ = 0;
    }

    public CallableStatement(Agent agent, Connection connection, String string, int n, int n2, int n3) throws SqlException {
        super(agent, connection, string, n, n2, n3, 2, null);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, Connection connection, String string, int n, int n2, int n3) throws SqlException {
        super.resetPreparedStatement(agent, connection, string, n, n2, n3, 2, null);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, Connection connection, String string, Section section) throws SqlException {
        super.resetPreparedStatement(agent, connection, string, section);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, Connection connection, String string, Section section, ColumnMetaData columnMetaData, ColumnMetaData columnMetaData2) throws SqlException {
        super.resetPreparedStatement(agent, connection, string, section, columnMetaData, columnMetaData2);
        this.initCallableStatement();
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize");
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "execute");
            }
            boolean bl = this.executeX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
            }
            return bl;
        }
    }

    boolean executeX() throws SqlException {
        super.flowExecute(3);
        return this.resultSet_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet executeQuery() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "executeQuery");
            }
            ResultSet resultSet = this.executeQueryX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "executeQuery", resultSet);
            }
            return resultSet;
        }
    }

    ResultSet executeQueryX() throws SqlException {
        super.flowExecute(1);
        super.checkExecuteQueryPostConditions("java.sql.CallableStatement");
        return this.resultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "executeUpdate");
            }
            int n = this.executeUpdateX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n);
            }
            return n;
        }
    }

    int executeUpdateX() throws SqlException {
        super.flowExecute(2);
        super.checkExecuteUpdatePostConditions("java.sql.CallableStatement");
        return this.updateCount_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearParameters");
            }
            super.clearParameters();
            this.outputRegistered_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", n, n2);
            }
            this.registerOutParameterX(n, n2);
        }
    }

    void registerOutParameterX(int n, int n2) throws SqlException {
        super.checkForClosedStatement();
        int n3 = 0;
        this.registerOutParameterX(n, n2, n3);
    }

    private int guessScaleForDecimalOrNumeric(int n) throws SqlException {
        if (this.parameterMetaData_.types_[(n = this.checkForEscapedCallWithResult(n)) - 1] == 3 && this.parameters_[n - 1] != null) {
            return this.parameterMetaData_.sqlScale_[n - 1];
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n, int n2, int n3) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", n, n2, n3);
            }
            super.checkForClosedStatement();
            this.registerOutParameterX(n, n2, n3);
        }
    }

    private void registerOutParameterX(int n, int n2, int n3) throws SqlException {
        if ((n = this.checkForEscapedCallWithResult(n, n2)) == 0 && this.escapedProcedureCallWithResult_) {
            return;
        }
        super.checkForValidParameterIndex(n);
        this.checkForValidScale(n3);
        this.outputRegistered_ = true;
        this.parameterRegistered_[n - 1] = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n, int n2, String string) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", n, n2, (Object)string);
            }
            super.checkForClosedStatement();
        }
    }

    public boolean wasNull() throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "wasNull");
        }
        boolean bl = this.wasNullX();
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "wasNull", bl);
        }
        return bl;
    }

    private boolean wasNullX() throws SqlException {
        super.checkForClosedStatement();
        if (this.wasNull_ == 0) {
            throw new SqlException(this.agent_.logWriter_, "Invalid operation: wasNull() called with no data retrieved.");
        }
        return this.wasNull_ == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            boolean bl;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBoolean", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                boolean bl2 = this.agent_.crossConverters_.getBooleanFromInt(this.returnValueFromProcedure_);
                this.wasNull_ = 2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBoolean", bl2);
                }
                return bl2;
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            boolean bl3 = bl = this.wasNullX() ? false : this.singletonRowData_.getBoolean(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBoolean", bl);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            byte by;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getByte", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                byte by2 = this.agent_.crossConverters_.getByteFromInt(this.returnValueFromProcedure_);
                this.wasNull_ = 2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getByte", by2);
                }
                return by2;
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            byte by3 = by = this.wasNullX() ? (byte)0 : this.singletonRowData_.getByte(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getByte", by);
            }
            return by;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            short s;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getShort", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                short s2 = this.agent_.crossConverters_.getShortFromInt(this.returnValueFromProcedure_);
                this.wasNull_ = 2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getShort", s2);
                }
                return s2;
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            short s3 = s = this.wasNullX() ? (short)0 : this.singletonRowData_.getShort(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getShort", s);
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getInt", n);
            }
            int n2 = this.getIntX(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getInt", n2);
            }
            return n2;
        }
    }

    int getIntX(int n) throws SqlException {
        super.checkForClosedStatement();
        n = this.checkForEscapedCallWithResult(n);
        if (n == 0 && this.escapedProcedureCallWithResult_) {
            this.wasNull_ = 2;
            return this.returnValueFromProcedure_;
        }
        this.checkGetterPreconditions(n);
        this.setWasNull(n);
        return this.wasNullX() ? 0 : this.singletonRowData_.getInt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            long l;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getLong", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                long l2 = this.returnValueFromProcedure_;
                this.wasNull_ = 2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getLong", l2);
                }
                return l2;
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            long l3 = l = this.wasNullX() ? 0L : this.singletonRowData_.getLong(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getLong", l);
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            float f;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getFloat", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                float f2 = this.returnValueFromProcedure_;
                this.wasNull_ = 2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getFloat", f2);
                }
                return f2;
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            float f3 = f = this.wasNullX() ? 0.0f : this.singletonRowData_.getFloat(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFloat", f);
            }
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            double d;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDouble", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                double d2 = this.returnValueFromProcedure_;
                this.wasNull_ = 2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDouble", d2);
                }
                return d2;
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            double d3 = d = this.wasNullX() ? 0.0 : this.singletonRowData_.getDouble(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDouble", d);
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n, int n2) throws SqlException, ArithmeticException {
        Connection connection = this.connection_;
        synchronized (connection) {
            BigDecimal bigDecimal;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getBigDecimal", n, n2);
            }
            super.checkForClosedStatement();
            this.checkForValidScale(n2);
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                BigDecimal bigDecimal2 = BigDecimal.valueOf(this.returnValueFromProcedure_).setScale(n2);
                this.wasNull_ = 2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedExit((Object)this, "getBigDecimal", bigDecimal2);
                }
                return bigDecimal2;
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            BigDecimal bigDecimal3 = bigDecimal = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(n);
            if (bigDecimal != null) {
                bigDecimal = bigDecimal.setScale(n2, 1);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedExit((Object)this, "getBigDecimal", bigDecimal);
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            BigDecimal bigDecimal;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBigDecimal", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                BigDecimal bigDecimal2 = BigDecimal.valueOf(this.returnValueFromProcedure_);
                this.wasNull_ = 2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", bigDecimal2);
                }
                return bigDecimal2;
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            BigDecimal bigDecimal3 = bigDecimal = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", bigDecimal);
            }
            return bigDecimal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            Date date;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDate", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                throw new SqlException(this.agent_.logWriter_, "Invalid method call: parameter 1 is an integer OUT parameter returned by the stored procedure, use getInt call.");
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            Date date2 = date = this.wasNullX() ? null : this.singletonRowData_.getDate(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDate", date);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n, Calendar calendar) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDate", n, (Object)calendar);
            }
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, "Invalid parameter: calendar is null");
            }
            Date date = this.getDate(n);
            if (date != null) {
                Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
                calendar2.clear();
                calendar2.setTime(date);
                Calendar calendar3 = Calendar.getInstance();
                calendar3.clear();
                calendar3.setTime(date);
                long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
                date.setTime(date.getTime() - l);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDate", date);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            Time time;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTime", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                throw new SqlException(this.agent_.logWriter_, "Invalid method call: parameter 1 is an integer OUT parameter returned by the stored procedure, use getInt call.");
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            Time time2 = time = this.wasNullX() ? null : this.singletonRowData_.getTime(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTime", time);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n, Calendar calendar) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTime", n, (Object)calendar);
            }
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, "Invalid parameter: calendar is null");
            }
            Time time = this.getTime(n);
            if (time != null) {
                Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
                calendar2.clear();
                calendar2.setTime(time);
                Calendar calendar3 = Calendar.getInstance();
                calendar3.clear();
                calendar3.setTime(time);
                long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
                time.setTime(time.getTime() - l);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTime", time);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            Timestamp timestamp;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                throw new SqlException(this.agent_.logWriter_, "Invalid method call: parameter 1 is an integer OUT parameter returned by the stored procedure, use getInt call.");
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            Timestamp timestamp2 = timestamp = this.wasNullX() ? null : this.singletonRowData_.getTimestamp(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", timestamp);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n, Calendar calendar) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", n, (Object)calendar);
            }
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, "Invalid parameter: calendar is null");
            }
            Timestamp timestamp = this.getTimestamp(n);
            if (timestamp != null) {
                int n2 = timestamp.getNanos();
                Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
                calendar2.clear();
                calendar2.setTime(timestamp);
                Calendar calendar3 = Calendar.getInstance();
                calendar3.clear();
                calendar3.setTime(timestamp);
                long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
                timestamp.setTime(timestamp.getTime() - l);
                timestamp.setNanos(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", timestamp);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getString", n);
            }
            String string = this.getStringX(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getString", string);
            }
            return string;
        }
    }

    String getStringX(int n) throws SqlException {
        super.checkForClosedStatement();
        n = this.checkForEscapedCallWithResult(n);
        if (n == 0 && this.escapedProcedureCallWithResult_) {
            this.wasNull_ = 2;
            return Integer.toString(this.returnValueFromProcedure_);
        }
        this.checkGetterPreconditions(n);
        this.setWasNull(n);
        return this.wasNullX() ? null : this.singletonRowData_.getString(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            byte[] byArray;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBytes", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                throw new SqlException(this.agent_.logWriter_, "Invalid method call: parameter 1 is an integer OUT parameter returned by the stored procedure, use getInt call.");
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            byte[] byArray2 = byArray = this.wasNullX() ? null : this.singletonRowData_.getBytes(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBytes", byArray);
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            Blob blob;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getBlob", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                throw new SqlException(this.agent_.logWriter_, "Invalid method call: parameter 1 is an integer OUT parameter returned by the stored procedure, use getInt call.");
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            Blob blob2 = blob = this.wasNullX() ? null : this.singletonRowData_.getBlob(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getBlob", blob);
            }
            return blob;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            Clob clob;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getClob", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                throw new SqlException(this.agent_.logWriter_, "Invalid method call: parameter 1 is an integer OUT parameter returned by the stored procedure, use getInt call.");
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            Clob clob2 = clob = this.wasNullX() ? null : this.singletonRowData_.getClob(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getClob", clob);
            }
            return clob;
        }
    }

    public Array getArray(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getArray", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                throw new SqlException(this.agent_.logWriter_, "Invalid method call: parameter 1 is an integer OUT parameter returned by the stored procedure, use getInt call.");
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            Array array = this.wasNullX() ? null : this.singletonRowData_.getArray(n);
            throw new SqlException(this.agent_.logWriter_, "jdbc 2 method is not yet implemented");
        }
    }

    public Ref getRef(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getRef", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                throw new SqlException(this.agent_.logWriter_, "Invalid method call: parameter 1 is an integer OUT parameter returned by the stored procedure, use getInt call.");
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            Ref ref = this.wasNullX() ? null : this.singletonRowData_.getRef(n);
            throw new SqlException(this.agent_.logWriter_, "jdbc 2 method is not yet implemented");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            Object object;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getObject", n);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            if (n == 0 && this.escapedProcedureCallWithResult_) {
                Integer n2 = new Integer(this.returnValueFromProcedure_);
                this.wasNull_ = 2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getObject", n2);
                }
                return n2;
            }
            this.checkGetterPreconditions(n);
            this.setWasNull(n);
            Object object2 = object = this.wasNullX() ? null : this.singletonRowData_.getObject(n);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getObject", object);
            }
            return object;
        }
    }

    public Object getObject(int n, Map map) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getObject", n, (Object)map);
            }
            super.checkForClosedStatement();
            n = this.checkForEscapedCallWithResult(n);
            this.checkGetterPreconditions(n);
            throw new SqlException(this.agent_.logWriter_, "jdbc 2 method is not yet implemented.");
        }
    }

    public void registerOutParameter(String string, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", (Object)string, n);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void registerOutParameter(String string, int n, int n2) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", (Object)string, n, n2);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void registerOutParameter(String string, int n, String string2) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", (Object)string, n, (Object)string2);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public URL getURL(int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getURL", n);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setURL(String string, URL uRL) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setURL", (Object)string, (Object)uRL);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setNull(String string, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setNull", (Object)string, n);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setBoolean(String string, boolean bl) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBoolean", (Object)string, bl);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setByte(String string, byte by) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setByte", (Object)string, by);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setShort(String string, short s) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setShort", (Object)string, s);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setInt(String string, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setInt", (Object)string, n);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setLong(String string, long l) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setLong", (Object)string, l);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setFloat(String string, float f) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setFloat", (Object)string, f);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setDouble(String string, double d) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setDouble", (Object)string, d);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBigDecimal", (Object)string, (Object)bigDecimal);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setString(String string, String string2) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setString", (Object)string, (Object)string2);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setBytes(String string, byte[] byArray) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBytes", (Object)string, (Object)byArray);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setDate(String string, Date date) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setDate", (Object)string, (Object)date);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setTime(String string, Time time) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTime", (Object)string, (Object)time);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", (Object)string, (Object)timestamp);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setAsciiStream", (Object)string, (Object)inputStream, n);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBinaryStream", (Object)string, (Object)inputStream, n);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setObject(String string, Object object, int n, int n2) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setObject", (Object)string, object, n, n2);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setObject(String string, Object object, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setObject", (Object)string, object, n);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setObject(String string, Object object) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setObject", (Object)string, object);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setCharacterStream", (Object)string, (Object)reader, n);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setDate(String string, Date date, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setDate", (Object)string, (Object)date, (Object)calendar);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setTime(String string, Time time, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTime", (Object)string, (Object)time, (Object)calendar);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", (Object)string, (Object)timestamp, (Object)calendar);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public void setNull(String string, int n, String string2) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setNull", (Object)string, n, (Object)string2);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public String getString(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getString", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public boolean getBoolean(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBoolean", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public byte getByte(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getByte", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public short getShort(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getShort", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public int getInt(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getInt", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public long getLong(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getLong", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public float getFloat(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getFloat", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public double getDouble(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDouble", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public byte[] getBytes(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBytes", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Date getDate(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDate", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Time getTime(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTime", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Timestamp getTimestamp(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Object getObject(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getObject", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public BigDecimal getBigDecimal(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBigDecimal", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Object getObject(String string, Map map) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getObject", (Object)string, (Object)map);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Ref getRef(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getRef", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Blob getBlob(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBlob", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Clob getClob(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getClob", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Array getArray(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getArray", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Date getDate(String string, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDate", (Object)string, (Object)calendar);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Time getTime(String string, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTime", (Object)string, (Object)calendar);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", (Object)string, (Object)calendar);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    public URL getURL(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getURL", string);
        }
        super.checkForClosedStatement();
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    private int checkForEscapedCallWithResult(int n) throws SqlException {
        if (this.escapedProcedureCallWithResult_) {
            --n;
        }
        return n;
    }

    private int checkForEscapedCallWithResult(int n, int n2) throws SqlException {
        if (this.escapedProcedureCallWithResult_) {
            if (n == 1 && n2 != 4) {
                throw new SqlException(this.agent_.logWriter_, "Parameter 1 is the return caluse of the stored procedure call, it can only be registered as an integer type");
            }
            --n;
        }
        return n;
    }

    private void checkGetterPreconditions(int n) throws SqlException {
        super.checkForValidParameterIndex(n);
        this.checkForValidOutParameter(n);
    }

    private void checkForValidOutParameter(int n) throws SqlException {
        if (this.parameterMetaData_ == null || this.parameterMetaData_.sqlxParmmode_[n - 1] < 2) {
            throw new SqlException(this.agent_.logWriter_, "Invalid argument: parameter index " + n + " is not an OUT or INOUT parameter.");
        }
    }

    private void setWasNull(int n) {
        this.wasNull_ = this.singletonRowData_ == null ? 0 : (this.singletonRowData_.isNull_[n - 1] ? 1 : 2);
    }
}

