/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.ObjectUtils;

public abstract class AbstractMessageSource
implements HierarchicalMessageSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MessageSource parentMessageSource;
    private boolean useCodeAsDefaultMessage = false;
    private boolean alwaysUseMessageFormat = false;
    private final Map cachedMessageFormats = new HashMap();

    public void setParentMessageSource(MessageSource parent) {
        this.parentMessageSource = parent;
    }

    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    public void setUseCodeAsDefaultMessage(boolean useCodeAsDefaultMessage) {
        this.useCodeAsDefaultMessage = useCodeAsDefaultMessage;
    }

    protected boolean isUseCodeAsDefaultMessage() {
        return this.useCodeAsDefaultMessage;
    }

    public void setAlwaysUseMessageFormat(boolean alwaysUseMessageFormat) {
        this.alwaysUseMessageFormat = alwaysUseMessageFormat;
    }

    protected boolean isAlwaysUseMessageFormat() {
        return this.alwaysUseMessageFormat;
    }

    public final String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String fallback;
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        if (defaultMessage == null && (fallback = this.getDefaultMessage(code)) != null) {
            return fallback;
        }
        return this.renderDefaultMessage(defaultMessage, args, locale);
    }

    public final String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        String fallback = this.getDefaultMessage(code);
        if (fallback != null) {
            return fallback;
        }
        throw new NoSuchMessageException(code, locale);
    }

    public final String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String fallback;
        String[] codes = resolvable.getCodes();
        if (codes == null) {
            codes = new String[]{};
        }
        for (int i = 0; i < codes.length; ++i) {
            String msg = this.getMessageInternal(codes[i], resolvable.getArguments(), locale);
            if (msg == null) continue;
            return msg;
        }
        if (resolvable.getDefaultMessage() != null) {
            return this.renderDefaultMessage(resolvable.getDefaultMessage(), resolvable.getArguments(), locale);
        }
        if (codes.length > 0 && (fallback = this.getDefaultMessage(codes[0])) != null) {
            return fallback;
        }
        throw new NoSuchMessageException(codes.length > 0 ? codes[codes.length - 1] : null, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMessageInternal(String code, Object[] args, Locale locale) {
        if (code == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Object[] argsToUse = args;
        if (!this.isAlwaysUseMessageFormat() && ObjectUtils.isEmpty(args)) {
            String message = this.resolveCodeWithoutArguments(code, locale);
            if (message != null) {
                return message;
            }
        } else {
            argsToUse = this.resolveArguments(args, locale);
            MessageFormat messageFormat = this.resolveCode(code, locale);
            if (messageFormat != null) {
                MessageFormat messageFormat2 = messageFormat;
                synchronized (messageFormat2) {
                    return messageFormat.format(argsToUse);
                }
            }
        }
        return this.getMessageFromParent(code, argsToUse, locale);
    }

    protected String getMessageFromParent(String code, Object[] args, Locale locale) {
        MessageSource parent = this.getParentMessageSource();
        if (parent != null) {
            if (parent instanceof AbstractMessageSource) {
                return ((AbstractMessageSource)parent).getMessageInternal(code, args, locale);
            }
            return parent.getMessage(code, args, null, locale);
        }
        return null;
    }

    protected String getDefaultMessage(String code) {
        if (this.isUseCodeAsDefaultMessage()) {
            return code;
        }
        return null;
    }

    protected String renderDefaultMessage(String defaultMessage, Object[] args, Locale locale) {
        return this.formatMessage(defaultMessage, args, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatMessage(String msg, Object[] args, Locale locale) {
        if (msg == null || !this.alwaysUseMessageFormat && (args == null || args.length == 0)) {
            return msg;
        }
        MessageFormat messageFormat = null;
        Object object = this.cachedMessageFormats;
        synchronized (object) {
            messageFormat = (MessageFormat)this.cachedMessageFormats.get(msg);
            if (messageFormat == null) {
                messageFormat = this.createMessageFormat(msg, locale);
                this.cachedMessageFormats.put(msg, messageFormat);
            }
        }
        object = messageFormat;
        synchronized (object) {
            return messageFormat.format(this.resolveArguments(args, locale));
        }
    }

    protected MessageFormat createMessageFormat(String msg, Locale locale) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating MessageFormat for pattern [" + msg + "] and locale '" + locale + "'"));
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        if (msg != null) {
            messageFormat.applyPattern(msg);
        }
        return messageFormat;
    }

    protected Object[] resolveArguments(Object[] args, Locale locale) {
        if (args == null) {
            return new Object[0];
        }
        ArrayList<Object> resolvedArgs = new ArrayList<Object>(args.length);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof MessageSourceResolvable) {
                resolvedArgs.add(this.getMessage((MessageSourceResolvable)args[i], locale));
                continue;
            }
            resolvedArgs.add(args[i]);
        }
        return resolvedArgs.toArray(new Object[resolvedArgs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        MessageFormat messageFormat = this.resolveCode(code, locale);
        if (messageFormat != null) {
            MessageFormat messageFormat2 = messageFormat;
            synchronized (messageFormat2) {
                return messageFormat.format(new Object[0]);
            }
        }
        return null;
    }

    protected abstract MessageFormat resolveCode(String var1, Locale var2);
}

