/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.web.xml;

import javax.sql.DataSource;
import jp.nyx.NyxException;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.web.xml.NxyXmlRpcHandler;
import jp.nyx.pkg.sso.spec.AccessValidaterUtility;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;

public class SsoXmlRpcCheckAuthHandler
implements NxyXmlRpcHandler {
    private AccessValidaterUtility util;
    private NyxManager nyxManager;
    private DataSource ssoDs = null;

    public SsoXmlRpcCheckAuthHandler(DataSource ssoDs) {
        this.ssoDs = ssoDs;
    }

    public Object execute(XmlRpcRequest req) throws XmlRpcException {
        if (NyxException.logger.isDebugEnabled()) {
            NyxException.logger.debug((Object)"jp.nyx.common.web.xml.SsoXmlRpcCheckAuthHandler#execute()");
        }
        if (req.getParameterCount() < 3) {
            throw new XmlRpcException("The RPC is IllegalArgument. Param count is not 3.");
        }
        String requestUrl = (String)req.getParameter(0);
        String requestUri = (String)req.getParameter(1);
        String queryString = (String)req.getParameter(2);
        try {
            return this.util.checkAuth(this.ssoDs, requestUrl, requestUri, queryString);
        }
        catch (Exception e) {
            XmlRpcException xe = new XmlRpcException(e.getMessage());
            xe.initCause((Throwable)e);
            throw xe;
        }
    }

    @Override
    public NyxManager getNyxManager() {
        return this.nyxManager;
    }

    @Override
    public void setNyxManager(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
        this.util = new AccessValidaterUtility(this.nyxManager);
    }

    @Override
    public String getMethodName() {
        return "Sso.checkAuth";
    }
}

