/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.NyxManager;
import jp.nyx.pkg.sso.db.model.PortalMenu;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SsoPortalMenuDao
extends BaseDao {
    private ParameterizedRowMapper<PortalMenu> portalMenuMapper;
    private NyxManager nyxManager;

    protected NyxManager getNyxManager() {
        return this.nyxManager;
    }

    protected SsoPortalMenuDao(NyxManager nyxManager, SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate) {
        super(simpleTemplate, namedTemplate);
        this.nyxManager = nyxManager;
        this.portalMenuMapper = new DefaultParameterizedRowMapper<PortalMenu>(){

            public PortalMenu mapRow(ResultSet rs, int rowNum) throws SQLException {
                PortalMenu ret = new PortalMenu();
                this.mapRow(ret, rs, rowNum);
                ret.setMenuId(rs.getInt("menu_id"));
                ret.setPmenuId(rs.getInt("pmenu_id"));
                ret.setUserId(rs.getString("user_id"));
                ret.setDisplayName(rs.getString("display_name"));
                if (txtUtil.isEmpty(ret.getDisplayName())) {
                    ret.setDisplayName(rs.getString("site_name"));
                }
                ret.setDisplayMode(rs.getString("display_mode"));
                if (txtUtil.isEmpty(ret.getDisplayMode())) {
                    ret.setDisplayMode("visible");
                }
                ret.setDisplayLank(rs.getInt("display_lank"));
                ret.setSiteId(rs.getInt("site_id"));
                ret.setSiteName(rs.getString("site_name"));
                ret.setSitePath(rs.getString("site_path"));
                ret.setBookmark(rs.getString("bookmark"));
                return ret;
            }
        };
    }

    public List<PortalMenu> loadPortalMenu(String userId) {
        List ret = this.simpleTemplate.query("select * from v_portal_menu where user_id=? order by display_lank", this.portalMenuMapper, new Object[]{userId});
        return ret;
    }

    public List<PortalMenu> loadPortalMenu(String userId, String displayMode) {
        List ret = this.simpleTemplate.query("select * from v_portal_menu where user_id=? and (menu_id is null or display_mode=?) order by display_lank", this.portalMenuMapper, new Object[]{userId, displayMode});
        return ret;
    }

    public void savePortalMenu(PortalMenu menu) throws SQLException {
        int r = this.namedTemplate.update("update m_portal_menu_user set pmenu_id=:pmenuId " + txtUtil.getEmpty((Object)menu.getUserId(), ",user_id=:userId ") + txtUtil.getEmpty((Object)menu.getDisplayName(), ",display_name=:displayName ") + txtUtil.getEmpty((Object)menu.getDisplayMode(), ",display_mode=:displayMode ") + txtUtil.getEmpty((Object)menu.getDisplayLank(), ",display_lank=:displayLank ") + txtUtil.getEmpty((Object)menu.getSiteId(), ",site_id=:siteId ") + txtUtil.getEmpty((Object)menu.getBookmark(), ",bookmark=:bookmark ") + "where menu_id=:menuId", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)menu));
        Calendar cal = BaseDao.calUtil.getCalendar();
        menu.setLastUpdate(cal);
        if (r > 0) {
            this.namedTemplate.update("update m_portal_menu_user set verify_startdate=:verifyStartdate " + txtUtil.getEmpty((Object)menu.getVerifyEnddate(), ",verify_enddate=:verifyEnddate ") + txtUtil.getEmpty((Object)menu.getRegistUid(), ",regist_uid=:registUid ") + txtUtil.getEmpty((Object)menu.getUpdateUid(), ",update_uid=:updateUid ") + txtUtil.getEmpty((Object)menu.getLastUpdate(), ",last_update=:lastUpdate ") + txtUtil.getEmpty((Object)menu.getEnableString(), ",enable=:enableString ") + "where menu_id=:menuId", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)menu));
            return;
        }
        long seq = this.nextSequence("m_portal_menu_user_menu_id_seq");
        menu.setMenuId(seq);
        this.namedTemplate.update("insert into m_portal_menu_user(menu_id, pmenu_id" + txtUtil.getEmpty((Object)menu.getUserId(), ", user_id") + txtUtil.getEmpty((Object)menu.getDisplayName(), ", display_name") + txtUtil.getEmpty((Object)menu.getDisplayMode(), ", display_mode") + txtUtil.getEmpty((Object)menu.getLastUpdate(), ", display_lank") + txtUtil.getEmpty((Object)menu.getSiteId(), ", site_id") + txtUtil.getEmpty((Object)menu.getBookmark(), ", bookmark") + ") " + "values(:menuId, :pmenuId" + txtUtil.getEmpty((Object)menu.getUserId(), ", :userId") + txtUtil.getEmpty((Object)menu.getDisplayName(), ", :displayName") + txtUtil.getEmpty((Object)menu.getDisplayMode(), ", :displayMode") + txtUtil.getEmpty((Object)menu.getDisplayLank(), ", :displayLank") + txtUtil.getEmpty((Object)menu.getSiteId(), ", :siteId") + txtUtil.getEmpty((Object)menu.getBookmark(), ", :bookmark") + ")", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)menu));
        this.namedTemplate.update("update m_portal_menu_user set verify_startdate=:verifyStartdate " + txtUtil.getEmpty((Object)menu.getVerifyEnddate(), ",verify_enddate=:verifyEnddate ") + txtUtil.getEmpty((Object)menu.getRegistUid(), ",regist_uid=:registUid ") + txtUtil.getEmpty((Object)menu.getUpdateUid(), ",update_uid=:updateUid ") + txtUtil.getEmpty((Object)menu.getLastUpdate(), ",last_update=:lastUpdate ") + txtUtil.getEmpty((Object)menu.getEnableString(), ",enable=:enableString ") + "where menu_id=:menuId", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)menu));
    }

    public void deletePortalMenu(String user_id) {
        this.simpleTemplate.update("delete from m_portal_menu_user where user_id=?", new Object[]{user_id});
    }

    public void clearCashe() {
    }
}

