/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.AccessContext;
import jp.nyx.common.db.model.AccessUser;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.ContextLink;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Ext;
import jp.nyx.common.db.model.User;
import jp.nyx.pkg.sso.db.SsoPortalMenuDao;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SsoUserDao
extends BaseDao {
    public static final String DESABLE_TEXT = "[ \u975e\u516c\u958b\u60c5\u5831 ]";
    public static final String OPEN = "open";
    private ParameterizedRowMapper<User> userMapper;
    private ParameterizedRowMapper<ContextLink> contextLinkMapper;
    private SsoPortalMenuDao ssoPortalMenuDao;
    private NyxManager nyxManager;
    private Map<String, User> cashe = new HashMap<String, User>();

    protected SsoUserDao(NyxManager nyxManager, SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate, SsoPortalMenuDao ssoPortalMenuDao) {
        super(simpleTemplate, namedTemplate);
        this.nyxManager = nyxManager;
        this.ssoPortalMenuDao = ssoPortalMenuDao;
        this.userMapper = new DefaultParameterizedRowMapper<User>(){

            public User mapRow(ResultSet rs, int rowNum) throws SQLException {
                User ret = new User();
                this.mapRow((DefaultModel)ret, rs, rowNum);
                ret.setUserId(rs.getString("user_id"));
                ret.setUserName(rs.getString("user_name"));
                ret.setPasswd(rs.getString("passwd"));
                ret.setUnixUid(rs.getInt("unix_uid"));
                ret.setUnixGid(rs.getInt("unix_gid"));
                ret.setUnixGname(rs.getString("unix_gname"));
                SsoUserDao.this.cashe.put(ret.getUserId(), ret);
                return ret;
            }
        };
        this.contextLinkMapper = new DefaultParameterizedRowMapper<ContextLink>(){

            public ContextLink mapRow(ResultSet rs, int rowNum) throws SQLException {
                ContextLink ret = new ContextLink();
                ret.setContextCode((long)rs.getInt("context_code"));
                ret.setContextType(rs.getString("context_type"));
                ret.setContextName(rs.getString("context_name"));
                return ret;
            }
        };
    }

    protected NyxManager getNyxManager() {
        return this.nyxManager;
    }

    public User loadUser(String userId, Access access) {
        if (this.cashe.containsKey(userId)) {
            return this.cashe.get(userId);
        }
        User user = this.loadUser(userId);
        Ext s = this.getExtValue(user, "self");
        boolean disable = !access.canAccess(user);
        user.setSessionDisable(disable);
        boolean allDesable = false;
        if (disable && !OPEN.equals(s.getFieldModify())) {
            user.setUserId(DESABLE_TEXT);
            user.setUserName(DESABLE_TEXT);
            allDesable = true;
        }
        Map exts = user.getExt();
        for (String fn : exts.keySet()) {
            Ext ex = (Ext)exts.get(fn);
            if (!allDesable && (!disable || OPEN.equals(ex.getFieldModify()))) continue;
            ex.setSessionDisable(true);
            ex.setFieldValue(DESABLE_TEXT);
        }
        Set auSet = user.getAccessUser();
        for (AccessUser a : auSet) {
            auSet.add(a);
            if (!disable) continue;
            a.setVerifyUserName(DESABLE_TEXT);
        }
        return user;
    }

    public User loadUser(String userId) {
        if (userId == null) {
            return null;
        }
        if (this.cashe.containsKey(userId)) {
            return this.cashe.get(userId);
        }
        User ret = null;
        try {
            List ext = this.simpleTemplate.query("select * from m_user_ext where user_id=?", this.extMapper, new Object[]{userId});
            List contextLink = this.simpleTemplate.query("select * from (select c.* from m_context_user cu left join m_context c on (cu.context_code=c.context_code) where cu.user_id=? and c.enable='t') context ", this.contextLinkMapper, new Object[]{userId});
            List accessUser = this.simpleTemplate.query("select a.*, u.user_name as verify_user_name from m_user_access_user a left join m_user u on (a.verify_user_id=u.user_id) where a.user_id=?", this.accessUserMapper, new Object[]{userId});
            List accessContext = this.simpleTemplate.query("select a.*, c.context_name as verify_context_name from m_user_access_context a left join m_context c on (a.verify_context_code=c.context_code) where a.user_id=?", this.accessContextMapper, new Object[]{userId});
            ret = (User)this.simpleTemplate.queryForObject("select * from m_user where user_id=?", this.userMapper, new Object[]{userId});
            Map extMap = ret.getExt();
            for (Ext ex : ext) {
                extMap.put(ex.getFieldName(), ex);
            }
            Set clSet = ret.getContextLink();
            for (ContextLink c : contextLink) {
                clSet.add(c);
            }
            Set auSet = ret.getAccessUser();
            for (AccessUser a : accessUser) {
                auSet.add(a);
            }
            Set ac = ret.getAccessContext();
            for (AccessContext a : accessContext) {
                ac.add(a);
            }
        }
        catch (Exception e) {
            ret = new User();
            ret.setUserId(userId);
        }
        return ret;
    }

    public List<User> loadUser(int offset, int limit, ConditionList conditions) throws SQLException {
        List<String> ids = this.loadUserIds(offset, limit, conditions);
        if (ids.size() <= 0) {
            return new ArrayList<User>();
        }
        ArrayList<User> ret = new ArrayList<User>();
        Access access = conditions.getAccess();
        for (String i : ids) {
            User u = this.loadUser(i, access);
            ret.add(u);
        }
        return ret;
    }

    public List<String> loadUserIds(ConditionList conditions) throws SQLException {
        return this.loadUserIds(0, -1, conditions);
    }

    public List<String> loadUserIds(int offset, int limit, ConditionList conditions) throws SQLException {
        ArrayList cond = new ArrayList();
        String where = BaseDao.genWhereString((ConditionList)conditions, cond);
        if (this.nyxManager.isPostgreSQL()) {
            return this.simpleTemplate.query("select distinct user_id from (select u.*,c.context_code,c.context_type,c.context_name from m_user u left join m_context_user cu on (u.user_id=cu.user_id) left join m_context c on (cu.context_code=c.context_code and c.enable='t')) users " + where + " order by user_id" + (limit > 0 ? " offset " + offset + " limit " + limit : ""), (ParameterizedRowMapper)new ParameterizedRowMapper<String>(){

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getString("user_id");
                }
            }, cond.toArray());
        }
        return this.simpleTemplate.query("select distinct user_id from (select u.*,c.context_code,c.context_type,c.context_name from m_user u left join m_context_user cu on (u.user_id=cu.user_id) left join m_context c on (cu.context_code=c.context_code and c.enable='t')) users " + where + " order by user_id", (ParameterizedRowMapper)new ParameterizedRowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("user_id");
            }
        }, cond.toArray());
    }

    public void saveUser(User user, Access access) {
        if (!access.canAccess(user) || user.isSessionDisable()) {
            return;
        }
        int r = this.namedTemplate.update("update m_user set user_name=:userName ,passwd=:passwd ,unix_uid=:unixUid ,unix_gid=:unixGid " + txtUtil.getEmpty((Object)user.getUnixGname(), ",unix_gname=:unixGname ") + "where user_id=:userId", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)user));
        if (r > 0) {
            this.saveExt("m_user_ext", "user_id", user.getUserId(), user.getExt());
            this.saveAccessUser("m_user_access_user", "user_id", user.getUserId(), user.getAccessUser());
            this.saveAccessContext("m_user_access_context", "user_id", user.getUserId(), user.getAccessContext());
            this.saveSsoDefault("m_user", "user_id", user.getUserId(), (DefaultModel)user);
            return;
        }
        this.namedTemplate.update("insert into m_user(user_id, user_name, passwd, unix_uid, unix_gid" + txtUtil.getEmpty((Object)user.getUnixGname(), ", unix_gname") + ") " + "values(:userId, :userName, :passwd, :unixUid, :unixGid" + txtUtil.getEmpty((Object)user.getUnixGname(), ", :unixGname") + ")", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)user));
        this.saveExt("m_user_ext", "user_id", user.getUserId(), user.getExt());
        this.saveAccessUser("m_user_access_user", "user_id", user.getUserId(), user.getAccessUser());
        this.saveAccessContext("m_user_access_context", "user_id", user.getUserId(), user.getAccessContext());
        this.saveSsoDefault("m_user", "user_id", user.getUserId(), (DefaultModel)user);
    }

    public void deleteUser(String userId, Access access) {
        User user = this.loadUser(userId);
        if (!access.canAccess(user)) {
            return;
        }
        this.ssoPortalMenuDao.deletePortalMenu(userId);
        this.simpleTemplate.update("delete from m_user_access_user where user_id=?", new Object[]{userId});
        this.simpleTemplate.update("delete from m_user_access_context where user_id=?", new Object[]{userId});
        this.simpleTemplate.update("delete from m_user_ext where user_id=?", new Object[]{userId});
        this.simpleTemplate.update("delete from m_user where user_id=?", new Object[]{userId});
    }

    private Ext getExtValue(User target, String key) {
        Map exts = target.getExt();
        Ext ext = (Ext)exts.get(key);
        if (ext == null) {
            ext = new Ext();
            exts.put(key, ext);
        }
        ext.setFieldName(key);
        return ext;
    }

    public void clearCashe() {
        this.cashe.clear();
    }
}

