/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles2;

import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.support.JstlUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.util.WebUtils;

public class TilesView
extends AbstractUrlBasedView {
    private MessageSource jstlAwareMessageSource;

    protected void initApplicationContext() {
        super.initApplicationContext();
        this.jstlAwareMessageSource = JstlUtils.getJstlAwareMessageSource(this.getServletContext(), (MessageSource)this.getApplicationContext());
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TilesContainer container = TilesAccess.getContainer((Object)this.getServletContext());
        if (container == null) {
            throw new ServletException("Tiles container is not initialized. Have you added a TilesConfigurer to your web application context?");
        }
        this.exposeModelAsRequestAttributes(model, request);
        JstlUtils.exposeLocalizationContext(request, this.jstlAwareMessageSource);
        if (!response.isCommitted()) {
            WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
        }
        container.render(this.getUrl(), new Object[]{request, response});
    }
}

