/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.web.xml;

import jp.nyx.common.db.Access;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.common.db.model.User;
import jp.nyx.common.util.WebUtility;
import jp.nyx.common.web.xml.NxyXmlRpcHandler;
import jp.nyx.common.web.xml.NyxXmlRpcHandlerMapping;
import jp.nyx.pkg.sso.db.SsoManager;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;

public class SsoXmlRpcGetContextHandler
implements NxyXmlRpcHandler {
    private NyxManager nyxManager;
    private SsoManager ssoManager = null;
    private WebUtility webUtil = new WebUtility();

    public SsoXmlRpcGetContextHandler(SsoManager ssoManager) {
        this.ssoManager = ssoManager;
    }

    public Object execute(XmlRpcRequest req) throws XmlRpcException {
        if (req.getParameterCount() < 2) {
            throw new XmlRpcException("The RPC is IllegalArgument. Param count is not 2 or 3.");
        }
        String selfId = (String)req.getParameter(0);
        Object context_code = req.getParameter(1);
        if (NyxXmlRpcHandlerMapping.textUtil.isEmpty(selfId)) {
            throw new XmlRpcException("The RPC is IllegalArgument. Self UserID is empty.");
        }
        if (!(context_code instanceof Long)) {
            throw new XmlRpcException("The RPC is IllegalArgument. Context Code is empty or isn't java.lang.Long type.");
        }
        boolean bridgeUser = req.getParameterCount() > 2 && "true".equals(req.getParameter(2));
        Access access = AccessFactory.createAccess(PersonalAccess.class);
        try {
            access.setAdmin(this.nyxManager.isAdmin(selfId));
            access.setPersonalAdmin(this.nyxManager.isPersonalAdmin(selfId));
            User self = this.ssoManager.loadUser(selfId);
            access.setSelf(self);
            Context context = this.ssoManager.loadContext(this.webUtil.numUtil.parseLong(context_code, -1L), access, bridgeUser);
            return context;
        }
        catch (Exception e) {
            XmlRpcException xe = new XmlRpcException(e.getMessage());
            xe.initCause((Throwable)e);
            throw xe;
        }
    }

    @Override
    public NyxManager getNyxManager() {
        return this.nyxManager;
    }

    @Override
    public void setNyxManager(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
    }

    @Override
    public String getMethodName() {
        return "Sso.getContext";
    }
}

