/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.web.xml;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.SQLException;
import jp.nyx.NyxException;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.web.xml.NxyXmlRpcHandler;
import jp.nyx.pkg.sso.db.SsoManager;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;

public class SsoXmlRpcLogImportHandler
implements NxyXmlRpcHandler {
    private NyxManager nyxManager;
    private SsoManager ssoManager = null;

    public SsoXmlRpcLogImportHandler(SsoManager ssoManager) {
        this.ssoManager = ssoManager;
    }

    public Object execute(XmlRpcRequest req) throws XmlRpcException {
        try {
            File[] logFiles;
            File logDir = new File("logs");
            for (File f : logFiles = logDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File f, String fn) {
                    if (fn == null) {
                        return false;
                    }
                    return fn.matches("nyx.kernel.log.[0-9]{4}-[0-9]{2}-[0-9]{2}-?[0-9]*");
                }
            })) {
                if (!f.canWrite()) continue;
                this.ssoManager.saveLog(f);
                f.delete();
            }
            this.ssoManager.deleteLog(this.nyxManager.loadSetting());
            return true;
        }
        catch (NyxException e) {
            XmlRpcException xe = new XmlRpcException(e.getMessage());
            xe.initCause((Throwable)e);
            throw xe;
        }
        catch (SQLException e) {
            XmlRpcException xe = new XmlRpcException(e.getMessage());
            xe.initCause((Throwable)e);
            throw xe;
        }
    }

    @Override
    public NyxManager getNyxManager() {
        return this.nyxManager;
    }

    @Override
    public void setNyxManager(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
    }

    @Override
    public String getMethodName() {
        return "Sso.logImport";
    }
}

