/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.pkg.sso.db.SsoAuthDao;
import jp.nyx.pkg.sso.db.SsoContextDao;
import jp.nyx.pkg.sso.db.SsoLogDao;
import jp.nyx.pkg.sso.db.SsoPortalMenuDao;
import jp.nyx.pkg.sso.db.SsoPortalNoticeDao;
import jp.nyx.pkg.sso.db.SsoPortalSettingDao;
import jp.nyx.pkg.sso.db.SsoSiteDao;
import jp.nyx.pkg.sso.db.SsoUserDao;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class SsoDao
extends JdbcDaoSupport {
    private SimpleJdbcTemplate simpleTemplate;
    private NamedParameterJdbcTemplate namedTemplate;
    private NyxManager nyxManager;
    protected SsoUserDao ssoUserDao;
    protected SsoContextDao ssoContextDao;
    protected SsoSiteDao ssoSiteDao;
    protected SsoAuthDao ssoAuthDao;
    protected SsoPortalMenuDao ssoPortalMenuDao;
    protected SsoPortalSettingDao ssoPortalSettingDao;
    protected SsoPortalNoticeDao ssoPortalNoticeDao;
    protected SsoLogDao ssoLogDao;

    public boolean isInit() {
        try {
            this.simpleTemplate.queryForList("select update_uid from m_auth where 1=0", new Object[0]);
            this.simpleTemplate.queryForList("select verify_startdate from m_user where 1=0", new Object[0]);
            this.simpleTemplate.queryForList("select menu_id from m_portal_menu_user where 1=0", new Object[0]);
            this.simpleTemplate.queryForList("select * from m_portal_notice where 1=0", new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void initTemplateConfig() {
        super.initTemplateConfig();
        this.simpleTemplate = new SimpleJdbcTemplate((JdbcOperations)this.getJdbcTemplate());
        this.namedTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.getJdbcTemplate());
        this.ssoPortalMenuDao = new SsoPortalMenuDao(this.nyxManager, this.simpleTemplate, this.namedTemplate);
        this.ssoUserDao = new SsoUserDao(this.nyxManager, this.simpleTemplate, this.namedTemplate, this.ssoPortalMenuDao);
        this.ssoContextDao = new SsoContextDao(this.nyxManager, this.simpleTemplate, this.namedTemplate, this.ssoUserDao);
        this.ssoSiteDao = new SsoSiteDao(this.nyxManager, this.simpleTemplate, this.namedTemplate);
        this.ssoAuthDao = new SsoAuthDao(this.nyxManager, this.simpleTemplate, this.namedTemplate, this.ssoUserDao, this.ssoContextDao, this.ssoSiteDao);
        this.ssoPortalSettingDao = new SsoPortalSettingDao(this.nyxManager, this.simpleTemplate, this.namedTemplate);
        this.ssoPortalNoticeDao = new SsoPortalNoticeDao(this.nyxManager, this.simpleTemplate, this.namedTemplate);
        this.ssoLogDao = new SsoLogDao(this.nyxManager, this.simpleTemplate, this.namedTemplate);
    }

    protected int update(String sql) throws SQLException {
        return this.ssoUserDao.update(sql);
    }

    protected int update(String macroSql, Object ... params) throws SQLException {
        return this.ssoUserDao.update(macroSql, params);
    }

    protected int loadDataCount(String table, ConditionList conditions) {
        return this.ssoUserDao.loadDataCount(table, conditions);
    }

    protected int loadDataCount(String table, String coloum, ConditionList conditions) {
        return this.ssoUserDao.loadDataCount(table, coloum, conditions);
    }

    protected List<String> loadString(String coloum, String table, String whereKey, int whereVal) {
        return this.ssoUserDao.loadString(coloum, table, whereKey, whereVal);
    }

    protected List<Long> loadLong(String coloum, String table, String whereKey, int whereVal) {
        return this.ssoUserDao.loadLong(coloum, table, whereKey, whereVal);
    }

    protected long loadMaxLong(String coloum, String table) {
        return this.ssoUserDao.loadMaxLong(coloum, table);
    }

    public void setNyxManager(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
    }

    public void clearCashe() throws SQLException {
        this.ssoAuthDao.clearCashe();
        this.ssoUserDao.clearCashe();
        this.ssoContextDao.clearCashe();
        this.ssoSiteDao.clearCashe();
        this.ssoPortalMenuDao.clearCashe();
        this.ssoPortalSettingDao.clearCashe();
        this.ssoPortalNoticeDao.clearCashe();
        this.ssoLogDao.clearCashe();
        Map nyx = this.nyxManager.loadSetting();
        Setting kernel_log_verbose = (Setting)nyx.get("kernel_log_verbose");
        if (kernel_log_verbose != null) {
            boolean verbose;
            this.ssoUserDao.verbose = verbose = "on".equals(kernel_log_verbose.getValue());
            this.ssoContextDao.verbose = verbose;
            this.ssoSiteDao.verbose = verbose;
            this.ssoAuthDao.verbose = verbose;
            this.ssoPortalMenuDao.verbose = verbose;
            this.ssoPortalSettingDao.verbose = verbose;
            this.ssoPortalNoticeDao.verbose = verbose;
            this.ssoLogDao.verbose = verbose;
        }
    }

    public boolean isDerby() throws SQLException {
        Map nyx = this.nyxManager.loadSetting();
        return !"postgresql".equals(((Setting)nyx.get("sso_jdbc_type")).getValue());
    }

    public boolean isPostgreSQL() throws SQLException {
        Map nyx = this.nyxManager.loadSetting();
        return "postgresql".equals(((Setting)nyx.get("sso_jdbc_type")).getValue());
    }
}

