/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.PortalSetting;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SsoPortalSettingDao
extends BaseDao {
    private ParameterizedRowMapper<PortalSetting> portalSettingMapper;
    private NyxManager nyxManager;

    protected SsoPortalSettingDao(NyxManager nyxManager, SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate) {
        super(simpleTemplate, namedTemplate);
        this.nyxManager = nyxManager;
        this.portalSettingMapper = new DefaultParameterizedRowMapper<PortalSetting>(){

            public PortalSetting mapRow(ResultSet rs, int rowNum) throws SQLException {
                PortalSetting ret = new PortalSetting();
                this.mapRow((DefaultModel)ret, rs, rowNum);
                ret.setName(rs.getString("name"));
                ret.setValue(rs.getString("value"));
                return ret;
            }
        };
    }

    public PortalSetting loadPortalSetting(String name) {
        if (name == null) {
            return null;
        }
        PortalSetting ret = (PortalSetting)this.simpleTemplate.queryForObject("select * from m_portal_setting where name=?", this.portalSettingMapper, new Object[]{name});
        return ret;
    }

    public List<PortalSetting> loadPortalSetting(int offset, int limit, ConditionList conditions) throws SQLException {
        List ids = this.loadString("name", "m_portal_setting", conditions, offset, limit, "name");
        if (ids.size() <= 0) {
            return new ArrayList<PortalSetting>();
        }
        ArrayList<PortalSetting> ret = new ArrayList<PortalSetting>();
        for (String i : ids) {
            ret.add(this.loadPortalSetting(i));
        }
        return ret;
    }

    public void savePortalSetting(PortalSetting setting) {
        int r = this.namedTemplate.update("update m_portal_setting set value=:value where name=:name", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)setting));
        if (r > 0) {
            this.saveSsoDefault("m_portal_setting", "name", setting.getName(), (DefaultModel)setting);
            return;
        }
        this.namedTemplate.update("insert into m_portal_setting(name, value) values(:name, :value)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)setting));
        this.saveSsoDefault("m_portal_setting", "name", setting.getName(), (DefaultModel)setting);
    }

    public void deletePortalSetting(String name) {
        this.simpleTemplate.update("delete from m_portal_setting where name=?", new Object[]{name});
    }

    public void clearCashe() {
    }

    public boolean isDerby() throws SQLException {
        Map nyx = this.nyxManager.loadSetting();
        return !"postgresql".equals(((Setting)nyx.get("sso_jdbc_type")).getValue());
    }

    public boolean isPostgreSQL() throws SQLException {
        Map nyx = this.nyxManager.loadSetting();
        return "postgresql".equals(((Setting)nyx.get("sso_jdbc_type")).getValue());
    }
}

