/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Tieup;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.web.servlet.ModelAndView;

public class TieupController
extends SsoController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = super.handleRequestInternal(request, response);
        NyxManager nyxManager = this.getNyxManager(request);
        mv.getModel().put("tiupType", Tieup.TiupType.values());
        mv.getModel().put("tiupUse", Tieup.TiupUse.values());
        ConditionList cond = new ConditionList(this.getPersonalAccess(request));
        List tieups = nyxManager.loadTieup(this.getOffset(mv), this.getLimit(mv), cond);
        mv.getModel().put("tieups", tieups);
        mv.getModel().put("tiupTypes", Tieup.TiupType.values());
        mv.getModel().put("tiupUses", Tieup.TiupUse.values());
        if ("add".equals(request.getParameter("mode"))) {
            Tieup tieup = new Tieup();
            mv.getModel().put("tieup", tieup);
        } else if ("adddo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                Tieup tieup = new Tieup();
                tieup.setRegistUid(this.getRemoteUser(mv));
                tieup.setUpdateUid(this.getRemoteUser(mv));
                if (!this.save(tieup, request, status)) {
                    return mv;
                }
                nyxManager.saveTieup(tieup);
                status.put("status", "Successed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("edit".equals(request.getParameter("mode"))) {
            Tieup tieup = nyxManager.loadTieup((long)this.webUtil.numUtil.parseInt(request.getParameter("tieup_code")));
            mv.getModel().put("tieup", tieup);
        } else if ("editdo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                Tieup tieup = nyxManager.loadTieup((long)this.webUtil.numUtil.parseInt(request.getParameter("tieup_code")));
                if (!this.save(tieup, request, status)) {
                    return mv;
                }
                tieup.setUpdateUid(this.getRemoteUser(mv));
                nyxManager.saveTieup(tieup);
                status.put("status", "Successed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("deldo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                nyxManager.deleteTieup((long)this.webUtil.numUtil.parseInt(request.getParameter("tieup_code")));
                status.put("status", "Successed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        }
        return mv;
    }

    private boolean save(Tieup tieup, HttpServletRequest request, Map<String, String> status) throws NoSuchAlgorithmException, MessagingException, IOException {
        Calendar cal;
        String tieupName = request.getParameter("tieup_name");
        String tieupType = request.getParameter("tieup_type");
        String tieupUse = request.getParameter("tieup_use");
        String tieupProtocol = request.getParameter("tieup_protocol");
        String tieupModify = request.getParameter("tieup_modify");
        String tieupServer = request.getParameter("tieup_server");
        String tieupNote = request.getParameter("tieup_note");
        if (this.webUtil.textUtil.isEmpty(tieupName)) {
            status.put("status", "Failed");
            status.put("message", "\u30b5\u30a4\u30c8\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        if (this.webUtil.textUtil.isEmpty(tieupType)) {
            status.put("status", "Failed");
            status.put("message", "\u9023\u643a\u578b\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        if (this.webUtil.textUtil.isEmpty(tieupUse)) {
            status.put("status", "Failed");
            status.put("message", "\u9023\u643a\u306e\u7528\u6cd5\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        if (this.webUtil.textUtil.isEmpty(tieupProtocol)) {
            status.put("status", "Failed");
            status.put("message", "\u9023\u643a\u30d7\u30ed\u30c8\u30b3\u30eb\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        if (this.webUtil.textUtil.isEmpty(tieupServer)) {
            status.put("status", "Failed");
            status.put("message", "\u9023\u643a\u30b5\u30fc\u30d0\u30fc\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        tieup.setTieupName(tieupName);
        tieup.setTieupType(tieupType);
        tieup.setTieupUse(tieupUse);
        tieup.setTieupProtocol(tieupProtocol);
        tieup.setTieupModify(tieupModify);
        tieup.setTieupServer(tieupServer);
        tieup.setTieupNote(tieupNote);
        String verify_startdate = request.getParameter("verify_startdate");
        String verify_enddate = request.getParameter("verify_enddate");
        if (!this.webUtil.textUtil.isEmpty(verify_startdate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_startdate, "yyyy/MM/dd");
                tieup.setVerifyStartdate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u958b\u59cb\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            tieup.setVerifyStartdate(null);
        }
        if (!this.webUtil.textUtil.isEmpty(verify_enddate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_enddate, "yyyy/MM/dd");
                tieup.setVerifyEnddate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u7d42\u4e86\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            tieup.setVerifyEnddate(null);
        }
        tieup.setEnable("true".equals(request.getParameter("enable")));
        return true;
    }
}

