/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.nyx.NyxException;
import jp.nyx.NyxLicense;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.SettingMap;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Ext;
import jp.nyx.common.db.model.Tieup;
import jp.nyx.common.util.PkiUtility;
import jp.nyx.common.util.WebUtility;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.postgresql.Driver;
import org.springframework.core.SpringVersion;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class NyxDao
extends BaseDao {
    private ParameterizedRowMapper<Tieup> tieupMapper;
    private WebUtility webUtil = new WebUtility();
    private Map<String, Setting> nyx;

    @Override
    protected void initTemplateConfig() {
        super.initTemplateConfig();
        this.simpleTemplate = new SimpleJdbcTemplate((JdbcOperations)this.getJdbcTemplate());
        this.namedTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.getJdbcTemplate());
        this.tieupMapper = new DefaultParameterizedRowMapper<Tieup>(){

            public Tieup mapRow(ResultSet rs, int rowNum) throws SQLException {
                Tieup ret = new Tieup();
                this.mapRow(ret, rs, rowNum);
                ret.setTieupCode(rs.getLong("tieup_code"));
                ret.setTieupName(rs.getString("tieup_name"));
                ret.setTieupType(rs.getString("tieup_type"));
                ret.setTieupUse(rs.getString("tieup_use"));
                ret.setTieupProtocol(rs.getString("tieup_protocol"));
                ret.setTieupModify(rs.getString("tieup_modify"));
                ret.setTieupServer(rs.getString("tieup_server"));
                ret.setTieupNote(rs.getString("tieup_note"));
                return ret;
            }
        };
    }

    @Override
    public int update(String sql) throws SQLException {
        if (this.verbose) {
            NyxException.logger.debug((Object)sql);
        }
        return this.simpleTemplate.update(sql, new Object[0]);
    }

    protected List<Map<String, Object>> query(String sql, Object ... args) throws SQLException {
        if (this.verbose) {
            NyxException.logger.debug((Object)sql);
        }
        return this.simpleTemplate.queryForList(sql, args);
    }

    public boolean isInit() {
        try {
            List line = this.simpleTemplate.queryForList("select VALUE from nyx_setting where name='kernel_lastboot'", new Object[0]);
            Calendar now = this.webUtil.calUtil.getCalendar();
            if (line.size() <= 0) {
                String lastStr = this.webUtil.calUtil.formatCalendar(now, "yyyy/MM/dd HH:mm:ss");
                this.simpleTemplate.update("update nyx_setting set value=? where name=?", new Object[]{lastStr, "kernel_lastboot"});
                return false;
            }
            String lastStr = ((Map)line.get(0)).get("VALUE").toString();
            if (this.webUtil.textUtil.isEmpty(lastStr)) {
                lastStr = this.webUtil.calUtil.formatCalendar(now, "yyyy/MM/dd HH:mm:ss");
                this.simpleTemplate.update("update nyx_setting set value=? where name=?", new Object[]{lastStr, "kernel_lastboot"});
                return false;
            }
            Calendar last = this.webUtil.calUtil.parseCalendar(lastStr, "yyyy/MM/dd HH:mm:ss");
            if (now.after(last)) {
                lastStr = this.webUtil.calUtil.formatCalendar(now, "yyyy/MM/dd HH:mm:ss");
                this.simpleTemplate.update("update nyx_setting set value=? where name=?", new Object[]{lastStr, "kernel_lastboot"});
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, Setting> loadSetting() throws SQLException {
        if (this.nyx != null) {
            return this.nyx;
        }
        List res = this.simpleTemplate.query("select * from nyx_setting order by parent,name", (ParameterizedRowMapper)new ParameterizedRowMapper<Setting>(){
            private EmbeddedDriver derby = new EmbeddedDriver();
            private Driver pgsql = new Driver();
            private String derby_version = "v" + this.derby.getMajorVersion() + "." + this.derby.getMinorVersion();
            private String pgsql_version = "v" + this.pgsql.getMajorVersion() + "." + this.pgsql.getMinorVersion();
            private String spring_version = SpringVersion.getVersion();

            public Setting mapRow(ResultSet rs, int rowNum) throws SQLException {
                String v = rs.getString("value");
                v = ((NyxDao)NyxDao.this).webUtil.textUtil.nvl(v);
                v = v.replace("${spring_version}", this.spring_version);
                v = v.replace("${derby_version}", this.derby_version);
                v = v.replace("${pgsql_version}", this.pgsql_version);
                v = v.replace("${crypt_version}", PkiUtility.getProviderVersion());
                v = v.replace("${license_limit}", NyxLicense.getLicenseLimit());
                v = v.replace("${kernel_title}", "Nyx Kernel");
                v = v.replace("${kernel_version}", "0.5.9.e");
                v = v.replace("${kernel_copy}", "Copyright (C) 2005-2008 Nyx Project. All right reserved.");
                v = v.replace("${kernel_owner}", "Y.Hamanaka at 2005-th");
                v = v.replace("${kernel_extjs}", "Ext 2.0 by extjs.com");
                return new Setting(rs.getString("name"), rs.getString("parent"), rs.getString("mode"), rs.getString("modify"), v, rs.getString("display"));
            }
        }, new Object[0]);
        this.nyx = new SettingMap<String, Setting>();
        int n = res.size();
        for (int i = 0; i < n; ++i) {
            Setting c = (Setting)res.get(i);
            this.nyx.put(c.getName(), c);
        }
        Setting kernel_log_verbose = this.nyx.get("kernel_log_verbose");
        if (kernel_log_verbose != null) {
            this.verbose = "on".equals(kernel_log_verbose.getValue());
        }
        return this.nyx;
    }

    public void saveSetting(Map<String, Setting> setting) {
        Iterator<String> ki = setting.keySet().iterator();
        JdbcTemplate t = this.getJdbcTemplate();
        while (ki.hasNext()) {
            String sql;
            String k = ki.next();
            Setting v = setting.get(k);
            if (!"rw".equals(v.getMode())) continue;
            int r = t.update("update nyx_setting set value=? where name=?", new Object[]{v.getValue(), v.getName()}, new int[]{12, 12});
            if (this.verbose) {
                sql = new StringBuffer("update nyx_setting set value='").append(v.getValue()).append("'").append(" where name='").append(v.getName()).append("'").toString();
                NyxException.logger.debug((Object)sql);
            }
            if (r > 0) continue;
            t.update("insert into nyx_setting(name, parent, mode, modify, value, display) values(?, ?, ?, ?, ?)", new Object[]{v.getName(), v.getParent(), v.getMode(), v.getModify(), v.getValue(), v.getDisplay()}, new int[]{12, 12, 12, 12, 12, 12});
            if (!this.verbose) continue;
            sql = new StringBuffer("insert into nyx_setting(name, parent, mode, modify, value, display) values(").append("'").append(v.getName()).append("'").append(",'").append(v.getParent()).append("'").append(",'").append(v.getMode()).append("'").append(",'").append(v.getModify()).append("'").append(",'").append(v.getValue()).append("'").append(",'").append(v.getDisplay()).append("'").toString();
            NyxException.logger.debug((Object)sql);
        }
    }

    protected Tieup loadTieup(long tieupCode) {
        Tieup ret = null;
        try {
            List ext = this.simpleTemplate.query("select * from nyx_tieup_ext where tieup_code=?", this.extMapper, new Object[]{tieupCode});
            ret = (Tieup)this.simpleTemplate.queryForObject("select * from nyx_tieup where tieup_code=?", this.tieupMapper, new Object[]{tieupCode});
            Map<String, Ext> extMap = ret.getExt();
            for (Ext ex : ext) {
                extMap.put(ex.getFieldName(), ex);
            }
        }
        catch (Exception e) {
            ret = new Tieup();
            ret.setTieupCode(tieupCode);
        }
        return ret;
    }

    protected List<Tieup> loadTieup(int offset, int limit, ConditionList conditions) throws SQLException {
        List<Long> ids = this.loadLong("tieup_code", "nyx_tieup", conditions, offset, limit, "tieup_name");
        if (ids.size() <= 0) {
            return new ArrayList<Tieup>();
        }
        ArrayList<Tieup> ret = new ArrayList<Tieup>();
        for (Long id : ids) {
            Tieup t = this.loadTieup(id);
            ret.add(t);
        }
        return ret;
    }

    protected void saveTieup(Tieup tieup) throws SQLException {
        int r = this.namedTemplate.update("update nyx_tieup set tieup_name=:tieupName, tieup_type=:tieupType, tieup_use=:tieupUse, tieup_protocol=:tieupProtocol, tieup_modify=:tieupModify, tieup_server=:tieupServer, tieup_note=:tieupNote where tieup_code=:tieupCode", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)tieup));
        if (r > 0) {
            this.saveExt("nyx_tieup_ext", "tieup_code", tieup.getTieupCode(), tieup.getExt(), tieup);
            this.saveSsoDefault("nyx_tieup", "tieup_code", tieup.getTieupCode(), tieup);
            return;
        }
        long seq = this.nextSequence("nyx_tieup_tieup_code_seq");
        tieup.setTieupCode(seq);
        this.namedTemplate.update("insert into nyx_tieup(tieup_code,tieup_name,tieup_type,tieup_use,tieup_protocol,tieup_modify,tieup_server,tieup_note) values(:tieupCode,:tieupName,:tieupType,:tieupUse,:tieupProtocol,:tieupModify,:tieupServer,:tieupNote)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)tieup));
        this.saveExt("nyx_tieup_ext", "tieup_code", tieup.getTieupCode(), tieup.getExt(), tieup);
        this.saveSsoDefault("nyx_tieup", "tieup_code", tieup.getTieupCode(), tieup);
    }

    protected void deleteTieup(long tieupCode) {
        this.simpleTemplate.update("delete from nyx_tieup_ext where tieup_code=?", new Object[]{tieupCode});
        this.simpleTemplate.update("delete from nyx_tieup where tieup_code=?", new Object[]{tieupCode});
    }

    @Override
    public void clearCashe() {
        this.nyx = null;
    }

    @Override
    public boolean isPostgreSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean isDerby() throws SQLException {
        return true;
    }
}

