/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class SequenceDao
extends JdbcDaoSupport {
    private SimpleJdbcTemplate template;
    private String sequenceName;
    private ParameterizedRowMapper<Long> parameterizedRowMapper;

    public SequenceDao(String sequenceName) {
        if (sequenceName == null) {
            throw new IllegalArgumentException("sequenceName is null.");
        }
        this.sequenceName = sequenceName;
    }

    protected void initTemplateConfig() {
        super.initTemplateConfig();
        this.template = new SimpleJdbcTemplate((JdbcOperations)this.getJdbcTemplate());
        this.parameterizedRowMapper = new ParameterizedRowMapper<Long>(){

            public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                long ret = rs.getLong(1);
                return ret;
            }
        };
    }

    public long nextSequence() throws IllegalAccessException {
        List ret = this.template.query("select nextval(?)", this.parameterizedRowMapper, new Object[]{this.sequenceName});
        if (ret.size() <= 0) {
            throw new IllegalAccessException("next sequence failed.");
        }
        return (Long)ret.get(0);
    }

    public long currSequence() throws IllegalAccessException {
        List ret = this.template.query("select currval(?)", this.parameterizedRowMapper, new Object[]{this.sequenceName});
        if (ret.size() <= 0) {
            throw new IllegalAccessException("current sequence failed.");
        }
        return (Long)ret.get(0);
    }
}

