/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.nyx.common.db.model.AccessContext;
import jp.nyx.common.db.model.AccessUser;
import jp.nyx.common.db.model.ContextLink;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Ext;

public class User
extends DefaultModel
implements Comparable<User> {
    private String userId;
    private String userName;
    private String passwd;
    private String userType;
    private String modificationId;
    private String modificationValue;
    private int unixUid = -1;
    private int unixGid = -1;
    private String unixGname;
    private Map<String, Ext> ext = new TreeMap<String, Ext>();
    private Set<AccessUser> accessUser = new TreeSet<AccessUser>();
    private Set<AccessContext> accessContext = new TreeSet<AccessContext>();
    private Set<ContextLink> contextLink = new TreeSet<ContextLink>();
    private boolean sessionDisable = false;

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.userId == null ? super.hashCode() : this.userId.hashCode();
    }

    @Override
    public int compareTo(User t) {
        String ns = this.getUserName();
        String nt = t == null ? "" : t.getUserName();
        return ns.compareTo(nt);
    }

    public String getPasswd() {
        return txtUtil.nvl(this.passwd);
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public String getUserName() {
        return txtUtil.nvl(this.userName);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Map<String, Ext> getExt() {
        return this.ext;
    }

    public int getUnixUid() {
        return this.unixUid;
    }

    public void setUnixUid(int unixUid) {
        this.unixUid = unixUid;
    }

    public String getUserId() {
        return txtUtil.nvl(this.userId);
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public int getUnixGid() {
        return this.unixGid;
    }

    public void setUnixGid(int unixGid) {
        this.unixGid = unixGid;
    }

    public String getUnixGname() {
        return txtUtil.nvl(this.unixGname);
    }

    public void setUnixGname(String unixGname) {
        this.unixGname = unixGname;
    }

    public Set<AccessContext> getAccessContext() {
        return this.accessContext;
    }

    public Set<AccessUser> getAccessUser() {
        return this.accessUser;
    }

    public Set<ContextLink> getContextLink() {
        return this.contextLink;
    }

    public boolean isSessionDisable() {
        return this.sessionDisable;
    }

    public void setSessionDisable(boolean sessionDisable) {
        this.sessionDisable = sessionDisable;
    }

    public String getUserType() {
        return txtUtil.nvl(this.userType);
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getModificationId() {
        return txtUtil.nvl(this.modificationId);
    }

    public void setModificationId(String modificationId) {
        this.modificationId = modificationId;
    }

    public String getModificationValue() {
        return txtUtil.nvl(this.modificationValue);
    }

    public void setModificationValue(String modificationValue) {
        this.modificationValue = modificationValue;
    }

    public static enum UserType {
        GENERAL("", "\u4e00\u822c\u30a2\u30ab\u30a6\u30f3\u30c8"),
        TICKET("ticket", "\u30c1\u30b1\u30c3\u30c8\u578b(\u4fee\u98feID\u304c\u767a\u884c\u8005)");

        private String value;
        private String text;

        private UserType(String value, String text) {
            this.text = text;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }

        public static UserType getUserType(String value) {
            for (UserType t : UserType.values()) {
                if (!t.value.equals(value)) continue;
                return t;
            }
            return GENERAL;
        }

        public static Map<String, String> getMap() {
            HashMap<String, String> ret = new HashMap<String, String>();
            ret.put(UserType.GENERAL.text, UserType.GENERAL.value);
            ret.put(UserType.TICKET.text, UserType.TICKET.value);
            return ret;
        }
    }
}

