/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.rpc.client;

import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.nyx.NyxException;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.PortalSetting;
import jp.nyx.common.db.model.User;
import jp.nyx.common.util.TextUtility;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcSunHttpTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;

public class NyxXmlClient {
    public static final String NYX_XML_HEADER = "NyxAuthGate";
    private final TextUtility txtUtil = new TextUtility();
    private Pattern pattern = Pattern.compile("([^=]+)=([^,]+),*");
    private int connectionTimeout = 30000;
    private int retryTimeout = 30000;

    private Object xmlrpc(String nyxHeader, String method, Object[] param) throws NyxException {
        try {
            String xmlrpc = this.parseNyxHeader(nyxHeader, "xmlrpc");
            if (this.txtUtil.isEmpty(xmlrpc)) {
                return null;
            }
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(xmlrpc));
            config.setEnabledForExtensions(true);
            config.setConnectionTimeout(this.connectionTimeout);
            config.setReplyTimeout(this.retryTimeout);
            XmlRpcClient client = new XmlRpcClient();
            client.setTransportFactory((XmlRpcTransportFactory)new XmlRpcSunHttpTransportFactory(client));
            client.setConfig((XmlRpcClientConfig)config);
            return client.execute(method, param);
        }
        catch (Exception e) {
            NyxException ne = new NyxException(e.getMessage());
            ne.initCause(e);
            throw ne;
        }
    }

    public String parseNyxHeader(String nyxHeader, String key) {
        Matcher matcher = this.pattern.matcher(nyxHeader);
        while (matcher.find()) {
            String k = matcher.group(1);
            String v = matcher.group(2);
            if (!key.equals(k)) continue;
            return v;
        }
        return null;
    }

    public Map<String, Setting> rpcGetNyx(String nyxHeader) throws NyxException {
        return (Map)this.xmlrpc(nyxHeader, "NyxSetting.getNyx", new Object[0]);
    }

    public PortalSetting rpcGetPortalSetting(String nyxHeader, String key) throws NyxException {
        return (PortalSetting)this.xmlrpc(nyxHeader, "Sso.getPortalSetting", new Object[]{key});
    }

    public User rpcGetUser(String nyxHeader, String selfId, String loadId) throws NyxException {
        return (User)this.xmlrpc(nyxHeader, "Sso.getUser", new Object[]{selfId, loadId});
    }

    public boolean rpcCheckAuth(String nyxHeader, String requestUrl, String requestUri, String queryString) throws NyxException {
        return (Boolean)this.xmlrpc(nyxHeader, "Sso.checkAuth", new Object[]{requestUrl, requestUri, queryString});
    }

    public boolean rpcCheckUser(String nyxHeader, String userId, String password) throws NyxException {
        return (Boolean)this.xmlrpc(nyxHeader, "Sso.checkUser", new Object[]{userId, password});
    }

    public boolean rpcCheckContextUser(String nyxHeader, String userId, String password, String contextCodes) throws NyxException {
        return (Boolean)this.xmlrpc(nyxHeader, "Sso.checkContextUser", new Object[]{userId, password, contextCodes});
    }

    public Context rpcGetContext(String nyxHeader, String selfId, long contextCode) throws NyxException {
        return (Context)this.xmlrpc(nyxHeader, "Sso.getContext", new Object[]{selfId, contextCode});
    }

    public Context rpcGetContext(String nyxHeader, String selfId, long contextCode, boolean bridgeUser) throws NyxException {
        return (Context)this.xmlrpc(nyxHeader, "Sso.getContext", new Object[]{selfId, contextCode, bridgeUser});
    }

    public boolean rpcLogImport(String nyxHeader) throws NyxException {
        return (Boolean)this.xmlrpc(nyxHeader, "Sso.logImport", new Object[0]);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(int retryTimeout) {
        this.retryTimeout = retryTimeout;
    }
}

