/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;
import jp.nyx.common.util.TextUtility;

public class DigestUtility {
    public static String DEFAULT_DIGEST_ALGORITHM = "SHA1";
    private static MessageDigest sha1;
    private static MessageDigest md5;
    private static TextUtility txtUtil;

    public static String sha1(String pass) throws IOException, MessagingException {
        pass = txtUtil.isEmpty(pass) ? "b" : pass;
        byte[] digest = sha1.digest(pass.getBytes("iso-8859-1"));
        return DigestUtility.base64(digest);
    }

    public static String digestString(String pass, String algorithm) throws IOException, MessagingException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        pass = txtUtil.isEmpty(pass) ? "b" : pass;
        byte[] digest = md.digest(pass.getBytes("iso-8859-1"));
        return DigestUtility.base64(digest);
    }

    public static String md5(String pass) throws UnsupportedEncodingException {
        pass = txtUtil.isEmpty(pass) ? "b" : pass;
        byte[] digest = md5.digest(pass.getBytes("iso-8859-1"));
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            s.append(Integer.toString((digest[i] & 0xF0) >> 4, 16));
            s.append(Integer.toString(digest[i] & 0xF, 16));
        }
        return s.toString();
    }

    public static String base64(byte[] b) throws IOException, MessagingException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream encodedStream = MimeUtility.encode((OutputStream)bos, (String)"base64");
        encodedStream.write(b);
        return bos.toString();
    }

    static {
        txtUtil = new TextUtility();
        try {
            sha1 = MessageDigest.getInstance("SHA1");
            md5 = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

