/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util.spec;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Key;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.nyx.NyxException;
import jp.nyx.common.util.spec.PkgClassUtil;
import jp.nyx.common.util.spec.SignedObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSignedObject
extends SignedObject {
    public static final String PROVIDER_NAME = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    protected Document document = null;
    protected String sourceUri;
    private XMLSignatureFactory factory;
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    @Override
    protected void init(Serializable source, PrivateKey signingKey, X509Certificate x509Certificate, Signature sign) throws NyxException {
        try {
            Provider provider = (Provider)PkgClassUtil.newInstance(PROVIDER_NAME);
            this.factory = XMLSignatureFactory.getInstance("DOM", provider);
            String sourceUri = (String)((Object)source);
            if (sourceUri == null || "".equals(sourceUri) || signingKey == null || x509Certificate == null) {
                return;
            }
            this.sourceUri = sourceUri;
            Reference reference = this.factory.newReference(this.sourceUri, this.factory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
            SignedInfo signedInfo = this.factory.newSignedInfo(this.factory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (XMLStructure)null), this.factory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(reference));
            KeyInfoFactory keyInfoFactory = this.factory.getKeyInfoFactory();
            KeyValue keyValue = keyInfoFactory.newKeyValue(x509Certificate.getPublicKey());
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyValue));
            X509Data x509Data = keyInfoFactory.newX509Data(keyInfo.getContent());
            keyInfo.getContent().add(x509Data);
            x509Data.getContent().add(keyInfoFactory.newX509IssuerSerial(x509Certificate.getIssuerX500Principal().getName(), x509Certificate.getSerialNumber()));
            XMLSignature signature = this.factory.newXMLSignature(signedInfo, keyInfo);
            this.documentBuilderFactory.setNamespaceAware(true);
            this.document = this.documentBuilderFactory.newDocumentBuilder().newDocument();
            DOMSignContext signContext = new DOMSignContext(signingKey, (Node)this.document);
            signature.sign(signContext);
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    @Override
    public Serializable getSource() throws NyxException {
        if (this.sourceUri == null) {
            throw new NyxException("\u7f72\u540d\u307e\u305f\u306f\u7f72\u540d\u691c\u8a3c\u304c\u672a\u5b9f\u65bd\u3067\u3059\u3002");
        }
        return this.sourceUri;
    }

    @Override
    public boolean verify() throws NyxException {
        try {
            NodeList nl = this.document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                throw new NyxException("\u30ad\u30fc\u30ef\u30fc\u30c9\u3068\u306a\u308b\u30b3\u30ec\u30af\u30b7\u30e7\u30f3\u306b\u8981\u7d20\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3002:Cannot find Signature element");
            }
            DOMValidateContext valContext = new DOMValidateContext(new KeyValueKeySelector(), nl.item(0));
            XMLSignature signature = this.factory.unmarshalXMLSignature(valContext);
            boolean coreValidity = signature.validate(valContext);
            if (!coreValidity) {
                boolean sv = signature.getSignatureValue().validate(valContext);
                StringBuffer buffer = new StringBuffer();
                buffer.append("Signature failed core validation\n");
                buffer.append("signature validation status: ");
                buffer.append(sv);
                buffer.append('\n');
                Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (i.hasNext()) {
                    boolean refValid = i.next().validate(valContext);
                    buffer.append("ref[");
                    buffer.append(j);
                    buffer.append("] validity status: ");
                    buffer.append(refValid);
                    buffer.append('\n');
                    ++j;
                }
                NyxException.logger.warn((Object)("\u7f72\u540d\u304c\u4e0d\u6b63\u3067\u3059\u3002: msg=" + buffer.toString()));
                return false;
            }
            NyxException.logger.warn((Object)"\u7f72\u540d\u306f\u6b63\u5e38\u3067\u3059\u3002: msg=Signature passed core validation");
            List<Reference> refs = signature.getSignedInfo().getReferences();
            if (refs.size() < 1) {
                throw new NyxException("\u30ad\u30fc\u30ef\u30fc\u30c9\u3068\u306a\u308b\u30b3\u30ec\u30af\u30b7\u30e7\u30f3\u306b\u8981\u7d20\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3002:signature.getSignedInfo().getReferences().size()=" + refs.size());
            }
            this.sourceUri = (String)((Object)refs.get(0));
            return true;
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    @Override
    public void serializ(OutputStream out) throws NyxException {
        try {
            BufferedOutputStream bout = new BufferedOutputStream(out);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.transform(new DOMSource(this.document), new StreamResult(bout));
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    @Override
    public void parse(InputStream in) throws NyxException {
        try {
            BufferedInputStream bin = new BufferedInputStream(in);
            this.document = this.documentBuilderFactory.newDocumentBuilder().parse(bin);
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    @Override
    @Deprecated
    public X509Certificate getX509Certificate() throws NyxException {
        if (this.document == null) {
            throw new NyxException("\u7f72\u540d\u307e\u305f\u306f\u7f72\u540d\u691c\u8a3c\u304c\u672a\u5b9f\u65bd\u3067\u3059\u3002:this.document=" + this.document);
        }
        NodeList nl = this.document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new NyxException("\u30ad\u30fc\u30ef\u30fc\u30c9\u3068\u306a\u308b\u30b3\u30ec\u30af\u30b7\u30e7\u30f3\u306b\u8981\u7d20\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u305b\u3093\u3002:Cannot find Signature element");
        }
        return null;
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private PublicKey pk;

        SimpleKeySelectorResult(PublicKey pk) {
            this.pk = pk;
        }

        @Override
        public Key getKey() {
            return this.pk;
        }
    }

    private static class KeyValueKeySelector
    extends KeySelector {
        private KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (!(xmlStructure instanceof KeyValue)) continue;
                PublicKey pk = null;
                try {
                    pk = ((KeyValue)xmlStructure).getPublicKey();
                }
                catch (KeyException ke) {
                    throw new KeySelectorException(ke);
                }
                if (!KeyValueKeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                return new SimpleKeySelectorResult(pk);
            }
            throw new KeySelectorException("No KeyValue element found!");
        }

        private static boolean algEquals(String algURI, String algName) {
            if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                return true;
            }
            return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

