/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class RDBUtil {
    public static Connection connect() {
        try {
            String string = System.getProperty("jdbc.driver", "org.hsqldb.jdbcDriver");
            Class.forName(string);
            String string2 = System.getProperty("jdbc.url", "jdbc:hsqldb:learning");
            String string3 = System.getProperty("jdbc.userid", "sa");
            String string4 = System.getProperty("jdbc.passwd", "");
            return DriverManager.getConnection(string2, string3, string4);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static String encodeSQL(Object object) {
        String string = object.toString();
        if (string.indexOf(39) == -1) {
            return '\'' + string + '\'';
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        stringBuffer.append('\'');
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\'': {
                    stringBuffer.append('\'');
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                }
            }
            stringBuffer.append(cArray[i]);
        }
        stringBuffer.append('\'');
        return new String(stringBuffer);
    }

    public static boolean isPrimaryKey(Connection connection, String string, String string2) throws SQLException {
        return RDBUtil.isPrimaryKey(connection.getMetaData(), string, string2);
    }

    public static boolean isPrimaryKey(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, string.toUpperCase());
        while (resultSet.next()) {
            if (!string2.equals(resultSet.getString("COLUMN_NAME"))) continue;
            return true;
        }
        return false;
    }

    public static Set getPrimaryKeys(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, string.toUpperCase());
        while (resultSet.next()) {
            hashSet.add(resultSet.getString("COLUMN_NAME"));
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countRows(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery("SELECT count(*) FROM " + string);
            resultSet.next();
            long l = resultSet.getLong(1);
            return l;
        }
        finally {
            statement.close();
        }
    }
}

