/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class ThreadPool {
    private Object lock = new Object();
    private int maxThreads;
    private LinkedList idling = new LinkedList();
    private HashSet running = new HashSet();

    public ThreadPool(int n) {
        this.maxThreads = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable runnable) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            PooledThread pooledThread;
            if (this.idling.size() == 0 && this.running.size() < this.maxThreads) {
                pooledThread = new PooledThread();
            } else {
                while (this.idling.size() == 0) {
                    this.lock.wait();
                }
                pooledThread = (PooledThread)this.idling.removeFirst();
            }
            this.running.add(pooledThread);
            pooledThread.run(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinAll() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.running.size() > 0) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.joinAll();
            Iterator iterator = this.idling.iterator();
            while (iterator.hasNext()) {
                PooledThread pooledThread = (PooledThread)iterator.next();
                pooledThread.terminate();
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnThread(PooledThread pooledThread) {
        Object object = this.lock;
        synchronized (object) {
            this.running.remove(pooledThread);
            this.idling.add(pooledThread);
            this.lock.notifyAll();
        }
    }

    private class PooledThread
    extends Thread {
        private volatile boolean terminated = false;
        private Object lock = new Object();
        private Runnable operation = null;

        private PooledThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                while (!this.terminated) {
                    if (this.operation != null) {
                        Object var3_4;
                        try {
                            this.operation.run();
                            var3_4 = null;
                            this.operation = null;
                        }
                        catch (Throwable throwable) {
                            var3_4 = null;
                            this.operation = null;
                            ThreadPool.this.returnThread(this);
                            throw throwable;
                        }
                        ThreadPool.this.returnThread(this);
                        {
                        }
                    }
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run(Runnable runnable) {
            Object object = this.lock;
            synchronized (object) {
                this.operation = runnable;
                if (!this.isAlive() && !this.terminated) {
                    this.start();
                } else {
                    this.lock.notify();
                }
            }
        }

        void terminate() {
            this.terminated = true;
            try {
                this.interrupt();
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

