/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.support.RequestContextUtils;

public abstract class JstlUtils {
    public static MessageSource getJstlAwareMessageSource(ServletContext servletContext, MessageSource messageSource) {
        String jstlInitParam;
        if (servletContext != null && (jstlInitParam = servletContext.getInitParameter("javax.servlet.jsp.jstl.fmt.localizationContext")) != null) {
            ResourceBundleMessageSource jstlBundleWrapper = new ResourceBundleMessageSource();
            jstlBundleWrapper.setBasename(jstlInitParam);
            jstlBundleWrapper.setParentMessageSource(messageSource);
            return jstlBundleWrapper;
        }
        return messageSource;
    }

    public static void exposeLocalizationContext(HttpServletRequest request, MessageSource messageSource) {
        Locale jstlLocale = RequestContextUtils.getLocale(request);
        Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)jstlLocale);
        if (messageSource != null) {
            SpringLocalizationContext jstlContext = new SpringLocalizationContext(messageSource, request);
            Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.localizationContext", (Object)((Object)jstlContext));
        }
    }

    private static class SpringLocalizationContext
    extends LocalizationContext {
        private final MessageSource messageSource;
        private final HttpServletRequest request;

        public SpringLocalizationContext(MessageSource messageSource, HttpServletRequest request) {
            this.messageSource = messageSource;
            this.request = request;
        }

        public ResourceBundle getResourceBundle() {
            Object lcObject;
            HttpSession session = this.request.getSession(false);
            if (session != null && (lcObject = Config.get((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.localizationContext")) instanceof LocalizationContext) {
                ResourceBundle lcBundle = ((LocalizationContext)lcObject).getResourceBundle();
                return new MessageSourceResourceBundle(this.messageSource, this.getLocale(), lcBundle);
            }
            return new MessageSourceResourceBundle(this.messageSource, this.getLocale());
        }

        public Locale getLocale() {
            Object localeObject;
            HttpSession session = this.request.getSession(false);
            if (session != null && (localeObject = Config.get((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale")) instanceof Locale) {
                return (Locale)localeObject;
            }
            return RequestContextUtils.getLocale(this.request);
        }
    }
}

