/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.xml;

import com.sk_jp.text.EntityRefEncoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DOMUtility {
    static DocumentBuilder builder;

    public static Document parse(String string) throws IOException {
        return DOMUtility.parse(new File(string));
    }

    public static Document parse(File file) throws IOException {
        try {
            return builder.parse(file);
        }
        catch (SAXException sAXException) {
            throw new IOException("XML Parse error : " + sAXException.getMessage() + ":" + sAXException.getException());
        }
    }

    public static Document parse(InputStream inputStream) throws IOException {
        try {
            return builder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            throw new IOException("XML Parse error : " + sAXException.getMessage() + ":" + sAXException.getException());
        }
    }

    public static Document createDocument() {
        return builder.newDocument();
    }

    public static Node copy(Document document, Node node) {
        switch (node.getNodeType()) {
            case 1: {
                Element element = document.createElement(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    element.setAttribute(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i).getNodeValue());
                }
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    element.appendChild(DOMUtility.copy(document, nodeList.item(i)));
                }
                return element;
            }
            case 3: {
                return document.createTextNode(node.getNodeValue());
            }
            case 4: {
                return document.createCDATASection(node.getNodeValue());
            }
            case 8: {
                return document.createComment(node.getNodeValue());
            }
        }
        return document.createTextNode("not supported");
    }

    public static Element createElement(Document document, String string, String[][] stringArray) {
        Element element = document.createElement(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                element.setAttribute(stringArray[i][0], stringArray[i][1]);
            }
        }
        return element;
    }

    public static Element createLinkNode(Document document, String string, String string2) {
        Element element = DOMUtility.createElement(document, "a", new String[][]{{"href", string}});
        element.appendChild(document.createTextNode(string2));
        return element;
    }

    public static Element getRowNode(Document document, String[] stringArray) {
        return DOMUtility.getRowNode(document, stringArray, false);
    }

    public static Element getRowNode(Document document, String[] stringArray, boolean bl) {
        String string = bl ? "th" : "td";
        Element element = document.createElement("tr");
        for (int i = 0; i < stringArray.length; ++i) {
            element.appendChild(document.createElement(string).appendChild(document.createTextNode(stringArray[i])));
        }
        return element;
    }

    public static boolean existAttribute(Node node, String string) {
        if (node == null) {
            return false;
        }
        String string2 = ((Element)node).getAttribute(string);
        return string2 != null && string2.length() > 0;
    }

    public static String getAttribute(Node node, String string) {
        if (node == null) {
            return null;
        }
        String string2 = ((Element)node).getAttribute(string);
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public static Element getParent(Node node, String string) {
        if (node == null) {
            return null;
        }
        while ((node = node.getParentNode()) != null) {
            if (!string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getContentString(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (node2 != null) {
            switch (node2.getNodeType()) {
                case 5: {
                    stringBuffer.append('&').append(node2.getNodeName()).append(';');
                    break;
                }
                case 1: 
                case 8: {
                    break;
                }
                default: {
                    stringBuffer.append(node2.getNodeValue());
                }
            }
            node2 = node2.getNextSibling();
        }
        return new String(stringBuffer);
    }

    public static Element getElement(Node node, String string) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals(string)) continue;
            return (Element)nodeList.item(i);
        }
        return null;
    }

    public static String getValueOfElement(Node node, String string) {
        return DOMUtility.getContentString(DOMUtility.getElement(node, string));
    }

    public static Element[] getElements(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        Element[] elementArray = new Element[nodeList.getLength()];
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1 || string != null && !string.equals(nodeList.item(i).getNodeName())) continue;
            elementArray[n] = (Element)nodeList.item(i);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        Element[] elementArray2 = new Element[n];
        System.arraycopy(elementArray, 0, elementArray2, 0, n);
        return elementArray2;
    }

    public static boolean matchAttribute(Element element, String string, String string2) {
        if (string == null) {
            return true;
        }
        String string3 = DOMUtility.getAttribute(element, string);
        if (string3 == null) {
            return false;
        }
        return string2 == null || string2.equals(string3);
    }

    public static boolean matchAttributes(Element element, String[][] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (DOMUtility.matchAttribute(element, stringArray[i][0], stringArray[i][1])) continue;
            return false;
        }
        return true;
    }

    public static boolean matchTexts(Element element, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                String string = nodeList.item(i).getNodeValue();
                if (!stringArray[j].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static Element searchElement(Node node, String string) {
        return DOMUtility.searchElement(node, string, (String[][])null, null);
    }

    public static Element searchElement(Node node, String string, String[][] stringArray, String[] stringArray2) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            if (nodeList.item(i).getNodeType() == 1 && (string == null || string.equals(nodeList.item(i).getNodeName())) && DOMUtility.matchAttributes(element = (Element)nodeList.item(i), stringArray) && DOMUtility.matchTexts(element, stringArray2)) {
                return element;
            }
            if (!nodeList.item(i).hasChildNodes() || (element = DOMUtility.searchElement(nodeList.item(i), string, stringArray, stringArray2)) == null) continue;
            return element;
        }
        return null;
    }

    public static Element searchElement(Document document, String string, String string2, String string3) {
        return DOMUtility.searchElement(document.getElementsByTagName(string), string2, string3);
    }

    public static Element searchElement(Element element, String string, String string2, String string3) {
        return DOMUtility.searchElement(element.getElementsByTagName(string), string2, string3);
    }

    private static Element searchElement(NodeList nodeList, String string, String string2) {
        if (nodeList.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!DOMUtility.matchAttribute((Element)nodeList.item(i), string, string2)) continue;
            return (Element)nodeList.item(i);
        }
        return null;
    }

    public static Element searchElement(Element element, String string, String string2) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element3 = (Element)nodeList.item(i);
            if (DOMUtility.matchAttribute(element3, string, string2)) {
                return element3;
            }
            if (!element3.hasChildNodes() || (element2 = DOMUtility.searchElement(element3, string, string2)) == null) continue;
            return element2;
        }
        return null;
    }

    public static String getValueOfSearchedElement(Node node, String string) {
        return DOMUtility.getContentString(DOMUtility.searchElement(node, string));
    }

    public static Element getNextSibling(Node node) {
        Node node2;
        for (node2 = node.getNextSibling(); node2 != null && !node.getNodeName().equals(node2.getNodeName()); node2 = node2.getNextSibling()) {
        }
        return (Element)node2;
    }

    public static Element getNextSibling(Element element, Element element2, String string) {
        Node node;
        if (element2 == null) {
            return DOMUtility.getElement(element, string);
        }
        for (node = element2.getNextSibling(); node != null && !string.equals(node.getNodeName()); node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    public static String normalize(String string) {
        return DOMUtility.normalize(string, false);
    }

    public static String normalize(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        try {
            if (bl) {
                EntityRefEncoder.CANONICAL_INSTANCE.translate(new StringReader(string), stringWriter);
            } else {
                EntityRefEncoder.INSTANCE.translate(new StringReader(string), stringWriter);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
        return stringWriter.toString();
    }

    private DOMUtility() {
    }

    static {
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InternalError(parserConfigurationException.getMessage());
        }
    }
}

