/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.xml.map;

import com.sk_jp.util.wrapper.NamedDate;
import com.sk_jp.xml.DOMUtility;
import com.sk_jp.xml.map.AbstractXMLMapper;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DateToXMLMapper
extends AbstractXMLMapper {
    public DateToXMLMapper(NamedDate namedDate) {
        super(namedDate);
    }

    public String toXMLString() {
        return "<object name=\"" + this.getName() + "\" type=\"Date\">" + this.getValue().toString() + "</object>";
    }

    public Element toElement(Document document) {
        Element element = this.createElement(document);
        element.appendChild(document.createTextNode(DateFormat.getDateTimeInstance(2, 2, Locale.JAPANESE).format((Date)this.getValue())));
        return element;
    }

    public void analyze(Element element) {
        this.setName(element.getAttribute("name"));
        String string = DOMUtility.getContentString(element);
        try {
            this.setValue(DateFormat.getDateTimeInstance(2, 2, Locale.JAPANESE).parse(string));
        }
        catch (ParseException parseException) {
            this.setValue(new Date(Long.parseLong(string)));
        }
    }
}

