/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.vote;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthorizationServiceException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.AclService;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.acegisecurity.acls.objectidentity.ObjectIdentityRetrievalStrategyImpl;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.acls.sid.SidRetrievalStrategy;
import org.acegisecurity.acls.sid.SidRetrievalStrategyImpl;
import org.acegisecurity.vote.AbstractAclVoter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class AclEntryVoter
extends AbstractAclVoter {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$vote$AclEntryVoter == null ? (class$org$acegisecurity$vote$AclEntryVoter = AclEntryVoter.class$("org.acegisecurity.vote.AclEntryVoter")) : class$org$acegisecurity$vote$AclEntryVoter));
    private AclService aclService;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();
    private String internalMethod;
    private String processConfigAttribute;
    private Permission[] requirePermission;
    static /* synthetic */ Class class$org$acegisecurity$vote$AclEntryVoter;

    public AclEntryVoter(AclService aclService, String processConfigAttribute, Permission[] requirePermission) {
        Assert.notNull((Object)processConfigAttribute, (String)"A processConfigAttribute is mandatory");
        Assert.notNull((Object)aclService, (String)"An AclService is mandatory");
        if (requirePermission == null || requirePermission.length == 0) {
            throw new IllegalArgumentException("One or more requirePermission entries is mandatory");
        }
        this.aclService = aclService;
        this.processConfigAttribute = processConfigAttribute;
        this.requirePermission = requirePermission;
    }

    public String getInternalMethod() {
        return this.internalMethod;
    }

    public String getProcessConfigAttribute() {
        return this.processConfigAttribute;
    }

    public void setInternalMethod(String internalMethod) {
        this.internalMethod = internalMethod;
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        Assert.notNull((Object)objectIdentityRetrievalStrategy, (String)"ObjectIdentityRetrievalStrategy required");
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        Assert.notNull((Object)sidRetrievalStrategy, (String)"SidRetrievalStrategy required");
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().startsWith(this.getProcessConfigAttribute());
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            Acl acl;
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            Object domainObject = this.getDomainObjectInstance(object);
            if (domainObject == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Voting to abstain - domainObject is null");
                }
                return 0;
            }
            if (this.internalMethod != null && !"".equals(this.internalMethod)) {
                try {
                    Class<?> clazz = domainObject.getClass();
                    Method method = clazz.getMethod(this.internalMethod, new Class[0]);
                    domainObject = method.invoke(domainObject, new Object[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new AuthorizationServiceException("Object of class '" + domainObject.getClass() + "' does not provide the requested internalMethod: " + this.internalMethod);
                }
                catch (IllegalAccessException iae) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"IllegalAccessException", (Throwable)iae);
                        if (iae.getCause() != null) {
                            logger.debug((Object)("Cause: " + iae.getCause().getMessage()), iae.getCause());
                        }
                    }
                    throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.internalMethod + " for object: " + domainObject);
                }
                catch (InvocationTargetException ite) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"InvocationTargetException", (Throwable)ite);
                        if (ite.getCause() != null) {
                            logger.debug((Object)("Cause: " + ite.getCause().getMessage()), ite.getCause());
                        }
                    }
                    throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.internalMethod + " for object: " + domainObject);
                }
            }
            ObjectIdentity objectIdentity = this.objectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
            Sid[] sids = this.sidRetrievalStrategy.getSids(authentication);
            try {
                acl = this.aclService.readAclById(objectIdentity, sids);
            }
            catch (NotFoundException nfe) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Voting to deny access - no ACLs apply for this principal");
                }
                return -1;
            }
            try {
                if (acl.isGranted(this.requirePermission, sids, false)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Voting to grant access");
                    }
                    return 1;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Voting to deny access - ACLs returned, but insufficient permissions for this principal");
                }
                return -1;
            }
            catch (NotFoundException nfe) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Voting to deny access - no ACLs apply for this principal");
                }
                return -1;
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

