/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.jce.interfaces.ElGamalPublicKey;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.jce.spec.ElGamalPublicKeySpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.util.Arrays;

public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private static final int[] MASTER_KEY_CERTIFICATION_TYPES = new int[]{19, 18, 17, 16};
    PublicKeyPacket publicPk;
    TrustPacket trustPk;
    List keySigs = new ArrayList();
    List ids = new ArrayList();
    List idTrusts = new ArrayList();
    List idSigs = new ArrayList();
    List subSigs = null;
    private long keyID;
    private byte[] fingerprint;
    private int keyStrength;

    private void init() throws IOException {
        BCPGKey bCPGKey = this.publicPk.getKey();
        if (this.publicPk.getVersion() <= 3) {
            RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
            this.keyID = rSAPublicBCPGKey.getModulus().longValue();
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray = new MPInteger(rSAPublicBCPGKey.getModulus()).getEncoded();
                messageDigest.update(byArray, 2, byArray.length - 2);
                byArray = new MPInteger(rSAPublicBCPGKey.getPublicExponent()).getEncoded();
                messageDigest.update(byArray, 2, byArray.length - 2);
                this.fingerprint = messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException("can't find MD5");
            }
            this.keyStrength = rSAPublicBCPGKey.getModulus().bitLength();
        } else {
            byte[] byArray = this.publicPk.getEncodedContents();
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                messageDigest.update((byte)-103);
                messageDigest.update((byte)(byArray.length >> 8));
                messageDigest.update((byte)byArray.length);
                messageDigest.update(byArray);
                this.fingerprint = messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException("can't find SHA1");
            }
            this.keyID = (long)(this.fingerprint[this.fingerprint.length - 8] & 0xFF) << 56 | (long)(this.fingerprint[this.fingerprint.length - 7] & 0xFF) << 48 | (long)(this.fingerprint[this.fingerprint.length - 6] & 0xFF) << 40 | (long)(this.fingerprint[this.fingerprint.length - 5] & 0xFF) << 32 | (long)(this.fingerprint[this.fingerprint.length - 4] & 0xFF) << 24 | (long)(this.fingerprint[this.fingerprint.length - 3] & 0xFF) << 16 | (long)(this.fingerprint[this.fingerprint.length - 2] & 0xFF) << 8 | (long)(this.fingerprint[this.fingerprint.length - 1] & 0xFF);
            if (bCPGKey instanceof RSAPublicBCPGKey) {
                this.keyStrength = ((RSAPublicBCPGKey)bCPGKey).getModulus().bitLength();
            } else if (bCPGKey instanceof DSAPublicBCPGKey) {
                this.keyStrength = ((DSAPublicBCPGKey)bCPGKey).getP().bitLength();
            } else if (bCPGKey instanceof ElGamalPublicBCPGKey) {
                this.keyStrength = ((ElGamalPublicBCPGKey)bCPGKey).getP().bitLength();
            }
        }
    }

    public PGPPublicKey(int n, PublicKey publicKey, Date date, String string) throws PGPException, NoSuchProviderException {
        BCPGObject bCPGObject;
        PublicKey publicKey2;
        if (publicKey instanceof RSAPublicKey) {
            publicKey2 = (RSAPublicKey)publicKey;
            bCPGObject = new RSAPublicBCPGKey(publicKey2.getModulus(), publicKey2.getPublicExponent());
        } else if (publicKey instanceof DSAPublicKey) {
            publicKey2 = (DSAPublicKey)publicKey;
            DSAParams dSAParams = publicKey2.getParams();
            bCPGObject = new DSAPublicBCPGKey(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG(), publicKey2.getY());
        } else if (publicKey instanceof ElGamalPublicKey) {
            publicKey2 = (ElGamalPublicKey)publicKey;
            ElGamalParameterSpec elGamalParameterSpec = publicKey2.getParameters();
            bCPGObject = new ElGamalPublicBCPGKey(elGamalParameterSpec.getP(), elGamalParameterSpec.getG(), publicKey2.getY());
        } else {
            throw new PGPException("unknown key class");
        }
        this.publicPk = new PublicKeyPacket(n, date, (BCPGKey)((Object)bCPGObject));
        this.ids = new ArrayList();
        this.idSigs = new ArrayList();
        try {
            this.init();
        }
        catch (IOException iOException) {
            throw new PGPException("exception calculating keyID", iOException);
        }
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, TrustPacket trustPacket, List list) throws IOException {
        this.publicPk = publicKeyPacket;
        this.trustPk = trustPacket;
        this.subSigs = list;
        this.init();
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey, TrustPacket trustPacket, List list) {
        this.publicPk = pGPPublicKey.publicPk;
        this.trustPk = trustPacket;
        this.subSigs = list;
        this.fingerprint = pGPPublicKey.fingerprint;
        this.keyID = pGPPublicKey.keyID;
        this.keyStrength = pGPPublicKey.keyStrength;
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey) {
        int n;
        this.publicPk = pGPPublicKey.publicPk;
        this.keySigs = new ArrayList(pGPPublicKey.keySigs);
        this.ids = new ArrayList(pGPPublicKey.ids);
        this.idTrusts = new ArrayList(pGPPublicKey.idTrusts);
        this.idSigs = new ArrayList(pGPPublicKey.idSigs.size());
        for (n = 0; n != pGPPublicKey.idSigs.size(); ++n) {
            this.idSigs.add(new ArrayList((ArrayList)pGPPublicKey.idSigs.get(n)));
        }
        if (pGPPublicKey.subSigs != null) {
            this.subSigs = new ArrayList(pGPPublicKey.subSigs.size());
            for (n = 0; n != pGPPublicKey.subSigs.size(); ++n) {
                this.subSigs.add(pGPPublicKey.subSigs.get(n));
            }
        }
        this.fingerprint = pGPPublicKey.fingerprint;
        this.keyID = pGPPublicKey.keyID;
        this.keyStrength = pGPPublicKey.keyStrength;
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, TrustPacket trustPacket, List list, List list2, List list3, List list4) throws IOException {
        this.publicPk = publicKeyPacket;
        this.trustPk = trustPacket;
        this.keySigs = list;
        this.ids = list2;
        this.idTrusts = list3;
        this.idSigs = list4;
        this.init();
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, List list, List list2) throws IOException {
        this.publicPk = publicKeyPacket;
        this.ids = list;
        this.idSigs = list2;
        this.init();
    }

    public int getVersion() {
        return this.publicPk.getVersion();
    }

    public Date getCreationTime() {
        return this.publicPk.getTime();
    }

    public int getValidDays() {
        if (this.publicPk.getVersion() > 3) {
            return (int)(this.getValidSeconds() / 86400L);
        }
        return this.publicPk.getValidDays();
    }

    public byte[] getTrustData() {
        if (this.trustPk == null) {
            return null;
        }
        return Arrays.clone((byte[])this.trustPk.getLevelAndTrustAmount());
    }

    public long getValidSeconds() {
        if (this.publicPk.getVersion() > 3) {
            if (this.isMasterKey()) {
                for (int i = 0; i != MASTER_KEY_CERTIFICATION_TYPES.length; ++i) {
                    long l = this.getExpirationTimeFromSig(true, MASTER_KEY_CERTIFICATION_TYPES[i]);
                    if (l < 0L) continue;
                    return l;
                }
            } else {
                long l = this.getExpirationTimeFromSig(false, 24);
                if (l >= 0L) {
                    return l;
                }
            }
            return 0L;
        }
        return (long)this.publicPk.getValidDays() * 24L * 60L * 60L;
    }

    private long getExpirationTimeFromSig(boolean bl, int n) {
        Iterator iterator = this.getSignaturesOfType(n);
        if (iterator.hasNext()) {
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (!bl || pGPSignature.getKeyID() == this.getKeyID()) {
                PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets();
                if (pGPSignatureSubpacketVector != null) {
                    return pGPSignatureSubpacketVector.getKeyExpirationTime();
                }
                return 0L;
            }
        }
        return -1L;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerprint() {
        byte[] byArray = new byte[this.fingerprint.length];
        System.arraycopy(this.fingerprint, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean isEncryptionKey() {
        int n = this.publicPk.getAlgorithm();
        return n == 1 || n == 2 || n == 16 || n == 20;
    }

    public boolean isMasterKey() {
        return this.subSigs == null;
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public int getBitStrength() {
        return this.keyStrength;
    }

    public PublicKey getKey(String string) throws PGPException, NoSuchProviderException {
        try {
            switch (this.publicPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)this.publicPk.getKey();
                    RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA", string);
                    return keyFactory.generatePublic(rSAPublicKeySpec);
                }
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)this.publicPk.getKey();
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicBCPGKey.getY(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    KeyFactory keyFactory = KeyFactory.getInstance("DSA", string);
                    return keyFactory.generatePublic(dSAPublicKeySpec);
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)this.publicPk.getKey();
                    ElGamalPublicKeySpec elGamalPublicKeySpec = new ElGamalPublicKeySpec(elGamalPublicBCPGKey.getY(), new ElGamalParameterSpec(elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG()));
                    KeyFactory keyFactory = KeyFactory.getInstance("ElGamal", string);
                    return keyFactory.generatePublic((KeySpec)elGamalPublicKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    public Iterator getUserIDs() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof String)) continue;
            arrayList.add(this.ids.get(i));
        }
        return arrayList.iterator();
    }

    public Iterator getUserAttributes() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof PGPUserAttributeSubpacketVector)) continue;
            arrayList.add(this.ids.get(i));
        }
        return arrayList.iterator();
    }

    public Iterator getSignaturesForID(String string) {
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!string.equals(this.ids.get(i))) continue;
            return ((ArrayList)this.idSigs.get(i)).iterator();
        }
        return null;
    }

    public Iterator getSignaturesForUserAttribute(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector) {
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!pGPUserAttributeSubpacketVector.equals(this.ids.get(i))) continue;
            return ((ArrayList)this.idSigs.get(i)).iterator();
        }
        return null;
    }

    public Iterator getSignaturesOfType(int n) {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        Iterator iterator = this.getSignatures();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (pGPSignature.getSignatureType() != n) continue;
            arrayList.add(pGPSignature);
        }
        return arrayList.iterator();
    }

    public Iterator getSignatures() {
        if (this.subSigs == null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.keySigs);
            for (int i = 0; i != this.idSigs.size(); ++i) {
                arrayList.addAll((Collection)this.idSigs.get(i));
            }
            return arrayList.iterator();
        }
        return this.subSigs.iterator();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.publicPk);
        if (this.trustPk != null) {
            bCPGOutputStream.writePacket(this.trustPk);
        }
        if (this.subSigs == null) {
            int n;
            for (n = 0; n != this.keySigs.size(); ++n) {
                ((PGPSignature)this.keySigs.get(n)).encode(bCPGOutputStream);
            }
            for (n = 0; n != this.ids.size(); ++n) {
                Object object;
                if (this.ids.get(n) instanceof String) {
                    object = (String)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserIDPacket((String)object));
                } else {
                    object = (PGPUserAttributeSubpacketVector)this.ids.get(n);
                    bCPGOutputStream.writePacket(new UserAttributePacket(((PGPUserAttributeSubpacketVector)object).toSubpacketArray()));
                }
                if (this.idTrusts.get(n) != null) {
                    bCPGOutputStream.writePacket((ContainedPacket)this.idTrusts.get(n));
                }
                object = (List)this.idSigs.get(n);
                for (int i = 0; i != object.size(); ++i) {
                    ((PGPSignature)object.get(i)).encode(bCPGOutputStream);
                }
            }
        } else {
            for (int i = 0; i != this.subSigs.size(); ++i) {
                ((PGPSignature)this.subSigs.get(i)).encode(bCPGOutputStream);
            }
        }
    }

    public boolean isRevoked() {
        int n = 0;
        boolean bl = false;
        if (this.isMasterKey()) {
            while (!bl && n < this.keySigs.size()) {
                if (((PGPSignature)this.keySigs.get(n++)).getSignatureType() != 32) continue;
                bl = true;
            }
        } else {
            while (!bl && n < this.subSigs.size()) {
                if (((PGPSignature)this.subSigs.get(n++)).getSignatureType() != 40) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, String string, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        List<PGPSignature> list = null;
        for (int i = 0; i != pGPPublicKey2.ids.size(); ++i) {
            if (!string.equals(pGPPublicKey2.ids.get(i))) continue;
            list = (List)pGPPublicKey2.idSigs.get(i);
        }
        if (list != null) {
            list.add(pGPSignature);
        } else {
            list = new ArrayList<PGPSignature>();
            list.add(pGPSignature);
            pGPPublicKey2.ids.add(string);
            pGPPublicKey2.idTrusts.add(null);
            pGPPublicKey2.idSigs.add(list);
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, String string) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        boolean bl = false;
        for (int i = 0; i < pGPPublicKey2.ids.size(); ++i) {
            if (!string.equals(pGPPublicKey2.ids.get(i))) continue;
            bl = true;
            pGPPublicKey2.ids.remove(i);
            pGPPublicKey2.idTrusts.remove(i);
            pGPPublicKey2.idSigs.remove(i);
        }
        if (!bl) {
            return null;
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, String string, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        boolean bl = false;
        for (int i = 0; i < pGPPublicKey2.ids.size(); ++i) {
            if (!string.equals(pGPPublicKey2.ids.get(i))) continue;
            bl = ((List)pGPPublicKey2.idSigs.get(i)).remove(pGPSignature);
        }
        if (!bl) {
            return null;
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, PGPSignature pGPSignature) {
        if (pGPPublicKey.isMasterKey()) {
            if (pGPSignature.getSignatureType() == 40) {
                throw new IllegalArgumentException("signature type incorrect for master key revocation.");
            }
        } else if (pGPSignature.getSignatureType() == 32) {
            throw new IllegalArgumentException("signature type incorrect for sub-key revocation.");
        }
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        if (pGPPublicKey2.subSigs != null) {
            pGPPublicKey2.subSigs.add(pGPSignature);
        } else {
            pGPPublicKey2.keySigs.add(pGPSignature);
        }
        return pGPPublicKey2;
    }
}

