/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal;

import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DigesterOutputStream
extends ByteArrayOutputStream {
    private static final byte[] none = "error".getBytes();
    private final MessageDigest md;
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal");

    public DigesterOutputStream(MessageDigest md) {
        this.md = md;
    }

    public byte[] toByteArray() {
        return none;
    }

    public void write(byte[] input) {
        this.md.update(input);
    }

    public void write(int input) {
        this.md.update((byte)input);
    }

    public void write(byte[] input, int offset, int len) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Pre-digested input:");
            StringBuffer sb = new StringBuffer(len);
            for (int i = offset; i < offset + len; ++i) {
                sb.append((char)input[i]);
            }
            log.log(Level.FINER, sb.toString());
        }
        this.md.update(input, offset, len);
    }

    public byte[] getDigestValue() {
        return this.md.digest();
    }
}

