/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineInputStream
extends FilterInputStream {
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private int bufferSize;
    private String encoding;
    private byte[] readBuffer;
    private int readBufferOffset;
    private int readBufferLength;
    private static final int INC = 1024;

    public LineInputStream(InputStream inputStream) {
        this(inputStream, "ISO-8859-1", 2048);
    }

    public LineInputStream(InputStream inputStream, String string) {
        this(inputStream, string, 2048);
    }

    public LineInputStream(InputStream inputStream, String string, int n) {
        super(inputStream);
        this.encoding = string;
        if (n <= 0) {
            throw new IllegalArgumentException("bufferSize: " + n);
        }
        this.bufferSize = n;
        this.readBuffer = new byte[n];
        this.readBufferOffset = 0;
        this.readBufferLength = 0;
    }

    public int read() throws IOException {
        int n = this.peek();
        ++this.readBufferOffset;
        --this.readBufferLength;
        return n;
    }

    private int peek() throws IOException {
        if (this.readBufferLength == 0 && this.chargeReadBuffer(true) == -1) {
            return -1;
        }
        return this.readBuffer[this.readBufferOffset] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            if (this.readBufferLength > 0) {
                n4 = Math.min(this.readBufferLength, n2);
                this.readBuffer(byArray, n, n4);
            } else {
                n4 = this.in.read(byArray, n, n2);
                if (n4 == -1) {
                    if (n3 != 0) break;
                    n3 = -1;
                    break;
                }
            }
            n += n4;
            n2 -= n4;
            n3 += n4;
        }
        return n3;
    }

    public String readLine() throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        int n2 = 0;
        while ((n = this.readLineAsBytesWithNewLine(byArray, n2, 1024)) >= 1024) {
            if (byArray[n2 + 1024 - 1] == 13 && this.peek() == 10) {
                this.read();
                break;
            }
            if (byArray[n2 + 1024 - 1] == 13 && byArray[n2 + 1024 - 1] == 10) continue;
            byte[] byArray2 = new byte[(n2 += 1024) + 1024];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        if (n == -1) {
            if (n2 == 0) {
                return null;
            }
            n = n2 * 1024;
        } else if ((n = n2 * 1024 + n) > 0 && byArray[n - 1] == 10) {
            --n;
        }
        if (n > 0 && byArray[n - 1] == 13) {
            --n;
        }
        return new String(byArray, 0, n2 + n, this.encoding);
    }

    public int readLineAsBytesWithNewLine(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block3: {
            n3 = 0;
            this.chargeReadBuffer(false);
            do {
                int n4;
                int n5;
                if ((n5 = (n4 = this.searchNewLineIndex(this.readBuffer, this.readBufferOffset, this.readBufferLength)) == -1 ? Math.min(n2, this.readBufferLength) : Math.min(n2, n4 - this.readBufferOffset)) > 0) {
                    this.readBuffer(byArray, n, n5);
                    n += n5;
                    n3 += n5;
                    if ((n2 -= n5) == 0) break block3;
                }
                if (n4 >= 0) break block3;
            } while (this.chargeReadBuffer(true) != -1);
            if (n3 > 0) {
                return n3;
            }
            return -1;
        }
        return n3;
    }

    private int searchNewLineIndex(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (byArray[i] == 10) {
                return i + 1;
            }
            if (byArray[i] != 13) continue;
            if (++i < n3 && byArray[i] == 10) {
                return i + 1;
            }
            return i;
        }
        return -1;
    }

    private int chargeReadBuffer(boolean bl) throws IOException {
        int n = this.readBufferOffset + this.readBufferLength;
        if (n == this.bufferSize) {
            return 0;
        }
        int n2 = this.bufferSize - n;
        if (!bl && (n2 = Math.min(this.in.available(), n2)) == 0) {
            return 0;
        }
        int n3 = this.in.read(this.readBuffer, n, n2);
        if (n3 != -1) {
            this.readBufferLength += n3;
        }
        return n3;
    }

    private void readBuffer(byte[] byArray, int n, int n2) {
        if (this.readBufferLength <= 0 || n2 > this.readBufferLength) {
            throw new InternalError(n2 + " requests " + this.readBufferLength + " in buffer:");
        }
        System.arraycopy(this.readBuffer, this.readBufferOffset, byArray, n, n2);
        this.readBufferOffset += n2;
        this.readBufferLength -= n2;
        if (this.readBufferOffset == this.bufferSize) {
            this.readBufferOffset = 0;
            this.readBufferLength = 0;
        }
    }

    public long skip(long l) throws IOException {
        long l2;
        for (l2 = 0L; l2 < l && this.read() != -1; ++l2) {
        }
        return l2;
    }

    public int available() throws IOException {
        return this.readBufferLength + this.in.available();
    }

    public void mark(int n) {
        throw new UnsupportedOperationException("mark/reset not supported");
    }

    public void reset() {
        throw new UnsupportedOperationException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }
}

