/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.xml.extractor;

import com.sk_jp.Log;
import com.sk_jp.xml.DOMUtility;
import com.sk_jp.xml.extractor.Extractor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.w3c.dom.Node;

public class DateRangeExtractor
implements Extractor {
    private Date min_;
    private Date max_;

    public DateRangeExtractor(Date date, Date date2) {
        this.min_ = date;
        this.max_ = date2;
    }

    public boolean canExtract(Node node) {
        Date date;
        String string = DOMUtility.getContentString(node);
        int n = string.indexOf(45);
        Date date2 = null;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.JAPANESE);
        if (n > 1) {
            try {
                date = dateFormat.parse(string.substring(0, n));
                date2 = dateFormat.parse(string.substring(n + 1));
            }
            catch (ParseException parseException) {
                Log.log(parseException);
                return false;
            }
        }
        try {
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            Log.log(parseException);
            return false;
        }
        if (this.max_ != null && this.max_.before(date)) {
            return false;
        }
        return this.min_ == null || !(date2 != null ? this.min_.after(date2) : this.min_.after(date));
    }

    public String toString() {
        return "[DateRange = " + this.min_ + "-" + this.max_ + "]";
    }
}

