/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.crypto.spec.DHParameterSpec;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;
import org.openid4java.OpenIDException;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.association.AssociationSessionType;
import org.openid4java.association.DiffieHellmanSession;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AssociationError;
import org.openid4java.message.AssociationRequest;
import org.openid4java.message.AssociationResponse;
import org.openid4java.message.AuthFailure;
import org.openid4java.message.AuthImmediateFailure;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;
import org.openid4java.message.VerifyRequest;
import org.openid4java.message.VerifyResponse;
import org.openid4java.server.IncrementalNonceGenerator;
import org.openid4java.server.NonceGenerator;
import org.openid4java.server.RealmVerifier;
import org.openid4java.util.HttpClientFactory;

public class ConsumerManager {
    private static Logger _log = Logger.getLogger((Class)ConsumerManager.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private Discovery _discovery = new Discovery();
    private ConsumerAssociationStore _associations = new InMemoryConsumerAssociationStore();
    private NonceGenerator _consumerNonceGenerator = new IncrementalNonceGenerator();
    private Association _privateAssociation;
    private NonceVerifier _nonceVerifier = new InMemoryNonceVerifier(60);
    private HttpClient _httpClient;
    private int _maxAssocAttempts = 4;
    private boolean _allowStateless = true;
    private AssociationSessionType _minAssocSessEnc = AssociationSessionType.NO_ENCRYPTION_SHA1MAC;
    private AssociationSessionType _prefAssocSessEnc;
    private boolean _allowNoEncHttpSess = false;
    private DHParameterSpec _dhParams = DiffieHellmanSession.getDefaultParameter();
    private int _failedAssocExpire = 300;
    private boolean _immediateAuth = false;
    private RealmVerifier _realmVerifier;
    private int _connectTimeout = 10000;
    private int _socketTimeout = 10000;
    private int _maxRedirects = 0;

    public ConsumerManager() throws ConsumerException {
        this._httpClient = HttpClientFactory.getInstance(this._maxRedirects, Boolean.FALSE, this._socketTimeout, this._connectTimeout, "ignoreCookies");
        this._realmVerifier = new RealmVerifier();
        this._prefAssocSessEnc = Association.isHmacSha256Supported() ? AssociationSessionType.DH_SHA256 : AssociationSessionType.DH_SHA1;
        try {
            this._privateAssociation = Association.generate(this.getPrefAssocSessEnc().getAssociationType(), "", 0);
        }
        catch (AssociationException e) {
            throw new ConsumerException("Cannot initialize private association, needed for consumer nonces.");
        }
    }

    public Discovery getDiscovery() {
        return this._discovery;
    }

    public void setDiscovery(Discovery discovery) {
        this._discovery = discovery;
    }

    public ConsumerAssociationStore getAssociations() {
        return this._associations;
    }

    public void setAssociations(ConsumerAssociationStore associations) {
        this._associations = associations;
    }

    public NonceVerifier getNonceVerifier() {
        return this._nonceVerifier;
    }

    public void setNonceVerifier(NonceVerifier nonceVerifier) {
        this._nonceVerifier = nonceVerifier;
    }

    public void setDHParams(DHParameterSpec dhParams) {
        this._dhParams = dhParams;
    }

    public DHParameterSpec getDHParams() {
        return this._dhParams;
    }

    public void setMaxAssocAttempts(int maxAssocAttempts) throws ConsumerException {
        if (maxAssocAttempts <= 0 && !this._allowStateless) {
            throw new IllegalArgumentException("Associations and stateless mode cannot be both disabled at the same time.");
        }
        this._maxAssocAttempts = maxAssocAttempts;
        if (this._maxAssocAttempts == 0) {
            _log.info((Object)"Associations disabled.");
        }
    }

    public int getMaxAssocAttempts() {
        return this._maxAssocAttempts;
    }

    public void allowStateless(boolean useStateless) {
        if (!this._allowStateless && this._maxAssocAttempts <= 0) {
            throw new IllegalArgumentException("Associations and stateless mode cannot be both disabled at the same time.");
        }
        this._allowStateless = useStateless;
    }

    public boolean statelessAllowed() {
        return this._allowStateless;
    }

    public void setMinAssocSessEnc(AssociationSessionType minAssocSessEnc) {
        this._minAssocSessEnc = minAssocSessEnc;
    }

    public AssociationSessionType getMinAssocSessEnc() {
        return this._minAssocSessEnc;
    }

    public void setPrefAssocSessEnc(AssociationSessionType prefAssocSessEnc) {
        this._prefAssocSessEnc = prefAssocSessEnc;
    }

    public AssociationSessionType getPrefAssocSessEnc() {
        return this._prefAssocSessEnc;
    }

    public void setAllowNoEncHttp(boolean allowNoEncHttp) {
        this._allowNoEncHttpSess = allowNoEncHttp;
    }

    public boolean getAllowNoEncHttp() {
        return this._allowNoEncHttpSess;
    }

    public void setFailedAssocExpire(int _failedAssocExpire) {
        this._failedAssocExpire = _failedAssocExpire;
    }

    public int getFailedAssocExpire() {
        return this._failedAssocExpire;
    }

    public void setImmediateAuth(boolean _immediateAuth) {
        this._immediateAuth = _immediateAuth;
    }

    public boolean isImmediateAuth() {
        return this._immediateAuth;
    }

    public RealmVerifier getRealmVerifier() {
        return this._realmVerifier;
    }

    public void setRealmVerifier(RealmVerifier realmVerifier) {
        this._realmVerifier = realmVerifier;
    }

    public long getMaxNonceAge() {
        return this._nonceVerifier.getMaxAge();
    }

    public List discover(String identifier) throws DiscoveryException {
        return this._discovery.discover(identifier);
    }

    public void setPrivateAssociation(Association assoc) throws ConsumerException {
        if (assoc == null) {
            throw new ConsumerException("Cannot set null private association, needed for consumer nonces.");
        }
        this._privateAssociation = assoc;
    }

    public Association getPrivateAssociation() {
        return this._privateAssociation;
    }

    public void setConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
        this._httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this._connectTimeout);
    }

    public void setSocketTimeout(int socketTimeout) {
        this._socketTimeout = socketTimeout;
        this._httpClient.getParams().setSoTimeout(this._socketTimeout);
    }

    public void setMaxRedirects(int maxRedirects) {
        this._maxRedirects = maxRedirects;
        this._httpClient.getParams().setParameter("http.protocol.max-redirects", (Object)new Integer(this._maxRedirects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int call(String url, Message request, ParameterList response) throws MessageException {
        int responseCode = -1;
        PostMethod post = new PostMethod(url);
        try {
            post.setRequestEntity((RequestEntity)new StringRequestEntity(request.wwwFormEncoding(), "application/x-www-form-urlencoded", "UTF-8"));
            if (DEBUG) {
                _log.debug((Object)("Performing HTTP POST on " + url));
            }
            responseCode = this._httpClient.executeMethod((HttpMethod)post);
            String postResponse = post.getResponseBodyAsString();
            response.copyOf(ParameterList.createFromKeyValueForm(postResponse));
            if (DEBUG) {
                _log.debug((Object)("Retrived response:\n" + postResponse));
            }
        }
        catch (IOException e) {
            _log.error((Object)("Error talking to " + url + " response code: " + responseCode), (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
        return responseCode;
    }

    public DiscoveryInformation associate(List discoveries) {
        DiscoveryInformation discovered;
        Iterator itr = discoveries.iterator();
        for (int attemptsLeft = this._maxAssocAttempts; itr.hasNext() && attemptsLeft > 0; attemptsLeft -= this.associate(discovered, attemptsLeft)) {
            discovered = (DiscoveryInformation)itr.next();
            Association assoc = this._associations.load(discovered.getIdpEndpoint().toString());
            if (assoc == null || " ".equals(assoc.getHandle())) continue;
            return discovered;
        }
        if (discoveries.size() > 0) {
            DiscoveryInformation d0 = (DiscoveryInformation)discoveries.get(0);
            _log.warn((Object)("Association failed; using first entry: " + d0.getIdpEndpoint()));
            return d0;
        }
        _log.error((Object)"Association attempt, but no discovey endpoints provided.");
        return null;
    }

    private int associate(DiscoveryInformation discovered, int maxAttempts) {
        if (this._maxAssocAttempts == 0) {
            return 0;
        }
        URL idpUrl = discovered.getIdpEndpoint();
        String idpEndpoint = idpUrl.toString();
        _log.info((Object)("Trying to associate with " + idpEndpoint + " attempts left: " + maxAttempts));
        Association a = this._associations.load(idpEndpoint);
        if (a != null && a.getHandle() != null) {
            _log.info((Object)"Found an existing association.");
            return 0;
        }
        String handle = " ";
        LinkedHashMap requests = new LinkedHashMap();
        if (discovered.isVersion2()) {
            requests.put(AssociationSessionType.NO_ENCRYPTION_SHA1MAC, null);
            requests.put(AssociationSessionType.NO_ENCRYPTION_SHA256MAC, null);
            requests.put(AssociationSessionType.DH_SHA1, null);
            requests.put(AssociationSessionType.DH_SHA256, null);
        } else {
            requests.put(AssociationSessionType.NO_ENCRYPTION_COMPAT_SHA1MAC, null);
            requests.put(AssociationSessionType.DH_COMPAT_SHA1, null);
        }
        if (this._prefAssocSessEnc.isVersion2() == discovered.isVersion2()) {
            requests.put(this._prefAssocSessEnc, null);
        }
        Stack<AssociationRequest> reqStack = new Stack<AssociationRequest>();
        Iterator iter = requests.keySet().iterator();
        while (iter.hasNext()) {
            AssociationSessionType type = (AssociationSessionType)iter.next();
            AssociationRequest newReq = this.createAssociationRequest(type, idpUrl);
            if (newReq == null) continue;
            reqStack.push(newReq);
        }
        int attemptsLeft = maxAttempts;
        LinkedHashMap alreadyTried = new LinkedHashMap();
        while (attemptsLeft > 0 && !reqStack.empty()) {
            try {
                AssociationRequest newReq;
                --attemptsLeft;
                AssociationRequest assocReq = (AssociationRequest)reqStack.pop();
                if (DEBUG) {
                    _log.debug((Object)("Trying association type: " + assocReq.getType()));
                }
                if (alreadyTried.keySet().contains(assocReq.getType())) {
                    if (!DEBUG) continue;
                    _log.debug((Object)"Already tried.");
                    continue;
                }
                alreadyTried.put(assocReq.getType(), null);
                ParameterList respParams = new ParameterList();
                int status = this.call(idpEndpoint, assocReq, respParams);
                if (status == 200) {
                    AssociationResponse assocResp = AssociationResponse.createAssociationResponse(respParams);
                    Association assoc = assocResp.getAssociation(assocReq.getDHSess());
                    handle = assoc.getHandle();
                    AssociationSessionType respType = assocResp.getType();
                    if (respType.equals(assocReq.getType()) || !discovered.isVersion2() && respType.getHAlgorithm() == null && this.createAssociationRequest(respType, idpUrl) != null) {
                        this._associations.save(idpEndpoint, assoc);
                        _log.info((Object)("Associated with " + discovered.getIdpEndpoint() + " handle: " + assoc.getHandle()));
                        break;
                    }
                    _log.info((Object)"Discarding, not matching consumer criteria");
                    continue;
                }
                if (status != 400) continue;
                _log.info((Object)"Association attempt failed.");
                AssociationError assocErr = AssociationError.createAssociationError(respParams);
                AssociationSessionType idpType = AssociationSessionType.create(assocErr.getSessionType(), assocErr.getAssocType());
                if (alreadyTried.keySet().contains(idpType) || (newReq = this.createAssociationRequest(idpType, idpUrl)) == null) continue;
                if (DEBUG) {
                    _log.debug((Object)("Retrieved association type from the association error: " + newReq.getType()));
                }
                reqStack.push(newReq);
            }
            catch (OpenIDException e) {
                _log.error((Object)"Error encountered during association attempt.", (Throwable)e);
            }
        }
        if (" ".equals(handle) && this._failedAssocExpire > 0) {
            this._associations.save(idpEndpoint, Association.getFailedAssociation(this._failedAssocExpire));
        }
        return maxAttempts - attemptsLeft;
    }

    private AssociationRequest createAssociationRequest(AssociationSessionType type, URL idpUrl) {
        try {
            if (this._minAssocSessEnc.isBetter(type)) {
                return null;
            }
            AssociationRequest assocReq = null;
            if (type.getHAlgorithm() != null) {
                DiffieHellmanSession dhSess = DiffieHellmanSession.create(type, this._dhParams);
                if (DiffieHellmanSession.isDhSupported(type) && Association.isHmacSupported(type.getAssociationType())) {
                    assocReq = AssociationRequest.createAssociationRequest(type, dhSess);
                }
            } else if ((this._allowNoEncHttpSess || idpUrl.getProtocol().equals("https")) && Association.isHmacSupported(type.getAssociationType())) {
                assocReq = AssociationRequest.createAssociationRequest(type);
            }
            return assocReq;
        }
        catch (OpenIDException e) {
            _log.error((Object)"Error trying to create association request.", (Throwable)e);
            return null;
        }
    }

    public AuthRequest authenticate(List discoveries, String returnToUrl) throws ConsumerException, MessageException {
        return this.authenticate(discoveries, returnToUrl, returnToUrl);
    }

    public AuthRequest authenticate(List discoveries, String returnToUrl, String realm) throws ConsumerException, MessageException {
        DiscoveryInformation discovered = this.associate(discoveries);
        return this.authenticate(discovered, returnToUrl, realm);
    }

    public AuthRequest authenticate(DiscoveryInformation discovered, String returnToUrl) throws MessageException, ConsumerException {
        return this.authenticate(discovered, returnToUrl, returnToUrl);
    }

    public AuthRequest authenticate(DiscoveryInformation discovered, String returnToUrl, String realm) throws MessageException, ConsumerException {
        if (discovered == null) {
            throw new ConsumerException("Authentication cannot continue: no discovery information provided.");
        }
        this.associate(discovered, this._maxAssocAttempts);
        Association assoc = this._associations.load(discovered.getIdpEndpoint().toString());
        String handle = assoc != null ? assoc.getHandle() : " ";
        String claimedId = discovered.hasClaimedIdentifier() ? discovered.getClaimedIdentifier().getIdentifier() : "http://specs.openid.net/auth/2.0/identifier_select";
        String delegate = claimedId;
        if (discovered.hasDelegateIdentifier()) {
            delegate = discovered.getDelegateIdentifier();
        }
        if (!this._allowStateless && " ".equals(handle)) {
            throw new ConsumerException("Authentication cannot be performed: no association available and stateless mode is disabled");
        }
        _log.info((Object)("Creating authentication request for OP-endpoint: " + discovered.getIdpEndpoint() + " claimedID: " + claimedId + " OP-specific ID: " + delegate));
        AuthRequest authReq = AuthRequest.createAuthRequest(claimedId, delegate, !discovered.isVersion2(), returnToUrl, handle, realm, this._realmVerifier);
        authReq.setOPEndpoint(discovered.getIdpEndpoint());
        if (!discovered.isVersion2()) {
            authReq.setReturnTo(this.insertConsumerNonce(authReq.getReturnTo()));
        }
        if (!"http://specs.openid.net/auth/2.0/identifier_select".equals(claimedId)) {
            authReq.setImmediate(this._immediateAuth);
        }
        if (!authReq.isValid()) {
            throw new MessageException("Invalid AuthRequest: " + authReq.wwwFormEncoding());
        }
        return authReq;
    }

    public VerificationResult verify(String receivingUrl, ParameterList response, DiscoveryInformation discovered) throws MessageException, DiscoveryException, AssociationException {
        VerificationResult result = new VerificationResult();
        _log.info((Object)"Verifying authentication response...");
        if ("cancel".equals(response.getParameterValue("openid.mode"))) {
            result.setAuthResponse(AuthFailure.createAuthFailure(response));
            _log.info((Object)"Received auth failure.");
            return result;
        }
        if ("setup_needed".equals(response.getParameterValue("openid.mode")) || "id_res".equals(response.getParameterValue("openid.mode")) && response.hasParameter("openid.user_setup_url")) {
            AuthImmediateFailure fail = AuthImmediateFailure.createAuthImmediateFailure(response);
            result.setAuthResponse(fail);
            result.setIdpSetupUrl(fail.getUserSetupUrl());
            _log.info((Object)"Received auth immediate failure.");
            return result;
        }
        AuthSuccess authResp = AuthSuccess.createAuthSuccess(response);
        _log.info((Object)"Received positive auth response.");
        if (!authResp.isValid()) {
            throw new MessageException("Invalid Authentication Response: " + authResp.wwwFormEncoding());
        }
        result.setAuthResponse(authResp);
        if (!this.verifyReturnTo(receivingUrl, authResp)) {
            result.setStatusMsg("Return_To URL verification failed.");
            _log.error((Object)"Return_To URL verification failed.");
            return result;
        }
        if ((discovered = this.verifyDiscovered(authResp, discovered)) == null || !discovered.hasClaimedIdentifier()) {
            result.setStatusMsg("Discovered information verification failed.");
            _log.error((Object)"Discovered information verification failed.");
            return result;
        }
        if (!this.verifyNonce(authResp, discovered)) {
            result.setStatusMsg("Nonce verificaton failed.");
            _log.error((Object)"Nonce verificaton failed.");
            return result;
        }
        return this.verifySignature(authResp, discovered, result);
    }

    public boolean verifyReturnTo(String receivingUrl, AuthSuccess response) {
        StringBuffer returnToPath;
        URL returnTo;
        URL receiving;
        if (DEBUG) {
            _log.debug((Object)("Verifying return URL; receiving: " + receivingUrl + "\nmessage: " + response.getReturnTo()));
        }
        try {
            receiving = new URL(receivingUrl);
            returnTo = new URL(response.getReturnTo());
        }
        catch (MalformedURLException e) {
            _log.error((Object)"Invalid return URL.", (Throwable)e);
            return false;
        }
        StringBuffer receivingPath = new StringBuffer(receiving.getPath());
        if (receivingPath.length() > 0 && receivingPath.charAt(receivingPath.length() - 1) != '/') {
            receivingPath.append('/');
        }
        if ((returnToPath = new StringBuffer(returnTo.getPath())).length() > 0 && returnToPath.charAt(returnToPath.length() - 1) != '/') {
            returnToPath.append('/');
        }
        if (!(receiving.getProtocol().equals(returnTo.getProtocol()) && receiving.getAuthority().equals(returnTo.getAuthority()) && receivingPath.toString().equals(returnToPath.toString()))) {
            if (DEBUG) {
                _log.debug((Object)"Return URL schema, authority or path verification failed.");
            }
            return false;
        }
        try {
            Map returnToParams = this.extractQueryParams(returnTo);
            Map receivingParams = this.extractQueryParams(receiving);
            if (returnToParams == null) {
                return true;
            }
            if (receivingParams == null) {
                if (DEBUG) {
                    _log.debug((Object)"Return URL query parameters verification failed.");
                }
                return false;
            }
            Iterator iter = returnToParams.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                List receivingValues = (List)receivingParams.get(key);
                List returnToValues = (List)returnToParams.get(key);
                if (receivingValues != null && receivingValues.size() == returnToValues.size() && receivingValues.containsAll(returnToValues)) continue;
                if (DEBUG) {
                    _log.debug((Object)"Return URL query parameters verification failed.");
                }
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            _log.error((Object)"Error verifying return URL query parameters.", (Throwable)e);
            return false;
        }
        return true;
    }

    public Map extractQueryParams(URL url) throws UnsupportedEncodingException {
        if (url.getQuery() == null) {
            return null;
        }
        HashMap paramsMap = new HashMap();
        List<String> paramList = Arrays.asList(url.getQuery().split("&"));
        Iterator<String> iter = paramList.iterator();
        while (iter.hasNext()) {
            String key;
            String keyValue = iter.next();
            int equalPos = keyValue.indexOf("=");
            String string = key = equalPos > -1 ? URLDecoder.decode(keyValue.substring(0, equalPos), "UTF-8") : URLDecoder.decode(keyValue, "UTF-8");
            String value = equalPos <= -1 ? null : (equalPos + 1 > keyValue.length() ? "" : URLDecoder.decode(keyValue.substring(equalPos + 1), "UTF-8"));
            List existingValues = (List)paramsMap.get(key);
            if (existingValues == null) {
                ArrayList<String> newValues = new ArrayList<String>();
                newValues.add(value);
                paramsMap.put(key, newValues);
                continue;
            }
            existingValues.add(value);
        }
        return paramsMap;
    }

    public boolean verifyNonce(AuthSuccess authResp, DiscoveryInformation discovered) {
        String nonce = authResp.getNonce();
        if (nonce == null) {
            nonce = this.extractConsumerNonce(authResp.getReturnTo());
        }
        if (nonce == null) {
            return false;
        }
        return 0 == this._nonceVerifier.seen(discovered.getIdpEndpoint().toString(), nonce);
    }

    public String insertConsumerNonce(String returnTo) {
        String nonce = this._consumerNonceGenerator.next();
        returnTo = returnTo + (returnTo.indexOf(63) != -1 ? (char)'&' : '?');
        try {
            returnTo = returnTo + "openid.rpnonce=" + URLEncoder.encode(nonce, "UTF-8");
            returnTo = returnTo + "&openid.rpsig=" + URLEncoder.encode(this._privateAssociation.sign(returnTo), "UTF-8");
            _log.info((Object)"Inserted consumer nonce.");
            if (DEBUG) {
                _log.debug((Object)("return_to:" + returnTo));
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error inserting consumre nonce.", (Throwable)e);
            return null;
        }
        return returnTo;
    }

    public String extractConsumerNonce(String returnTo) {
        URL returnToUrl;
        if (DEBUG) {
            _log.debug((Object)"Extracting consumer nonce...");
        }
        String nonce = null;
        String signature = null;
        try {
            returnToUrl = new URL(returnTo);
        }
        catch (MalformedURLException e) {
            _log.error((Object)("Invalid return_to: " + returnTo), (Throwable)e);
            return null;
        }
        String query = returnToUrl.getQuery();
        String[] params = query.split("&");
        for (int i = 0; i < params.length; ++i) {
            String[] keyVal = params[i].split("=", 2);
            try {
                if (keyVal.length == 2 && "openid.rpnonce".equals(keyVal[0])) {
                    nonce = URLDecoder.decode(keyVal[1], "UTF-8");
                    if (DEBUG) {
                        _log.debug((Object)("Extracted consumer nonce: " + nonce));
                    }
                }
                if (keyVal.length != 2 || !"openid.rpsig".equals(keyVal[0])) continue;
                signature = URLDecoder.decode(keyVal[1], "UTF-8");
                if (!DEBUG) continue;
                _log.debug((Object)("Extracted consumer nonce signature: " + signature));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                _log.error((Object)"Error extracting consumer nonce / signarure.", (Throwable)e);
                return null;
            }
        }
        if (signature == null) {
            _log.error((Object)"Null consumer nonce signature.");
            return null;
        }
        String signed = returnTo.substring(0, returnTo.indexOf("&openid.rpsig="));
        if (DEBUG) {
            _log.debug((Object)("Consumer signed text:\n" + signed));
        }
        try {
            if (this._privateAssociation.verifySignature(signed, signature)) {
                _log.info((Object)"Consumer nonce signature verified.");
                return nonce;
            }
            _log.error((Object)"Consumer nonce signature failed.");
            return null;
        }
        catch (AssociationException e) {
            _log.error((Object)"Error verifying consumer nonce signature.", (Throwable)e);
            return null;
        }
    }

    private DiscoveryInformation verifyDiscovered(AuthSuccess authResp, DiscoveryInformation discovered) throws DiscoveryException {
        if (authResp == null || authResp.getIdentity() == null) {
            _log.info((Object)"Assertion is not about an identifier");
            return null;
        }
        if (authResp.isVersion2()) {
            return this.verifyDiscovered2(authResp, discovered);
        }
        return this.verifyDiscovered1(authResp, discovered);
    }

    private DiscoveryInformation verifyDiscovered1(AuthSuccess authResp, DiscoveryInformation discovered) throws DiscoveryException {
        String opSpecific;
        if (authResp == null || authResp.isVersion2() || authResp.getIdentity() == null || discovered == null || discovered.getClaimedIdentifier() == null || discovered.isVersion2()) {
            if (DEBUG) {
                _log.debug((Object)"Discovered information doesn't match auth response / version");
            }
            return null;
        }
        String assertId = authResp.getIdentity();
        Identifier claimedId = discovered.getClaimedIdentifier();
        if (DEBUG) {
            _log.debug((Object)("Verifying discovered information for OpenID1 assertion about ClaimedID: " + claimedId.getIdentifier()));
        }
        String string = opSpecific = discovered.hasDelegateIdentifier() ? discovered.getDelegateIdentifier() : claimedId.getIdentifier();
        if (opSpecific.equals(assertId)) {
            return discovered;
        }
        if (DEBUG) {
            _log.debug((Object)"Identifier in the assertion doesn't match the one in the discovered information.");
        }
        return null;
    }

    private DiscoveryInformation verifyDiscovered2(AuthSuccess authResp, DiscoveryInformation discovered) throws DiscoveryException {
        if (authResp == null || !authResp.isVersion2() || authResp.getIdentity() == null || authResp.getClaimed() == null) {
            if (DEBUG) {
                _log.debug((Object)"Discovered information doesn't match auth response / version");
            }
            return null;
        }
        String assertId = authResp.getIdentity();
        Identifier respClaimed = Discovery.parseIdentifier(authResp.getClaimed());
        String respEndpoint = authResp.getOpEndpoint();
        if (DEBUG) {
            _log.debug((Object)("Verifying discovered information for OpenID2 assertion about ClaimedID: " + respClaimed.getIdentifier()));
        }
        if (discovered != null && discovered.hasClaimedIdentifier() && discovered.getClaimedIdentifier().equals(respClaimed)) {
            String opSpecific;
            String string = opSpecific = discovered.hasDelegateIdentifier() ? discovered.getDelegateIdentifier() : discovered.getClaimedIdentifier().getIdentifier();
            if (opSpecific.equals(assertId) && discovered.isVersion2() && discovered.getIdpEndpoint().toString().equals(respEndpoint)) {
                if (DEBUG) {
                    _log.debug((Object)("ClaimedID in the assertion was previously discovered: " + respClaimed));
                }
                return discovered;
            }
        }
        DiscoveryInformation firstServiceMatch = null;
        if (DEBUG) {
            _log.debug((Object)("Performing discovery on the ClaimedID in the assertion: " + respClaimed));
        }
        List discoveries = this._discovery.discover(respClaimed);
        if (DEBUG) {
            _log.debug((Object)"Looking for a service element to match the ClaimedID and OP endpoint in the assertion...");
        }
        Iterator iter = discoveries.iterator();
        while (iter.hasNext()) {
            Association assoc;
            String opSpecific;
            DiscoveryInformation service = (DiscoveryInformation)iter.next();
            if ("http://specs.openid.net/auth/2.0/server".equals(service.getVersion()) || !(opSpecific = service.hasDelegateIdentifier() ? service.getDelegateIdentifier() : service.getClaimedIdentifier().getIdentifier()).equals(assertId) || !service.isVersion2() || !service.getIdpEndpoint().toString().equals(respEndpoint)) continue;
            if (firstServiceMatch == null) {
                if (DEBUG) {
                    _log.debug((Object)("Found matching service: " + service));
                }
                firstServiceMatch = service;
            }
            if ((assoc = this._associations.load(service.getIdpEndpoint().toString(), authResp.getHandle())) == null) continue;
            if (DEBUG) {
                _log.debug((Object)"Found existing association, not looking for another service endpoint.");
            }
            return service;
        }
        if (firstServiceMatch == null) {
            _log.error((Object)"No service element found to match the ClaimedID / OP-endpoint in the assertion.");
        }
        return firstServiceMatch;
    }

    private VerificationResult verifySignature(AuthSuccess authResp, DiscoveryInformation discovered, VerificationResult result) throws AssociationException, MessageException {
        if (discovered == null || authResp == null) {
            _log.error((Object)"Can't verify signature: null assertion or discovered information.");
            result.setStatusMsg("Can't verify signature: null assertion or discovered information.");
            return result;
        }
        String handle = authResp.getHandle();
        URL idp = discovered.getIdpEndpoint();
        Association assoc = this._associations.load(idp.toString(), handle);
        if (assoc != null) {
            _log.info((Object)("Found association: " + assoc.getHandle() + " verifying signature locally..."));
            String text = authResp.getSignedText();
            String signature = authResp.getSignature();
            if (assoc.verifySignature(text, signature)) {
                result.setVerifiedId(discovered.getClaimedIdentifier());
                if (DEBUG) {
                    _log.debug((Object)"Local signature verification succeeded.");
                }
            } else if (DEBUG) {
                _log.debug((Object)"Local signature verification failed.");
            }
        } else {
            _log.info((Object)"No association found, contacting the OP for direct verification...");
            VerifyRequest vrfy = VerifyRequest.createVerifyRequest(authResp);
            ParameterList responseParams = new ParameterList();
            int respCode = this.call(idp.toString(), vrfy, responseParams);
            if (200 == respCode) {
                VerifyResponse vrfyResp = VerifyResponse.createVerifyResponse(responseParams);
                if (vrfyResp.isValid() & vrfyResp.isSignatureVerified()) {
                    String invalidateHandle = vrfyResp.getInvalidateHandle();
                    if (invalidateHandle != null) {
                        this._associations.remove(idp.toString(), invalidateHandle);
                    }
                    result.setVerifiedId(discovered.getClaimedIdentifier());
                    if (DEBUG) {
                        _log.debug((Object)("Direct signature verification succeeded with OP: " + idp));
                    }
                } else {
                    if (DEBUG) {
                        _log.debug((Object)("Direct signature verification failed with OP: " + idp));
                    }
                    result.setStatusMsg("Direct signature verification failed.");
                }
            } else {
                DirectError err = DirectError.createDirectError(responseParams);
                if (DEBUG) {
                    _log.debug((Object)("Error verifying signature with the OP: " + idp + " error message: " + err.keyValueFormEncoding()));
                }
                result.setStatusMsg("Error verifying signature with the OP: " + err.getErrorMsg());
            }
        }
        Identifier verifiedID = result.getVerifiedId();
        if (verifiedID != null) {
            _log.info((Object)("Verification succeeded for: " + verifiedID));
        } else {
            _log.error((Object)("Verification failed for: " + verifiedID + " reason: " + result.getStatusMsg()));
        }
        return result;
    }
}

