/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openid4java.association.Association;
import org.openid4java.consumer.ConsumerAssociationStore;

public class InMemoryConsumerAssociationStore
implements ConsumerAssociationStore {
    private static Logger _log = Logger.getLogger((Class)InMemoryConsumerAssociationStore.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private Map _idpMap = new HashMap();

    public synchronized void save(String idpUrl, Association association) {
        this.removeExpired();
        HashMap<String, Association> handleMap = (HashMap<String, Association>)this._idpMap.get(idpUrl);
        if (handleMap == null) {
            handleMap = new HashMap<String, Association>();
            this._idpMap.put(idpUrl, handleMap);
        }
        String handle = association.getHandle();
        if (DEBUG) {
            _log.debug((Object)("Adding association to the in-memory store: " + handle + " with OP: " + idpUrl));
        }
        handleMap.put(association.getHandle(), association);
    }

    public synchronized Association load(String idpUrl, String handle) {
        Map handleMap;
        this.removeExpired();
        if (this._idpMap.containsKey(idpUrl) && (handleMap = (Map)this._idpMap.get(idpUrl)).containsKey(handle)) {
            return (Association)handleMap.get(handle);
        }
        return null;
    }

    public synchronized Association load(String idpUrl) {
        this.removeExpired();
        Association latest = null;
        if (this._idpMap.containsKey(idpUrl)) {
            Map handleMap = (Map)this._idpMap.get(idpUrl);
            Iterator handles = handleMap.keySet().iterator();
            while (handles.hasNext()) {
                String handle = (String)handles.next();
                Association association = (Association)handleMap.get(handle);
                if (latest != null && !latest.getExpiry().before(association.getExpiry())) continue;
                latest = association;
            }
        }
        return latest;
    }

    public synchronized void remove(String idpUrl, String handle) {
        this.removeExpired();
        if (this._idpMap.containsKey(idpUrl)) {
            Map handleMap = (Map)this._idpMap.get(idpUrl);
            _log.info((Object)("Removing association: " + handle + " widh OP: " + idpUrl));
            handleMap.remove(handle);
            if (handleMap.size() == 0) {
                this._idpMap.remove(idpUrl);
            }
        }
    }

    private synchronized void removeExpired() {
        String idpUrl;
        HashSet<String> idpToRemove = new HashSet<String>();
        Iterator<Object> idpUrls = this._idpMap.keySet().iterator();
        while (idpUrls.hasNext()) {
            String handle;
            idpUrl = (String)idpUrls.next();
            Map handleMap = (Map)this._idpMap.get(idpUrl);
            HashSet<String> handleToRemove = new HashSet<String>();
            Iterator<Object> handles = handleMap.keySet().iterator();
            while (handles.hasNext()) {
                handle = (String)handles.next();
                Association association = (Association)handleMap.get(handle);
                if (!association.hasExpired()) continue;
                handleToRemove.add(handle);
            }
            handles = handleToRemove.iterator();
            while (handles.hasNext()) {
                handle = (String)handles.next();
                _log.info((Object)("Removing expired association: " + handle + " with OP: " + idpUrl));
                handleMap.remove(handle);
            }
            if (handleMap.size() != 0) continue;
            idpToRemove.add(idpUrl);
        }
        idpUrls = idpToRemove.iterator();
        while (idpUrls.hasNext()) {
            idpUrl = (String)idpUrls.next();
            this._idpMap.remove(idpUrl);
        }
    }

    protected synchronized int size() {
        int total = 0;
        Iterator idpUrls = this._idpMap.keySet().iterator();
        while (idpUrls.hasNext()) {
            String idpUrl = (String)idpUrls.next();
            Map handleMap = (Map)this._idpMap.get(idpUrl);
            total += handleMap.size();
        }
        return total;
    }
}

