/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.ax;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxMessage;
import org.openid4java.message.ax.FetchRequest;

public class FetchResponse
extends AxMessage {
    private static Logger _log = Logger.getLogger((Class)FetchResponse.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    protected FetchResponse() {
        this._parameters.set(new Parameter("mode", "fetch_response"));
        if (DEBUG) {
            _log.debug((Object)"Created empty fetch response.");
        }
    }

    public static FetchResponse createFetchResponse() {
        return new FetchResponse();
    }

    protected FetchResponse(ParameterList params) {
        this._parameters = params;
    }

    public static FetchResponse createFetchResponse(ParameterList params) throws MessageException {
        FetchResponse resp = new FetchResponse(params);
        if (!resp.isValid()) {
            throw new MessageException("Invalid parameters for a fetch response");
        }
        if (DEBUG) {
            _log.debug((Object)("Created fetch response from parameter list:\n" + params));
        }
        return resp;
    }

    public static FetchResponse createFetchResponse(FetchRequest req, Map userData) {
        FetchResponse resp = new FetchResponse();
        Map attributes = req.getAttributes();
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String alias = (String)i.next();
            Object value = userData.get(alias);
            if (value == null) continue;
            if (value instanceof String) {
                resp.addAttribute(alias, (String)attributes.get(alias), (String)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            Iterator values = ((List)value).iterator();
            int max = req.getCount(alias);
            for (int count = 0; count < max && values.hasNext(); ++count) {
                String val = (String)values.next();
                if (val == null) {
                    --count;
                    continue;
                }
                resp.addAttribute(alias, (String)attributes.get(alias), val);
            }
        }
        return resp;
    }

    public void addAttribute(String alias, String typeUri, String value) {
        int count = this.getCount(alias);
        String index = "";
        switch (count) {
            case 0: {
                this._parameters.set(new Parameter("type." + alias, typeUri));
                break;
            }
            case 1: {
                this._parameters.set(new Parameter("value." + alias + ".1", this.getParameterValue("value." + alias)));
                this._parameters.removeParameters("value." + alias);
                index = ".2";
                break;
            }
            default: {
                index = "." + Integer.toString(count + 1);
            }
        }
        this._parameters.set(new Parameter("value." + alias + index, value));
        this.setCount(alias, ++count);
        if (DEBUG) {
            _log.debug((Object)("Added new attribute to fetch response; type: " + typeUri + " alias: " + alias + " count: " + count));
        }
    }

    public List getAttributeValues(String alias) {
        ArrayList<String> values = new ArrayList<String>();
        if (!this._parameters.hasParameter("count." + alias)) {
            values.add(this.getParameterValue("value." + alias));
        } else {
            for (int i = 1; i <= this.getCount(alias); ++i) {
                values.add(this.getParameterValue("value." + alias + "." + Integer.toString(i)));
            }
        }
        return values;
    }

    public List getAttributeAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String alias;
            String paramName = ((Parameter)it.next()).getKey();
            if (!paramName.startsWith("value.") || aliases.contains(alias = paramName.endsWith(".") ? paramName.substring(6, paramName.length() - 1) : paramName.substring(6))) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    public Map getAttributes() {
        HashMap<String, List> attributes = new HashMap<String, List>();
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String alias;
            String paramName = ((Parameter)it.next()).getKey();
            if (!paramName.startsWith("value.") || attributes.containsKey(alias = paramName.endsWith(".") ? paramName.substring(6, paramName.length() - 1) : paramName.substring(6))) continue;
            attributes.put(alias, this.getAttributeValues(alias));
        }
        return attributes;
    }

    public int getCount(String alias) {
        if (this._parameters.hasParameter("count." + alias)) {
            return Integer.parseInt(this._parameters.getParameterValue("count." + alias));
        }
        if (this._parameters.hasParameter("value." + alias)) {
            return 1;
        }
        return 0;
    }

    private void setCount(String alias, int count) {
        this._parameters.removeParameters("count." + alias);
        if (count > 1) {
            this._parameters.set(new Parameter("count." + alias, Integer.toString(count)));
        }
    }

    public void setUpdateUrl(String updateUrl) throws MessageException {
        try {
            new URL(updateUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageException("Invalid update_url: " + updateUrl);
        }
        if (DEBUG) {
            _log.debug((Object)("Setting fetch response update_url: " + updateUrl));
        }
        this._parameters.set(new Parameter("update_url", updateUrl));
    }

    public String getUpdateUrl() {
        return this._parameters.hasParameter("update_url") ? this._parameters.getParameterValue("update_url") : null;
    }

    private boolean isValid() {
        Iterator it = this._parameters.getParameters().iterator();
        while (it.hasNext()) {
            String paramName = ((Parameter)it.next()).getKey();
            if (paramName.equals("mode") || paramName.startsWith("type.") || paramName.startsWith("count.") || paramName.startsWith("value.") || paramName.equals("update_url")) continue;
            _log.warn((Object)("Invalid parameter name in fetch response: " + paramName));
            return false;
        }
        return this.checkAttributes();
    }

    private boolean checkAttributes() {
        List aliases = this.getAttributeAliases();
        Iterator it = aliases.iterator();
        while (it.hasNext()) {
            String alias = (String)it.next();
            if (!this._parameters.hasParameter("type." + alias)) {
                _log.warn((Object)("Type missing for attribute alias: " + alias));
                return false;
            }
            if (!this._parameters.hasParameter("count." + alias)) {
                if (this._parameters.hasParameter("value." + alias)) continue;
                _log.warn((Object)("Value missing for attribute alias: " + alias));
                return false;
            }
            if (this._parameters.hasParameter("value." + alias)) {
                _log.warn((Object)("Count parameter present for alias: " + alias + "; should use " + alias + ".[index] format"));
                return false;
            }
            int count = this.getCount(alias);
            for (int i = 1; i <= count; ++i) {
                if (this._parameters.hasParameter("value." + alias + "." + Integer.toString(i))) continue;
                _log.warn((Object)("Value missing for alias: " + alias + "." + Integer.toString(i)));
                return false;
            }
        }
        return true;
    }
}

