/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.yadis;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.openid4java.yadis.YadisException;
import org.openid4java.yadis.YadisUrl;
import org.openxri.xml.XRDS;

public class YadisResult {
    private static Logger _log = Logger.getLogger((Class)YadisResult.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private XRDS _xrds;
    private String _contentType;
    private YadisUrl _yadisUrl;
    private String _normalizedUrl;
    private URL _xrdsLocation;
    private int _status = -1;
    private String _statusMessage;
    private Throwable _failureCause;
    public static final int UNDISCOVERED = -1;
    public static final int OK = 0;
    public static final int UNKNOWN_ERROR = 1;
    public static final int INVALID_URL = 2;
    public static final int INVALID_SCHEME = 3;
    public static final int HEAD_TRANSPORT_ERROR = 4;
    public static final int HEAD_INVALID_RESPONSE = 5;
    public static final int GET_ERROR = 6;
    public static final int GET_TRANSPORT_ERROR = 7;
    public static final int GET_INVALID_RESPONSE = 8;
    public static final int GET_NO_XRDS = 9;
    public static final int HTMLMETA_DOWNLOAD_ERROR = 10;
    public static final int HTMLMETA_INVALID_RESPONSE = 11;
    public static final int XRDS_DOWNLOAD_ERROR = 12;
    public static final int XRDS_PARSING_ERROR = 13;
    public static final int XRDS_SIZE_EXCEEDED = 14;

    public void setYadisUrl(YadisUrl url) {
        this._yadisUrl = url;
    }

    public YadisUrl getYadisUrl() {
        return this._yadisUrl;
    }

    public void setXrdsLocation(String xrdsLocation, int onFailError) throws YadisException {
        URL xrdsUrl = null;
        boolean validXrdsUrl = true;
        try {
            xrdsUrl = new URL(xrdsLocation);
        }
        catch (MalformedURLException e) {
            validXrdsUrl = false;
        }
        if (xrdsUrl == null || !validXrdsUrl || !xrdsUrl.getProtocol().equals("http") && !xrdsUrl.getProtocol().equals("https")) {
            throw new YadisException("A Yadis Resource Descriptor URL MUST be an absolute URL and it must be HTTP or HTTPS; found: " + xrdsLocation, onFailError);
        }
        if (DEBUG) {
            _log.debug((Object)("Setting X-XRDS-Location for yadis result: " + xrdsLocation));
        }
        this._xrdsLocation = xrdsUrl;
    }

    public URL getXrdsLocation() {
        return this._xrdsLocation;
    }

    public void setXrds(XRDS xrds) {
        this._xrds = xrds;
    }

    public XRDS getXrds() {
        return this._xrds;
    }

    public String getNormalizedUrl() {
        return this._normalizedUrl;
    }

    public void setNormalizedUrl(String _normalizedUrl) {
        this._normalizedUrl = _normalizedUrl;
    }

    public void setContentType(String type) {
        this._contentType = type;
    }

    public String getContentType() {
        return this._contentType;
    }

    public int getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this._status = status;
    }

    public String getStatusMessage() {
        return this._statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this._statusMessage = statusMessage;
    }

    public void setFailureCause(Throwable e) {
        this._failureCause = e;
    }

    public Throwable getFailureCause() {
        return this._failureCause;
    }

    public String dump() {
        StringBuffer dump = new StringBuffer();
        dump.append("YadisURL:").append(this._yadisUrl);
        dump.append("\nNormalizedURL:").append(this._normalizedUrl);
        dump.append("\nX-XRDS-Location:").append(this._xrdsLocation);
        dump.append("\nContent-type:").append(this._contentType);
        dump.append("\nXRDS:\n").append(this._xrds.dump());
        return dump.toString();
    }
}

