/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class SimpleSender {
    private Session session = Session.getInstance((Properties)new Properties(), null);
    private Transport transport;

    public SimpleSender() throws NoSuchProviderException {
        this("smtp");
    }

    public SimpleSender(String string) throws NoSuchProviderException {
        this.session.setDebug(Boolean.getBoolean("mail.debug"));
        this.transport = this.session.getTransport(string);
    }

    public void connect(String string) throws MessagingException {
        this.connect(string, -1, null, null);
    }

    public void connect(String string, int n) throws MessagingException {
        this.connect(string, n, null, null);
    }

    public synchronized void connect(String string, int n, String string2, String string3) throws MessagingException {
        this.transport.connect(string, n, string2, string3);
    }

    public synchronized void disconnect() {
        try {
            this.transport.close();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public void useSMTPAuth(boolean bl) {
        this.session.getProperties().put("mail.smtp.auth", String.valueOf(bl));
    }

    public MimeMessage createMessage() {
        return new MimeMessage(this.session);
    }

    public static void setHeaders(MimeMessage mimeMessage, String string, String string2) throws MessagingException, AddressException {
        mimeMessage.setFrom(null);
        mimeMessage.addFrom((Address[])InternetAddress.parse((String)string2, (boolean)true));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string, (boolean)true));
        mimeMessage.setHeader("X-Mailer", "JavaMail Sender");
    }

    public void send(MimeMessage mimeMessage) throws MessagingException {
        this.send(mimeMessage, mimeMessage.getAllRecipients());
    }

    public synchronized void send(MimeMessage mimeMessage, Address[] addressArray) throws MessagingException {
        mimeMessage.setSentDate(new Date());
        this.session.getProperties().put("mail.from", ((InternetAddress)mimeMessage.getFrom()[0]).getAddress());
        mimeMessage.saveChanges();
        this.transport.sendMessage((Message)mimeMessage, addressArray);
    }

    public synchronized void send(MimeMessage mimeMessage, String string, String string2) throws MessagingException, AddressException {
        this.session.getProperties().put("mail.smtp.from", string2);
        this.send(mimeMessage, (Address[])InternetAddress.parse((String)string, (boolean)true));
        this.session.getProperties().remove("mail.smtp.from");
    }

    public void send(String string, String string2, String string3, String string4) throws MessagingException, AddressException {
        MimeMessage mimeMessage = this.createMessage();
        SimpleSender.setHeaders(mimeMessage, string, string2);
        try {
            mimeMessage.setSubject(MimeUtility.encodeText((String)string3, (String)"ISO-2022-JP", (String)"B"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        mimeMessage.setText(string4, "ISO-2022-JP");
        this.send(mimeMessage);
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    public static void send(String string, String string2, String string3, String string4, String string5) throws MessagingException, AddressException {
        SimpleSender simpleSender = new SimpleSender();
        MimeMessage mimeMessage = simpleSender.createMessage();
        SimpleSender.setHeaders(mimeMessage, string2, string3);
        try {
            mimeMessage.setSubject(MimeUtility.encodeText((String)string4, (String)"ISO-2022-JP", (String)"B"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        mimeMessage.setText(string5, "ISO-2022-JP");
        simpleSender.connect(string);
        simpleSender.send(mimeMessage);
        simpleSender.disconnect();
    }

    public static void main(String[] stringArray) throws Exception {
        SimpleSender.send("localhost", "postmaster@localhost", "\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042\u3042 <shin@localhost>", "\u3066\u3059\u3068", "\u65e5\u672c\u8a9e\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u3066\u3059\u3068\u3067\u3059\u3002");
    }
}

