/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.remoting.support.RemoteInvocationTraceInterceptor;
import org.springframework.util.ClassUtils;

public abstract class RemoteExporter
implements BeanClassLoaderAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object service;
    private Class serviceInterface;
    private boolean registerTraceInterceptor = true;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public void setService(Object service) {
        this.service = service;
    }

    public Object getService() {
        return this.service;
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("'serviceInterface' must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setRegisterTraceInterceptor(boolean registerTraceInterceptor) {
        this.registerTraceInterceptor = registerTraceInterceptor;
    }

    protected boolean isRegisterTraceInterceptor() {
        return this.registerTraceInterceptor;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    protected void checkService() throws IllegalArgumentException {
        if (this.getService() == null) {
            throw new IllegalArgumentException("Property 'service' is required");
        }
    }

    protected void checkServiceInterface() throws IllegalArgumentException {
        Class serviceInterface = this.getServiceInterface();
        Object service = this.getService();
        if (serviceInterface == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        if (service instanceof String) {
            throw new IllegalArgumentException("Service [" + service + "] is a String " + "rather than an actual service reference: Have you accidentally specified " + "the service bean name as value instead of as reference?");
        }
        if (!serviceInterface.isInstance(service)) {
            throw new IllegalArgumentException("Service interface [" + serviceInterface.getName() + "] needs to be implemented by service [" + service + "] of class [" + service.getClass().getName() + "]");
        }
    }

    protected Object getProxyForService() {
        this.checkService();
        this.checkServiceInterface();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addInterface(this.getServiceInterface());
        if (this.isRegisterTraceInterceptor()) {
            proxyFactory.addAdvice(new RemoteInvocationTraceInterceptor(this.getExporterName()));
        }
        proxyFactory.setTarget(this.getService());
        return proxyFactory.getProxy(this.getBeanClassLoader());
    }

    protected String getExporterName() {
        return ClassUtils.getShortName(this.getClass());
    }

    protected ClassLoader overrideThreadContextClassLoader() {
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        ClassLoader beanClassLoader = this.getBeanClassLoader();
        if (beanClassLoader != null && !beanClassLoader.equals(threadContextClassLoader)) {
            currentThread.setContextClassLoader(beanClassLoader);
            return threadContextClassLoader;
        }
        return null;
    }

    protected void resetThreadContextClassLoader(ClassLoader original) {
        if (original != null) {
            Thread.currentThread().setContextClassLoader(original);
        }
    }
}

