/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.yadis;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.log4j.Logger;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.tags.MetaTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.openid4java.util.HttpClientFactory;
import org.openid4java.yadis.YadisException;
import org.openid4java.yadis.YadisResult;
import org.openid4java.yadis.YadisUrl;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class YadisResolver {
    private static Logger _log = Logger.getLogger((Class)YadisResolver.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private static final String YADIS_XRDS_LOCATION = "X-XRDS-Location";
    private static final String YADIS_CONTENT_TYPE = "application/xrds+xml";
    private static final String YADIS_ACCEPT_HEADER = "text/html; q=0.3, application/xhtml+xml; q=0.5, application/xrds+xml";
    private int _maxRedirects = 10;
    private int _maxHtmlSize = 100000;
    private int _maxXmlSize = 100000;
    private int _connTimeout = 3000;
    private int _socketTimeout = 5000;

    public int getMaxRedirects() {
        return this._maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this._maxRedirects = maxRedirects;
    }

    public int getMaxHtmlSize() {
        return this._maxHtmlSize;
    }

    public void setMaxHtmlSize(int maxHtmlSize) {
        this._maxHtmlSize = maxHtmlSize;
    }

    public int getMaxXmlSize() {
        return this._maxXmlSize;
    }

    public void setMaxXmlSize(int maxXmlSize) {
        this._maxXmlSize = maxXmlSize;
    }

    public int getConnTimeout() {
        return this._connTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this._connTimeout = connTimeout;
    }

    public int getSocketTimeout() {
        return this._socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this._socketTimeout = socketTimeout;
    }

    public YadisResult discover(String url) {
        HttpClient client = HttpClientFactory.getInstance(this._maxRedirects, Boolean.TRUE, this._socketTimeout, this._connTimeout, "ignoreCookies");
        YadisResult result = new YadisResult();
        try {
            YadisUrl yadisUrl = new YadisUrl(url);
            result.setYadisUrl(yadisUrl);
            this.headXrdsUrl(client, yadisUrl, result);
            this.getXrds(client, result, false);
            result.setStatus(0);
            _log.info((Object)("Yadis discovery succeeded on " + url));
        }
        catch (YadisException e) {
            result.setStatus(e.getStatusCode());
            result.setStatusMessage(e.getMessage());
            if (e.getCause() != null) {
                result.setFailureCause(e.getCause());
            }
            _log.info((Object)("Yadis discovery failed on " + url + ", status: " + e.getStatusCode() + ", error message: " + e.getMessage()));
        }
        return result;
    }

    private void getXrds(HttpClient client, YadisResult result, boolean secondCall) throws YadisException {
        block15: {
            String getUrl = result.getXrdsLocation() != null ? result.getXrdsLocation().toString() : result.getYadisUrl().toString();
            GetMethod get = new GetMethod(getUrl);
            get.setFollowRedirects(true);
            get.setRequestHeader("Accept", YADIS_ACCEPT_HEADER);
            try {
                Header contentType;
                int statusCode;
                if (DEBUG) {
                    _log.debug((Object)("Performing HTTP GET #" + (secondCall ? "2" : "1") + " on: " + getUrl + " ..."));
                }
                if ((statusCode = client.executeMethod((HttpMethod)get)) != 200) {
                    throw new YadisException("GET failed on " + getUrl, 6);
                }
                if (result.getNormalizedUrl() == null) {
                    result.setNormalizedUrl(get.getURI().toString());
                }
                if ((contentType = get.getResponseHeader("content-type")) != null && contentType.getValue() != null && contentType.getValue().split(";")[0].equalsIgnoreCase(YADIS_CONTENT_TYPE)) {
                    XRDS xrds = this.parseXrds(get.getResponseBodyAsStream());
                    result.setXrdsLocation(get.getURI().toString(), 8);
                    result.setContentType(YADIS_ACCEPT_HEADER);
                    result.setXrds(xrds);
                    if (DEBUG) {
                        _log.debug((Object)("Retrieved Yadis discovery result:\n" + result.dump()));
                    }
                    break block15;
                }
                if (!secondCall) {
                    if (get.getResponseHeaders(YADIS_XRDS_LOCATION).length > 1) {
                        throw new YadisException("Found more than one X-XRDS-Location headers: " + get.getResponseHeaders(YADIS_XRDS_LOCATION), 8);
                    }
                    String xrdsLocation = null;
                    if (get.getResponseHeader(YADIS_XRDS_LOCATION) != null) {
                        xrdsLocation = get.getResponseHeader(YADIS_XRDS_LOCATION).getValue();
                        if (DEBUG) {
                            _log.debug((Object)"Found X-XRDS-Location header.");
                        }
                    }
                    if (xrdsLocation == null) {
                        xrdsLocation = this.getHtmlMeta(get.getResponseBodyAsStream());
                    }
                    result.setXrdsLocation(xrdsLocation, 8);
                    this.getXrds(client, result, true);
                    break block15;
                }
                throw new YadisException("Cannot retrieve XRDS for " + result.getYadisUrl().getUrl().toString(), 9);
            }
            catch (IOException e) {
                throw new YadisException("Fatal transport error: ", 7, e);
            }
            finally {
                get.releaseConnection();
            }
        }
    }

    private String getHtmlMeta(InputStream input) throws YadisException {
        String xrdsLocation = null;
        if (input == null) {
            throw new YadisException("Cannot download HTML message", 10);
        }
        try {
            byte[] data = new byte[this._maxHtmlSize];
            int bytesRead = input.read(data);
            input.close();
            if (bytesRead <= 0) {
                throw new YadisException("No data read from the HTML message", 10);
            }
            Parser parser = Parser.createParser((String)new String(data, 0, bytesRead), null);
            NodeList heads = parser.parse((NodeFilter)new TagNameFilter("HEAD"));
            if (heads.size() != 1) {
                throw new YadisException("HTML response must have exactly one HEAD element, found " + heads.size() + " : " + heads.toHtml(), 11);
            }
            Node head = heads.elementAt(0);
            SimpleNodeIterator i = head.getChildren().elements();
            while (i.hasMoreNodes()) {
                MetaTag meta;
                Node node = i.nextNode();
                if (!(node instanceof MetaTag) || (meta = (MetaTag)node).getHttpEquiv() == null || !meta.getHttpEquiv().equalsIgnoreCase(YADIS_XRDS_LOCATION)) continue;
                if (xrdsLocation != null) {
                    throw new YadisException("More than one X-XRDS-LocationMETA tags found in HEAD: " + head.toHtml(), 11);
                }
                xrdsLocation = meta.getMetaContent();
                if (!DEBUG) continue;
                _log.debug((Object)"Found X-XRDS-LocationMETA tags.");
            }
        }
        catch (IOException e) {
            throw new YadisException("I/O error while reading HTML message", 10, e);
        }
        catch (ParserException pe) {
            throw new YadisException("Error parsing HTML message", 11, pe);
        }
        return xrdsLocation;
    }

    private XRDS parseXrds(InputStream input) throws YadisException {
        XRDS xrds;
        if (input == null) {
            throw new YadisException("Cannot read XML message", 12);
        }
        try {
            byte[] data = new byte[this._maxXmlSize];
            int bytesRead = input.read(data);
            if (input.read() != -1) {
                throw new YadisException("XRDS stream exceeds max allowed size: " + this._maxXmlSize, 14);
            }
            input.close();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(data, 0, bytesRead));
            xrds = new XRDS(document.getDocumentElement(), false);
            if (DEBUG) {
                _log.debug((Object)("Retrieved Yadis / XRDS:\n" + xrds.dump()));
            }
        }
        catch (ParserConfigurationException e) {
            throw new YadisException("Parser configuration error", 13, e);
        }
        catch (SAXException e) {
            throw new YadisException("Error parsing XML document", 13, e);
        }
        catch (ParseException e) {
            throw new YadisException("Error parsing XML DATE field", 13, e);
        }
        catch (URISyntaxException e) {
            throw new YadisException("Invalid URI specified in XRDS document", 13, e);
        }
        catch (IOException e) {
            throw new YadisException("Error reading XRDS document", 12, e);
        }
        return xrds;
    }

    private void headXrdsUrl(HttpClient client, YadisUrl url, YadisResult result) throws YadisException {
        HeadMethod head = new HeadMethod(url.getUrl().toString());
        head.setFollowRedirects(true);
        try {
            int statusCode;
            if (DEBUG) {
                _log.debug((Object)("Performing HTTP HEAD on: " + url + " ..."));
            }
            if ((statusCode = client.executeMethod((HttpMethod)head)) != 200) {
                if (DEBUG) {
                    _log.debug((Object)("Cannot retrieve X-XRDS-Location using HEAD from " + url.getUrl().toString() + "; status=" + head.getStatusLine()));
                }
                return;
            }
            if (head.getResponseHeaders(YADIS_XRDS_LOCATION).length > 1) {
                throw new YadisException("Found more than one X-XRDS-Location headers: " + head.getResponseHeaders(YADIS_XRDS_LOCATION), 5);
            }
            Header xrdsLocation = head.getResponseHeader(YADIS_XRDS_LOCATION);
            if (xrdsLocation != null) {
                result.setXrdsLocation(xrdsLocation.getValue(), 5);
                result.setNormalizedUrl(head.getURI().toString());
            }
        }
        catch (HttpException e) {
            _log.error((Object)("HTTP error during HEAD request on: " + url), (Throwable)e);
        }
        catch (IOException e) {
            throw new YadisException("I/O transport error: ", 4, e);
        }
        finally {
            head.releaseConnection();
        }
    }
}

