/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.io.CharCodeConverter;
import com.sk_jp.io.UnicodeCorrector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

public class JISDataSource
implements DataSource {
    private byte[] data;

    public JISDataSource(String string) {
        try {
            this.data = CharCodeConverter.sjisToJis(UnicodeCorrector.getInstance("Windows-31J").correct(string).getBytes("Windows-31J"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("CANT HAPPEN");
        }
    }

    public String getContentType() {
        return "text/plain; charset=ISO-2022-JP";
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    public String getName() {
        return "dummy";
    }
}

