/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openid4java.consumer.AbstractNonceVerifier;

public class InMemoryNonceVerifier
extends AbstractNonceVerifier {
    private static Logger _log = Logger.getLogger((Class)InMemoryNonceVerifier.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private Map _idpMap = new HashMap();

    public InMemoryNonceVerifier(int maxAge) {
        super(maxAge);
    }

    protected synchronized int seen(Date now, String idpUrl, String nonce) {
        this.removeAged(now);
        HashSet<String> seenSet = (HashSet<String>)this._idpMap.get(idpUrl);
        if (seenSet == null) {
            seenSet = new HashSet<String>();
            this._idpMap.put(idpUrl, seenSet);
        }
        if (seenSet.contains(nonce)) {
            _log.error((Object)("Possible replay attack! Already seen nonce: " + nonce));
            return 1;
        }
        seenSet.add(nonce);
        if (DEBUG) {
            _log.debug((Object)("Nonce verified: " + nonce));
        }
        return 0;
    }

    private synchronized void removeAged(Date now) {
        String idpUrl;
        HashSet<String> idpToRemove = new HashSet<String>();
        Iterator<Object> idpUrls = this._idpMap.keySet().iterator();
        while (idpUrls.hasNext()) {
            String nonce;
            idpUrl = (String)idpUrls.next();
            Set seenSet = (Set)this._idpMap.get(idpUrl);
            HashSet<String> nonceToRemove = new HashSet<String>();
            Iterator nonces = seenSet.iterator();
            while (nonces.hasNext()) {
                nonce = (String)nonces.next();
                try {
                    Date nonceDate = _dateFormat.parse(nonce);
                    if (!this.isTooOld(now, nonceDate)) continue;
                    nonceToRemove.add(nonce);
                }
                catch (ParseException e) {
                    nonceToRemove.add(nonce);
                }
            }
            nonces = nonceToRemove.iterator();
            while (nonces.hasNext()) {
                nonce = (String)nonces.next();
                if (DEBUG) {
                    _log.debug((Object)("Removing nonce: " + nonce + " from OP: " + idpUrl));
                }
                seenSet.remove(nonce);
            }
            if (seenSet.size() != 0) continue;
            idpToRemove.add(idpUrl);
        }
        idpUrls = idpToRemove.iterator();
        while (idpUrls.hasNext()) {
            idpUrl = (String)idpUrls.next();
            if (DEBUG) {
                _log.debug((Object)("Removed all nonces from OP: " + idpUrl));
            }
            this._idpMap.remove(idpUrl);
        }
    }

    protected synchronized int size() {
        int total = 0;
        Iterator idpUrls = this._idpMap.keySet().iterator();
        while (idpUrls.hasNext()) {
            String idpUrl = (String)idpUrls.next();
            Set seenSet = (Set)this._idpMap.get(idpUrl);
            total += seenSet.size();
        }
        return total;
    }
}

