/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery;

import java.io.Serializable;
import java.net.URL;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.Identifier;

public class DiscoveryInformation
implements Serializable {
    URL _idpEndpoint;
    Identifier _claimedIdentifier;
    String _delegate;
    String _version;
    public static final String OPENID10 = "http://openid.net/signon/1.0";
    public static final String OPENID11 = "http://openid.net/signon/1.1";
    public static final String OPENID2 = "http://specs.openid.net/auth/2.0/signon";
    public static final String OPENID2_OP = "http://specs.openid.net/auth/2.0/server";

    public DiscoveryInformation(URL idpEndpoint) throws DiscoveryException {
        this(idpEndpoint, null, OPENID2_OP);
    }

    public DiscoveryInformation(URL idpEndpoint, Identifier claimedIdentifier) throws DiscoveryException {
        this(idpEndpoint, claimedIdentifier, OPENID2);
    }

    public DiscoveryInformation(URL idpEndpoint, Identifier claimedIdentifier, String version) throws DiscoveryException {
        this(idpEndpoint, claimedIdentifier, null, version);
    }

    public DiscoveryInformation(URL idpEndpoint, Identifier claimedIdentifier, String delegate, String version) throws DiscoveryException {
        this._idpEndpoint = idpEndpoint;
        this._claimedIdentifier = claimedIdentifier;
        this._version = version;
        this._delegate = delegate;
        if (this._idpEndpoint == null) {
            throw new DiscoveryException("Null OpenID Provider endpoint.");
        }
        if (this._delegate != null && this._claimedIdentifier == null) {
            throw new DiscoveryException("Claimed ID must be present if delegated ID is used.");
        }
    }

    public boolean hasClaimedIdentifier() {
        return this._claimedIdentifier != null;
    }

    public boolean hasDelegateIdentifier() {
        return this._delegate != null;
    }

    public URL getIdpEndpoint() {
        return this._idpEndpoint;
    }

    public Identifier getClaimedIdentifier() {
        return this._claimedIdentifier;
    }

    public String getDelegateIdentifier() {
        return this._delegate;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public boolean isVersion2() {
        return OPENID2.equals(this._version) || OPENID2_OP.equals(this._version);
    }

    public String toString() {
        return (this.isVersion2() ? "OpenID2" : "OpenID1") + "\nOP-endpoint:" + this._idpEndpoint + "\nClaimedID:" + this._claimedIdentifier + "\nDelegate:" + this._delegate;
    }
}

