/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.io;

import com.sk_jp.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUpdate {
    private File file;
    private File dir;
    private File tempFile;

    public FileUpdate(String string) {
        this(new File(string));
    }

    public FileUpdate(File file) {
        this.file = file;
        this.dir = file.getParentFile();
    }

    public FileUpdate(File file, File file2) {
        this.file = file;
        this.dir = file2;
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.getWriteFile());
    }

    public File getWriteFile() throws IOException {
        this.tempFile = File.createTempFile("temp", null, this.dir);
        this.tempFile.deleteOnExit();
        return this.tempFile;
    }

    public void update() throws IOException {
        this.update(null);
    }

    public void update(File file) throws IOException {
        boolean bl = false;
        if (file == null) {
            bl = true;
            file = File.createTempFile("back", ".bak", this.dir);
            file.deleteOnExit();
        }
        file.delete();
        if (!this.file.renameTo(file)) {
            Log.log("Rename failed: " + this.file + " -> " + file);
        }
        if (!this.tempFile.renameTo(this.file)) {
            throw new IOException("Rename failed: " + this.tempFile + " -> " + this.file);
        }
        if (bl) {
            file.delete();
        }
    }
}

