/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;

public final class ColumnDescriptor
extends TupleDescriptor {
    private DefaultInfo columnDefaultInfo;
    private TableDescriptor table;
    private String columnName;
    private int columnPosition;
    private DataTypeDescriptor columnType;
    private DataValueDescriptor columnDefault;
    private UUID uuid;
    private UUID defaultUUID;
    private long autoincStart;
    private long autoincInc;
    private long autoincValue;
    long autoinc_create_or_modify_Start_Increment = -1L;

    public ColumnDescriptor(String string, int n, DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor, DefaultInfo defaultInfo, TableDescriptor tableDescriptor, UUID uUID, long l, long l2, long l3) {
        this(string, n, dataTypeDescriptor, dataValueDescriptor, defaultInfo, tableDescriptor, uUID, l, l2);
        this.autoinc_create_or_modify_Start_Increment = l3;
    }

    public ColumnDescriptor(String string, int n, DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor, DefaultInfo defaultInfo, TableDescriptor tableDescriptor, UUID uUID, long l, long l2) {
        this.columnName = string;
        this.columnPosition = n;
        this.columnType = dataTypeDescriptor;
        this.columnDefault = dataValueDescriptor;
        this.columnDefaultInfo = defaultInfo;
        this.defaultUUID = uUID;
        if (tableDescriptor != null) {
            this.table = tableDescriptor;
            this.uuid = tableDescriptor.getUUID();
        }
        ColumnDescriptor.assertAutoinc(l2 != 0L, l2, defaultInfo);
        this.autoincStart = l;
        this.autoincValue = l;
        this.autoincInc = l2;
    }

    public ColumnDescriptor(String string, int n, DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor, DefaultInfo defaultInfo, UUID uUID, UUID uUID2, long l, long l2, long l3) {
        this.columnName = string;
        this.columnPosition = n;
        this.columnType = dataTypeDescriptor;
        this.columnDefault = dataValueDescriptor;
        this.columnDefaultInfo = defaultInfo;
        this.uuid = uUID;
        this.defaultUUID = uUID2;
        ColumnDescriptor.assertAutoinc(l2 != 0L, l2, defaultInfo);
        this.autoincStart = l;
        this.autoincValue = l3;
        this.autoincInc = l2;
    }

    public UUID getReferencingUUID() {
        return this.uuid;
    }

    public TableDescriptor getTableDescriptor() {
        return this.table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public void setTableDescriptor(TableDescriptor tableDescriptor) {
        this.table = tableDescriptor;
    }

    public int getPosition() {
        return this.columnPosition;
    }

    public DataTypeDescriptor getType() {
        return this.columnType;
    }

    public boolean hasNonNullDefault() {
        if (this.columnDefault != null && !this.columnDefault.isNull()) {
            return true;
        }
        return this.columnDefaultInfo != null;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.columnDefault;
    }

    public DefaultInfo getDefaultInfo() {
        return this.columnDefaultInfo;
    }

    public UUID getDefaultUUID() {
        return this.defaultUUID;
    }

    public DefaultDescriptor getDefaultDescriptor(DataDictionary dataDictionary) {
        DefaultDescriptor defaultDescriptor = null;
        if (this.defaultUUID != null) {
            defaultDescriptor = new DefaultDescriptor(dataDictionary, this.defaultUUID, this.uuid, this.columnPosition);
        }
        return defaultDescriptor;
    }

    public boolean isAutoincrement() {
        return this.autoincInc != 0L;
    }

    public boolean updatableByCursor() {
        return false;
    }

    public boolean hasGenerationClause() {
        if (this.columnDefaultInfo == null) {
            return false;
        }
        return this.columnDefaultInfo.isGeneratedColumn();
    }

    public boolean isAutoincAlways() {
        return this.columnDefaultInfo == null && this.isAutoincrement();
    }

    public long getAutoincStart() {
        return this.autoincStart;
    }

    public long getAutoincInc() {
        return this.autoincInc;
    }

    public long getAutoincValue() {
        return this.autoincValue;
    }

    public long getAutoinc_create_or_modify_Start_Increment() {
        return this.autoinc_create_or_modify_Start_Increment;
    }

    public void setAutoinc_create_or_modify_Start_Increment(int n) {
        this.autoinc_create_or_modify_Start_Increment = n;
    }

    public void setPosition(int n) {
        this.columnPosition = n;
    }

    public String toString() {
        return "";
    }

    public String getDescriptorName() {
        return this.columnName;
    }

    public String getDescriptorType() {
        return "Column";
    }

    private static void assertAutoinc(boolean bl, long l, DefaultInfo defaultInfo) {
    }
}

