/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPSignature {
    public static final int BINARY_DOCUMENT = 0;
    public static final int CANONICAL_TEXT_DOCUMENT = 1;
    public static final int STAND_ALONE = 2;
    public static final int DEFAULT_CERTIFICATION = 16;
    public static final int NO_CERTIFICATION = 17;
    public static final int CASUAL_CERTIFICATION = 18;
    public static final int POSITIVE_CERTIFICATION = 19;
    public static final int SUBKEY_BINDING = 24;
    public static final int DIRECT_KEY = 31;
    public static final int KEY_REVOCATION = 32;
    public static final int SUBKEY_REVOCATION = 40;
    public static final int CERTIFICATION_REVOCATION = 48;
    public static final int TIMESTAMP = 64;
    private SignaturePacket sigPck;
    private Signature sig;
    private int signatureType;
    private TrustPacket trustPck;
    private byte lastb;

    PGPSignature(BCPGInputStream bCPGInputStream) throws IOException, PGPException {
        this((SignaturePacket)bCPGInputStream.readPacket());
    }

    PGPSignature(SignaturePacket signaturePacket) throws PGPException {
        this.sigPck = signaturePacket;
        this.signatureType = this.sigPck.getSignatureType();
        this.trustPck = null;
    }

    PGPSignature(SignaturePacket signaturePacket, TrustPacket trustPacket) throws PGPException {
        this(signaturePacket);
        this.trustPck = trustPacket;
    }

    private void getSig(String string) throws PGPException {
        try {
            this.sig = Signature.getInstance(PGPUtil.getSignatureName(this.sigPck.getKeyAlgorithm(), this.sigPck.getHashAlgorithm()), string);
        }
        catch (Exception exception) {
            throw new PGPException("can't set up signature object.", exception);
        }
    }

    public int getVersion() {
        return this.sigPck.getVersion();
    }

    public int getKeyAlgorithm() {
        return this.sigPck.getKeyAlgorithm();
    }

    public int getHashAlgorithm() {
        return this.sigPck.getHashAlgorithm();
    }

    public void initVerify(PGPPublicKey pGPPublicKey, String string) throws NoSuchProviderException, PGPException {
        if (this.sig == null) {
            this.getSig(string);
        }
        try {
            this.sig.initVerify(pGPPublicKey.getKey(string));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("invalid key.", invalidKeyException);
        }
        this.lastb = 0;
    }

    public void update(byte by) throws SignatureException {
        if (this.signatureType == 1) {
            if (by == 13) {
                this.sig.update((byte)13);
                this.sig.update((byte)10);
            } else if (by == 10) {
                if (this.lastb != 13) {
                    this.sig.update((byte)13);
                    this.sig.update((byte)10);
                }
            } else {
                this.sig.update(by);
            }
            this.lastb = by;
        } else {
            this.sig.update(by);
        }
    }

    public void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.signatureType == 1) {
            int n3 = n + n2;
            for (int i = n; i != n3; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.sig.update(byArray, n, n2);
        }
    }

    public boolean verify() throws PGPException, SignatureException {
        this.sig.update(this.getSignatureTrailer());
        return this.sig.verify(this.getSignature());
    }

    public boolean verifyCertification(String string, PGPPublicKey pGPPublicKey) throws PGPException, SignatureException {
        byte[] byArray = this.getEncodedPublicKey(pGPPublicKey);
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
        byte[] byArray2 = new byte[string.length()];
        for (int i = 0; i != byArray2.length; ++i) {
            byArray2[i] = (byte)string.charAt(i);
        }
        this.update((byte)-76);
        this.update((byte)(byArray2.length >> 24));
        this.update((byte)(byArray2.length >> 16));
        this.update((byte)(byArray2.length >> 8));
        this.update((byte)byArray2.length);
        this.update(byArray2);
        this.update(this.sigPck.getSignatureTrailer());
        return this.sig.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws SignatureException, PGPException {
        byte[] byArray = this.getEncodedPublicKey(pGPPublicKey);
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
        byArray = this.getEncodedPublicKey(pGPPublicKey2);
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
        this.update(this.sigPck.getSignatureTrailer());
        return this.sig.verify(this.getSignature());
    }

    public boolean verifyCertification(PGPPublicKey pGPPublicKey) throws SignatureException, PGPException {
        if (this.getSignatureType() != 32 && this.getSignatureType() != 40) {
            throw new IllegalStateException("signature is not a key signature");
        }
        byte[] byArray = this.getEncodedPublicKey(pGPPublicKey);
        this.update((byte)-103);
        this.update((byte)(byArray.length >> 8));
        this.update((byte)byArray.length);
        this.update(byArray);
        this.update(this.sigPck.getSignatureTrailer());
        return this.sig.verify(this.getSignature());
    }

    public int getSignatureType() {
        return this.sigPck.getSignatureType();
    }

    public long getKeyID() {
        return this.sigPck.getKeyID();
    }

    public Date getCreationTime() {
        return new Date(this.sigPck.getCreationTime());
    }

    public byte[] getSignatureTrailer() {
        return this.sigPck.getSignatureTrailer();
    }

    public PGPSignatureSubpacketVector getHashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getHashedSubPackets());
    }

    public PGPSignatureSubpacketVector getUnhashedSubPackets() {
        return this.createSubpacketVector(this.sigPck.getUnhashedSubPackets());
    }

    private PGPSignatureSubpacketVector createSubpacketVector(SignatureSubpacket[] signatureSubpacketArray) {
        if (signatureSubpacketArray != null) {
            return new PGPSignatureSubpacketVector(signatureSubpacketArray);
        }
        return null;
    }

    public byte[] getSignature() throws PGPException {
        byte[] byArray;
        MPInteger[] mPIntegerArray = this.sigPck.getSignature();
        if (mPIntegerArray != null) {
            if (mPIntegerArray.length == 1) {
                byte[] byArray2 = mPIntegerArray[0].getValue().toByteArray();
                if (byArray2[0] == 0) {
                    byArray = new byte[byArray2.length - 1];
                    System.arraycopy(byArray2, 1, byArray, 0, byArray.length);
                } else {
                    byArray = byArray2;
                }
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
                try {
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    aSN1EncodableVector.add((DEREncodable)new DERInteger(mPIntegerArray[0].getValue()));
                    aSN1EncodableVector.add((DEREncodable)new DERInteger(mPIntegerArray[1].getValue()));
                    aSN1OutputStream.writeObject((Object)new DERSequence((DEREncodableVector)aSN1EncodableVector));
                }
                catch (IOException iOException) {
                    throw new PGPException("exception encoding DSA sig.", iOException);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
        } else {
            byArray = this.sigPck.getSignatureBytes();
        }
        return byArray;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.sigPck);
        if (this.trustPck != null) {
            bCPGOutputStream.writePacket(this.trustPck);
        }
    }

    private byte[] getEncodedPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        byte[] byArray;
        try {
            byArray = pGPPublicKey.publicPk.getEncodedContents();
        }
        catch (IOException iOException) {
            throw new PGPException("exception preparing key.", iOException);
        }
        return byArray;
    }
}

