/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.ExtCRLException;
import org.bouncycastle.jce.provider.X509CRLEntryObject;
import org.bouncycastle.jce.provider.X509SignatureUtil;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class X509CRLObject
extends X509CRL {
    private CertificateList c;
    private String sigAlgName;
    private byte[] sigAlgParams;
    private boolean isIndirect;

    public X509CRLObject(CertificateList certificateList) throws CRLException {
        this.c = certificateList;
        try {
            this.sigAlgName = X509SignatureUtil.getSignatureName(certificateList.getSignatureAlgorithm());
            this.sigAlgParams = (byte[])(certificateList.getSignatureAlgorithm().getParameters() != null ? ((ASN1Encodable)certificateList.getSignatureAlgorithm().getParameters()).getDEREncoded() : null);
            this.isIndirect = this.isIndirectCRL();
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        return set != null && !set.isEmpty();
    }

    private Set getExtensionOIDs(boolean bl) {
        if (this.getVersion() == 2) {
            HashSet<String> hashSet = new HashSet<String>();
            X509Extensions x509Extensions = this.c.getTBSCertList().getExtensions();
            Enumeration enumeration = x509Extensions.oids();
            while (enumeration.hasMoreElements()) {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)enumeration.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(dERObjectIdentifier);
                if (bl != x509Extension.isCritical()) continue;
                hashSet.add(dERObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public byte[] getExtensionValue(String string) {
        X509Extension x509Extension;
        X509Extensions x509Extensions = this.c.getTBSCertList().getExtensions();
        if (x509Extensions != null && (x509Extension = x509Extensions.getExtension(new DERObjectIdentifier(string))) != null) {
            try {
                return x509Extension.getValue().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(this.c);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, "BC");
    }

    @Override
    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (!this.c.getSignatureAlgorithm().equals(this.c.getTBSCertList().getSignature())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        Signature signature = Signature.getInstance(this.getSigAlgName(), string);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public int getVersion() {
        return this.c.getVersion();
    }

    @Override
    public Principal getIssuerDN() {
        return new X509Principal(this.c.getIssuer());
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.c.getIssuer());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getThisUpdate() {
        return this.c.getThisUpdate().getDate();
    }

    @Override
    public Date getNextUpdate() {
        if (this.c.getNextUpdate() != null) {
            return this.c.getNextUpdate().getDate();
        }
        return null;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        TBSCertList.CRLEntry[] cRLEntryArray = this.c.getRevokedCertificates();
        if (cRLEntryArray != null) {
            X500Principal x500Principal = this.getIssuerX500Principal();
            for (int i = 0; i < cRLEntryArray.length; ++i) {
                X509CRLEntryObject x509CRLEntryObject = new X509CRLEntryObject(cRLEntryArray[i], this.isIndirect, x500Principal);
                x500Principal = x509CRLEntryObject.getCertificateIssuer();
                if (!x509CRLEntryObject.getSerialNumber().equals(bigInteger)) continue;
                return x509CRLEntryObject;
            }
        }
        return null;
    }

    public Set getRevokedCertificates() {
        TBSCertList.CRLEntry[] cRLEntryArray = this.c.getRevokedCertificates();
        if (cRLEntryArray != null) {
            HashSet<X509CRLEntryObject> hashSet = new HashSet<X509CRLEntryObject>();
            X500Principal x500Principal = this.getIssuerX500Principal();
            for (int i = 0; i < cRLEntryArray.length; ++i) {
                X509CRLEntryObject x509CRLEntryObject = new X509CRLEntryObject(cRLEntryArray[i], this.isIndirect, x500Principal);
                hashSet.add(x509CRLEntryObject);
                x500Principal = x509CRLEntryObject.getCertificateIssuer();
            }
            return hashSet;
        }
        return null;
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.c.getTBSCertList().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.c.getSignature().getBytes();
    }

    @Override
    public String getSigAlgName() {
        return this.sigAlgName;
    }

    @Override
    public String getSigAlgOID() {
        return this.c.getSignatureAlgorithm().getObjectId().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.sigAlgParams != null) {
            byte[] byArray = new byte[this.sigAlgParams.length];
            System.arraycopy(this.sigAlgParams, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    @Override
    public String toString() {
        return "X.509 CRL";
    }

    @Override
    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new RuntimeException("X.509 CRL used with non X.509 Cert");
        }
        TBSCertList.CRLEntry[] cRLEntryArray = this.c.getRevokedCertificates();
        if (cRLEntryArray != null) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            for (int i = 0; i < cRLEntryArray.length; ++i) {
                if (!cRLEntryArray[i].getUserCertificate().getValue().equals(bigInteger)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIndirectCRL() throws CRLException {
        byte[] byArray = this.getExtensionValue(X509Extensions.IssuingDistributionPoint.getId());
        boolean bl = false;
        try {
            if (byArray != null) {
                bl = IssuingDistributionPoint.getInstance(X509ExtensionUtil.fromExtensionValue(byArray)).isIndirectCRL();
            }
        }
        catch (IOException iOException) {
            throw new ExtCRLException("Exception reading IssuingDistributionPoint", iOException);
        }
        return bl;
    }
}

