/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.update;

import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.TreeSet;
import jp.nyx.SecureSwitchUtility;
import jp.nyx.loader.NyxBootLoader;
import jp.nyx.update.NyxDownloadBean;
import jp.nyx.update.NyxDownloadItem;
import jp.nyx.update.NyxUpdateObserver;

public class NyxUpdate {
    private File nyxHome;
    private File updateDir;
    private NyxUpdateObserver obsever;

    public NyxUpdate(File nyxHome, File updateDir, NyxUpdateObserver obsever) throws IOException {
        this.nyxHome = nyxHome;
        this.updateDir = updateDir;
        this.obsever = obsever;
        if (!this.updateDir.canRead()) {
            throw new IOException("Don't read directory. " + this.updateDir);
        }
        if (!this.updateDir.isDirectory()) {
            throw new FileNotFoundException("Not directory. " + this.updateDir);
        }
    }

    public void update(NyxBootLoader loader) throws IOException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        double crtVer = SecureSwitchUtility.loadCrtKernelVersion(loader);
        TreeSet<File> list = new TreeSet<File>();
        File[] fl = this.updateDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !"0.0".equals(pathname.getName());
            }
        });
        list.addAll(Arrays.asList(fl));
        this.updateMain(list.toArray(new File[0]), crtVer);
    }

    private void updateMain(File[] nexts, double crtVer) throws IOException {
        SecureSwitchUtility.setUseAll(false);
        for (int i = 0; i < nexts.length; ++i) {
            File beanFile = new File(nexts[i], "update.list.xml");
            NyxDownloadBean bean = this.loadBean(beanFile);
            this.obsever.startUpdate(beanFile, bean, i + 1, nexts.length);
            boolean ignore = false;
            if (crtVer <= bean.getStartVar() || bean.getEndVar() < crtVer) {
                String message = "  Unmatch version. Current=" + crtVer + " target=" + bean.getStartVar() + " - " + bean.getEndVar();
                SecureSwitchUtility.getOut().println(message);
                if (!SecureSwitchUtility.getYesNo(" Ignore Update? > ", false)) {
                    this.obsever.endUpdate("Update Skip.");
                    continue;
                }
                ignore = true;
            }
            if (!ignore && !SecureSwitchUtility.getYesNo(" Update Start? > ", false)) {
                this.obsever.endUpdate("Update Skip.");
                continue;
            }
            NyxDownloadItem[] item = bean.getItems();
            SecureSwitchUtility.setUseAll(false);
            for (int j = 0; j < item.length; ++j) {
                String to = item[j].getTo().replace("${nyx.home}", this.nyxHome.getAbsolutePath());
                String from = to.trim().replace(this.nyxHome.getAbsolutePath(), "");
                File toFile = new File(to);
                File fromFile = new File(new File(this.updateDir, String.valueOf(bean.getCrtVar())), from);
                String message = fromFile.getAbsolutePath() + " => " + toFile.getAbsolutePath();
                this.obsever.startUpdateFile(item[j], message, j + 1, item.length);
                if (Depry.CONFIRM.code.equals(item[j].getDeply().trim()) && !SecureSwitchUtility.getYesNo("   Orverride? > ", true)) {
                    this.obsever.endUpdateFile("Skip.");
                    continue;
                }
                this.copy(fromFile, toFile);
                this.obsever.endUpdateFile("Copyed.");
            }
            this.obsever.endUpdate("Update Complete.");
        }
    }

    private NyxDownloadBean loadBean(File beanFile) throws IOException {
        XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(beanFile)));
        NyxDownloadBean bean = (NyxDownloadBean)decoder.readObject();
        decoder.close();
        return bean;
    }

    private void copy(File from, File to) throws IOException {
        FileChannel fromChan = new FileInputStream(from).getChannel();
        FileChannel toChan = new FileOutputStream(to).getChannel();
        fromChan.transferTo(0L, fromChan.size(), toChan);
        fromChan.close();
        toChan.close();
    }

    private static enum Depry {
        COPY("copy"),
        CONFIRM("confirm");

        private String code = "copy";

        private Depry(String code) {
            this.code = code;
        }
    }
}

