/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import java.util.Iterator;
import java.util.Vector;
import org.openxri.IRIUtils;
import org.openxri.Parsable;
import org.openxri.ParseStream;
import org.openxri.XRISegment;

public abstract class XRIPath
extends Parsable {
    Vector moSegments = new Vector();
    boolean mbAllowColon = true;

    XRIPath() {
    }

    XRIPath(String sVal) {
        super(sVal);
    }

    public int getNumSegments() {
        this.parse();
        return this.moSegments == null ? 0 : this.moSegments.size();
    }

    public Iterator getSegmentIterator() {
        this.parse();
        return this.moSegments == null ? null : this.moSegments.iterator();
    }

    public XRISegment getSegmentAt(int nIndex) {
        this.parse();
        if (this.moSegments == null || nIndex >= this.moSegments.size()) {
            return null;
        }
        return (XRISegment)this.moSegments.elementAt(nIndex);
    }

    void scanXRISegments(ParseStream oPathStream) {
        boolean bAllowColon = this.mbAllowColon;
        boolean bConsumed = true;
        while (!oPathStream.empty() && bConsumed) {
            XRISegment oSegment;
            boolean bStartsWithSlash;
            bConsumed = false;
            ParseStream oStream = oPathStream.begin();
            boolean bl = bStartsWithSlash = oStream.getData().charAt(0) == '/';
            if (bStartsWithSlash && this.moSegments.size() == 0 || !bStartsWithSlash && this.moSegments.size() > 0) break;
            if (bStartsWithSlash) {
                bConsumed = true;
                oStream.consume(1);
            }
            if ((oSegment = new XRISegment(true, bAllowColon, true)).scan(oStream)) {
                bConsumed = true;
                this.moSegments.add(oSegment);
            }
            oPathStream.end(oStream);
            bAllowColon = true;
        }
    }

    public String toIRINormalForm() {
        StringBuffer sValue = new StringBuffer();
        Iterator oIt = this.moSegments.iterator();
        if (oIt.hasNext()) {
            sValue.append(((XRISegment)oIt.next()).toIRINormalForm());
        }
        while (oIt.hasNext()) {
            sValue.append("/");
            sValue.append(((XRISegment)oIt.next()).toIRINormalForm());
        }
        return sValue.toString();
    }

    public String toURINormalForm() {
        return IRIUtils.IRItoURI(this.toIRINormalForm());
    }
}

