;;; DEMO

;;; 1. file browser

(defclass file ()
  (
   (name :accessor name :initarg :name )
   (date :accessor date :initarg :date )
   (size :accessor size :initarg :size )
   (owner :accessor owner :initarg :owner)
   (type :accessor type :initarg :type)
   )
  )


(defmethod display ((file file))
  (format t "{name:~A date:~A size:~A owner:~A type:~A}"
    (and (slot-boundp file 'name) (name file))
    (and (slot-boundp file 'date) (date file))
    (and (slot-boundp file 'size) (size file))
    (and (slot-boundp file 'owner) (owner file))
    (and (slot-boundp file 'type) (type file))
    )
  )

(setf 
 disk1
 (list
  (make-instance 'file :name "a1" :date "1998/4/12" :size 100 :owner 'omura :type 'file)
  (make-instance 'file :name "a2" :date "1998/4/12" :size 1000 :owner 'tanaka :type 'file)
  (make-instance 'file :name "a3" :date "1998/4/12" :size 1000 :owner 'yoshida :type 'file)
  (make-instance 'file :name "a4" :date "1998/4/13" :size 1002 :owner 'omura :type 'file)
  (make-instance 'file :name "a5" :date "1998/4/13" :size 10013 :owner 'omura :type 'file)
  (make-instance 'file :name "a6" :date "1998/4/13" :size 1055 :owner 'yoshida :type 'file)
  (make-instance 'file :name "a7" :date "1998/4/13" :size 546 :owner 'tanaka :type 'file)
  (make-instance 'file :name "a8" :date "1998/4/14" :size 2266 :owner 'yoshida :type 'file)
  (make-instance 'file :name "a9" :date "1998/4/14" :size 4786 :owner 'omura :type 'file)
  (make-instance 'file :name "a10" :date "1998/4/15" :size 5565 :owner 'yoshida :type 'file)
  (make-instance 'file :name "a11" :date "1998/4/16" :size 7898 :owner 'tanaka :type 'file)
  )
 )



(defclassifier
    browser-def1
    (owner ()
          (lambda (x) (owner x))
          (lambda (x) (slot-exists-boundp x 'owner)))
   (date ()
         (lambda (x) (date x))
         (lambda (x) (slot-exists-boundp x 'date)))
   
   )

(setf browser1 (make-classifier 'browser-def1))

(put-object* browser1 disk1)

(show browser1 'display)
